/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.clustering;

import org.apache.flink.ml.clustering.kmeans.KMeans;
import org.apache.flink.ml.clustering.kmeans.KMeansModel;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class KMeansExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource inputStream = env.fromElements((Object[])new DenseVector[]{Vectors.dense((double[])new double[]{0.0, 0.0}), Vectors.dense((double[])new double[]{0.0, 0.3}), Vectors.dense((double[])new double[]{0.3, 0.0}), Vectors.dense((double[])new double[]{9.0, 0.0}), Vectors.dense((double[])new double[]{9.0, 0.6}), Vectors.dense((double[])new double[]{9.6, 0.0})});
        Table inputTable = tEnv.fromDataStream((DataStream)inputStream).as("features", new String[0]);
        KMeans kmeans = (KMeans)((KMeans)new KMeans().setK(2)).setSeed(1L);
        KMeansModel kmeansModel = kmeans.fit(new Table[]{inputTable});
        Table outputTable = kmeansModel.transform(new Table[]{inputTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            DenseVector features = (DenseVector)row.getField(kmeans.getFeaturesCol());
            int clusterId = (Integer)row.getField(kmeans.getPredictionCol());
            System.out.printf("Features: %s \tCluster ID: %s\n", features, clusterId);
        }
    }
}

