/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.util.Arrays;
import org.apache.flink.ml.feature.ngram.NGram;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class NGramExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource inputStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{new String[0]}), Row.of((Object[])new Object[]{new String[]{"a", "b", "c"}}), Row.of((Object[])new Object[]{new String[]{"a", "b", "c", "d"}})});
        Table inputTable = tEnv.fromDataStream((DataStream)inputStream).as("input", new String[0]);
        NGram nGram = (NGram)((NGram)((NGram)new NGram().setN(2)).setInputCol("input")).setOutputCol("output");
        Table outputTable = nGram.transform(new Table[]{inputTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Object[] inputValue = (String[])row.getField(nGram.getInputCol());
            Object[] outputValue = (String[])row.getField(nGram.getOutputCol());
            System.out.printf("Input Value: %s \tOutput Value: %s\n", Arrays.toString(inputValue), Arrays.toString(outputValue));
        }
    }
}

