/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.clustering;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.clustering.kmeans.KMeansModelData;
import org.apache.flink.ml.clustering.kmeans.OnlineKMeans;
import org.apache.flink.ml.clustering.kmeans.OnlineKMeansModel;
import org.apache.flink.ml.examples.util.PeriodicSourceFunction;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class OnlineKMeansExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.setParallelism(4);
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        List<Row> trainData1 = Arrays.asList(Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{0.0, 0.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{0.0, 0.3})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{0.3, 0.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{9.0, 0.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{9.0, 0.6})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{9.6, 0.0})}));
        List<Row> trainData2 = Arrays.asList(Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{10.0, 100.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{10.0, 100.3})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{10.3, 100.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{-10.0, -100.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{-10.0, -100.6})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{-10.6, -100.0})}));
        List<Row> predictData = Arrays.asList(Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{10.0, 10.0})}), Row.of((Object[])new Object[]{Vectors.dense((double[])new double[]{-10.0, 10.0})}));
        PeriodicSourceFunction trainSource = new PeriodicSourceFunction(1000L, Arrays.asList(trainData1, trainData2));
        DataStreamSource trainStream = env.addSource((SourceFunction)trainSource, (TypeInformation)new RowTypeInfo(new TypeInformation[]{DenseVectorTypeInfo.INSTANCE}));
        Table trainTable = tEnv.fromDataStream((DataStream)trainStream).as("features", new String[0]);
        PeriodicSourceFunction predictSource = new PeriodicSourceFunction(1000L, Collections.singletonList(predictData));
        DataStreamSource predictStream = env.addSource((SourceFunction)predictSource, (TypeInformation)new RowTypeInfo(new TypeInformation[]{DenseVectorTypeInfo.INSTANCE}));
        Table predictTable = tEnv.fromDataStream((DataStream)predictStream).as("features", new String[0]);
        OnlineKMeans onlineKMeans = ((OnlineKMeans)((OnlineKMeans)((OnlineKMeans)new OnlineKMeans().setFeaturesCol("features")).setPredictionCol("prediction")).setGlobalBatchSize(Integer.valueOf(6))).setInitialModelData(KMeansModelData.generateRandomModelData((StreamTableEnvironment)tEnv, (int)2, (int)2, (double)0.0, (long)0L));
        OnlineKMeansModel onlineModel = onlineKMeans.fit(new Table[]{trainTable});
        Table outputTable = onlineModel.transform(new Table[]{predictTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row1 = (Row)it.next();
            DenseVector features1 = (DenseVector)row1.getField(onlineKMeans.getFeaturesCol());
            Integer clusterId1 = (Integer)row1.getField(onlineKMeans.getPredictionCol());
            Row row2 = (Row)it.next();
            DenseVector features2 = (DenseVector)row2.getField(onlineKMeans.getFeaturesCol());
            Integer clusterId2 = (Integer)row2.getField(onlineKMeans.getPredictionCol());
            if (Objects.equals(clusterId1, clusterId2)) {
                System.out.printf("%s and %s are now in the same cluster.\n", features1, features2);
                continue;
            }
            System.out.printf("%s and %s are now in different clusters.\n", features1, features2);
        }
    }
}

