/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.eventtime.SerializableTimestampAssigner;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.ml.common.window.EventTimeTumblingWindows;
import org.apache.flink.ml.common.window.Windows;
import org.apache.flink.ml.feature.standardscaler.OnlineStandardScaler;
import org.apache.flink.ml.feature.standardscaler.OnlineStandardScalerModel;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class OnlineStandardScalerExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        List<Row> inputData = Arrays.asList(Row.of((Object[])new Object[]{0L, Vectors.dense((double[])new double[]{-2.5, 9.0, 1.0})}), Row.of((Object[])new Object[]{1000L, Vectors.dense((double[])new double[]{1.4, -5.0, 1.0})}), Row.of((Object[])new Object[]{2000L, Vectors.dense((double[])new double[]{2.0, -1.0, -2.0})}), Row.of((Object[])new Object[]{6000L, Vectors.dense((double[])new double[]{0.7, 3.0, 1.0})}), Row.of((Object[])new Object[]{7000L, Vectors.dense((double[])new double[]{0.0, 1.0, 1.0})}), Row.of((Object[])new Object[]{8000L, Vectors.dense((double[])new double[]{0.5, 0.0, -2.0})}), Row.of((Object[])new Object[]{9000L, Vectors.dense((double[])new double[]{0.4, 1.0, 1.0})}), Row.of((Object[])new Object[]{10000L, Vectors.dense((double[])new double[]{0.3, 2.0, 1.0})}), Row.of((Object[])new Object[]{11000L, Vectors.dense((double[])new double[]{0.5, 1.0, -2.0})}));
        DataStreamSource inputStream = env.fromCollection(inputData);
        SingleOutputStreamOperator inputStreamWithEventTime = inputStream.assignTimestampsAndWatermarks(WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(element, recordTimestamp) -> (Long)element.getFieldAs(0)));
        Table inputTable = tEnv.fromDataStream((DataStream)inputStreamWithEventTime, Schema.newBuilder().column("f0", (AbstractDataType)DataTypes.BIGINT()).column("f1", (AbstractDataType)DataTypes.RAW((TypeInformation)DenseVectorTypeInfo.INSTANCE)).columnByMetadata("rowtime", "TIMESTAMP_LTZ(3)").watermark("rowtime", "SOURCE_WATERMARK()").build()).as("id", new String[]{"input"});
        long windowSizeMs = 3000L;
        OnlineStandardScaler onlineStandardScaler = (OnlineStandardScaler)new OnlineStandardScaler().setWindows((Windows)EventTimeTumblingWindows.of((Time)Time.milliseconds((long)windowSizeMs)));
        OnlineStandardScalerModel model = onlineStandardScaler.fit(new Table[]{inputTable});
        Table outputTable = model.transform(new Table[]{inputTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            DenseVector inputValue = (DenseVector)row.getField(onlineStandardScaler.getInputCol());
            DenseVector outputValue = (DenseVector)row.getField(onlineStandardScaler.getOutputCol());
            long modelVersion = (Long)row.getFieldAs(onlineStandardScaler.getModelVersionCol());
            System.out.printf("Input Value: %s\tOutput Value: %-65s\tModel Version: %s\n", inputValue, outputValue, modelVersion);
        }
    }
}

