/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import org.apache.flink.ml.feature.robustscaler.RobustScaler;
import org.apache.flink.ml.feature.robustscaler.RobustScalerModel;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class RobustScalerExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource trainStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{1, Vectors.dense((double[])new double[]{0.0, 0.0})}), Row.of((Object[])new Object[]{2, Vectors.dense((double[])new double[]{1.0, -1.0})}), Row.of((Object[])new Object[]{3, Vectors.dense((double[])new double[]{2.0, -2.0})}), Row.of((Object[])new Object[]{4, Vectors.dense((double[])new double[]{3.0, -3.0})}), Row.of((Object[])new Object[]{5, Vectors.dense((double[])new double[]{4.0, -4.0})}), Row.of((Object[])new Object[]{6, Vectors.dense((double[])new double[]{5.0, -5.0})}), Row.of((Object[])new Object[]{7, Vectors.dense((double[])new double[]{6.0, -6.0})}), Row.of((Object[])new Object[]{8, Vectors.dense((double[])new double[]{7.0, -7.0})}), Row.of((Object[])new Object[]{9, Vectors.dense((double[])new double[]{8.0, -8.0})})});
        Table trainTable = tEnv.fromDataStream((DataStream)trainStream).as("id", new String[]{"input"});
        RobustScaler robustScaler = (RobustScaler)((RobustScaler)((RobustScaler)((RobustScaler)((RobustScaler)new RobustScaler().setLower(Double.valueOf(0.25))).setUpper(Double.valueOf(0.75))).setRelativeError(0.001)).setWithScaling(true)).setWithCentering(true);
        RobustScalerModel model = robustScaler.fit(new Table[]{trainTable});
        Table outputTable = model.transform(new Table[]{trainTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            DenseVector inputValue = (DenseVector)row.getField(robustScaler.getInputCol());
            DenseVector outputValue = (DenseVector)row.getField(robustScaler.getOutputCol());
            System.out.printf("Input Value: %-15s\tOutput Value: %s\n", inputValue, outputValue);
        }
    }
}

