/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core;

import org.apache.flink.statefun.flink.core.StatefulFunctionsConfig;
import org.apache.flink.statefun.flink.core.StatefulFunctionsUniverse;
import org.apache.flink.statefun.flink.core.StatefulFunctionsUniverseProvider;
import org.apache.flink.statefun.flink.core.spi.Modules;
import org.apache.flink.util.Preconditions;

public final class StatefulFunctionsUniverses {
    public static StatefulFunctionsUniverse get(ClassLoader classLoader, StatefulFunctionsConfig configuration) {
        Preconditions.checkState((classLoader != null ? 1 : 0) != 0, (Object)"The class loader was not set.");
        Preconditions.checkState((configuration != null ? 1 : 0) != 0, (Object)"The configuration was not set.");
        StatefulFunctionsUniverseProvider provider = configuration.getProvider(classLoader);
        return provider.get(classLoader, configuration);
    }

    static final class ClassPathUniverseProvider
    implements StatefulFunctionsUniverseProvider {
        private static final long serialVersionUID = 1L;

        ClassPathUniverseProvider() {
        }

        @Override
        public StatefulFunctionsUniverse get(ClassLoader classLoader, StatefulFunctionsConfig configuration) {
            Modules modules = Modules.loadFromClassPath(configuration);
            return modules.createStatefulFunctionsUniverse();
        }
    }
}

