/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.functions;

import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.statefun.flink.core.backpressure.BackPressureValve;
import org.apache.flink.statefun.flink.core.di.Inject;
import org.apache.flink.statefun.flink.core.di.Label;
import org.apache.flink.statefun.flink.core.di.Lazy;
import org.apache.flink.statefun.flink.core.functions.AsyncMessageDecorator;
import org.apache.flink.statefun.flink.core.functions.PendingAsyncOperations;
import org.apache.flink.statefun.flink.core.functions.Reductions;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.metrics.FunctionDispatcherMetrics;
import org.apache.flink.statefun.flink.core.metrics.FunctionTypeMetrics;
import org.apache.flink.statefun.flink.core.metrics.FunctionTypeMetricsRepository;
import org.apache.flink.statefun.flink.core.queue.Locks;
import org.apache.flink.statefun.flink.core.queue.MpscQueue;
import org.apache.flink.statefun.sdk.Address;

final class AsyncSink {
    private final PendingAsyncOperations pendingAsyncOperations;
    private final Lazy<Reductions> reductions;
    private final Executor operatorMailbox;
    private final BackPressureValve backPressureValve;
    private final FunctionTypeMetricsRepository metricsRepository;
    private final FunctionDispatcherMetrics dispatcherMetrics;
    private final MpscQueue<Message> completed = new MpscQueue(32768, Locks.jdkReentrantLock());

    @Inject
    AsyncSink(PendingAsyncOperations pendingAsyncOperations, @Label(value="mailbox-executor") Executor operatorMailbox, @Label(value="reductions") Lazy<Reductions> reductions, @Label(value="backpressure-valve") BackPressureValve backPressureValve, @Label(value="function-metrics-repository") FunctionTypeMetricsRepository metricsRepository, @Label(value="function-dispatcher-metrics") FunctionDispatcherMetrics dispatcherMetrics) {
        this.pendingAsyncOperations = Objects.requireNonNull(pendingAsyncOperations);
        this.reductions = Objects.requireNonNull(reductions);
        this.operatorMailbox = Objects.requireNonNull(operatorMailbox);
        this.backPressureValve = Objects.requireNonNull(backPressureValve);
        this.metricsRepository = Objects.requireNonNull(metricsRepository);
        this.dispatcherMetrics = Objects.requireNonNull(dispatcherMetrics);
    }

    <T> void accept(Address sourceAddress, Message metadata, CompletableFuture<T> future) {
        long futureId = ThreadLocalRandom.current().nextLong();
        this.pendingAsyncOperations.add(sourceAddress, futureId, metadata);
        this.backPressureValve.notifyAsyncOperationRegistered();
        this.metricsRepository.getMetrics(sourceAddress.type()).asyncOperationRegistered();
        this.dispatcherMetrics.asyncOperationRegistered();
        future.whenComplete((result, throwable) -> this.enqueue(metadata, futureId, (Object)result, (Throwable)throwable));
    }

    void blockAddress(Address address) {
        this.backPressureValve.blockAddress(address);
        this.metricsRepository.getMetrics(address.type()).blockedAddress();
    }

    private <T> void enqueue(Message message, long futureId, T result, Throwable throwable) {
        AsyncMessageDecorator<T> decoratedMessage = new AsyncMessageDecorator<T>(this.pendingAsyncOperations, futureId, message, result, throwable);
        int size = this.completed.add(decoratedMessage);
        if (size == 1) {
            this.operatorMailbox.execute(this::drainOnOperatorThread);
        }
    }

    private void drainOnOperatorThread() {
        Message message;
        Deque<Message> batchOfCompletedFutures = this.completed.drainAll();
        Reductions reductions = this.reductions.get();
        while ((message = batchOfCompletedFutures.poll()) != null) {
            Address target = message.target();
            FunctionTypeMetrics functionMetrics = this.metricsRepository.getMetrics(target.type());
            if (this.backPressureValve.isAddressBlocked(target)) {
                functionMetrics.unblockedAddress();
            }
            this.backPressureValve.notifyAsyncOperationCompleted(target);
            functionMetrics.asyncOperationCompleted();
            this.dispatcherMetrics.asyncOperationCompleted();
            reductions.enqueue(message);
        }
        reductions.processEnvelopes();
    }
}

