/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.functions;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashMap;
import java.util.Objects;
import org.apache.flink.statefun.flink.common.SetContextClassLoader;
import org.apache.flink.statefun.flink.core.di.Inject;
import org.apache.flink.statefun.flink.core.di.Label;
import org.apache.flink.statefun.flink.core.functions.FunctionLoader;
import org.apache.flink.statefun.flink.core.functions.FunctionRepository;
import org.apache.flink.statefun.flink.core.functions.LiveFunction;
import org.apache.flink.statefun.flink.core.functions.StatefulFunction;
import org.apache.flink.statefun.flink.core.message.MessageFactory;
import org.apache.flink.statefun.flink.core.metrics.FuncionTypeMetricsFactory;
import org.apache.flink.statefun.flink.core.metrics.FunctionTypeMetrics;
import org.apache.flink.statefun.flink.core.metrics.FunctionTypeMetricsRepository;
import org.apache.flink.statefun.flink.core.state.FlinkStateBinder;
import org.apache.flink.statefun.flink.core.state.PersistedStates;
import org.apache.flink.statefun.flink.core.state.State;
import org.apache.flink.statefun.sdk.FunctionType;

final class StatefulFunctionRepository
implements FunctionRepository,
FunctionTypeMetricsRepository {
    private final ObjectOpenHashMap<FunctionType, StatefulFunction> instances = new ObjectOpenHashMap();
    private final State flinkState;
    private final FunctionLoader functionLoader;
    private final FuncionTypeMetricsFactory metricsFactory;
    private final MessageFactory messageFactory;

    @Inject
    StatefulFunctionRepository(@Label(value="function-loader") FunctionLoader functionLoader, @Label(value="function-metrics-factory") FuncionTypeMetricsFactory functionMetricsFactory, @Label(value="state") State state, MessageFactory messageFactory) {
        this.functionLoader = Objects.requireNonNull(functionLoader);
        this.metricsFactory = Objects.requireNonNull(functionMetricsFactory);
        this.flinkState = Objects.requireNonNull(state);
        this.messageFactory = Objects.requireNonNull(messageFactory);
    }

    @Override
    public LiveFunction get(FunctionType type) {
        StatefulFunction function = this.instances.get(type);
        if (function == null) {
            function = this.load(type);
            this.instances.put(type, function);
        }
        return function;
    }

    @Override
    public FunctionTypeMetrics getMetrics(FunctionType functionType) {
        return this.get(functionType).metrics();
    }

    private StatefulFunction load(FunctionType functionType) {
        org.apache.flink.statefun.sdk.StatefulFunction statefulFunction = this.functionLoader.load(functionType);
        try (SetContextClassLoader ignored = new SetContextClassLoader((Object)statefulFunction);){
            FlinkStateBinder stateBinderForType = new FlinkStateBinder(this.flinkState, functionType);
            PersistedStates.findReflectivelyAndBind(statefulFunction, stateBinderForType);
            FunctionTypeMetrics metrics = this.metricsFactory.forType(functionType);
            StatefulFunction statefulFunction2 = new StatefulFunction(statefulFunction, metrics, this.messageFactory);
            return statefulFunction2;
        }
    }
}

