/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.httpfn;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonPointer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.statefun.flink.common.json.Selectors;
import org.apache.flink.statefun.flink.core.httpfn.TransportClientConstants;
import org.apache.flink.statefun.sdk.TypeName;

public final class TransportClientSpec
implements Serializable {
    private static final JsonPointer FACTORY_KIND = JsonPointer.compile((String)"/type");
    private final TypeName factoryKind;
    private final ObjectNode specNode;

    public static TransportClientSpec fromJsonNode(ObjectNode node) {
        TypeName factoryKind = Selectors.optionalTextAt((JsonNode)node, (JsonPointer)FACTORY_KIND).map(TypeName::parseFrom).orElse(TransportClientConstants.ASYNC_CLIENT_FACTORY_TYPE);
        return new TransportClientSpec(factoryKind, node);
    }

    public TransportClientSpec(TypeName factoryKind, ObjectNode properties) {
        this.factoryKind = Objects.requireNonNull(factoryKind);
        this.specNode = Objects.requireNonNull(properties);
    }

    public TypeName factoryKind() {
        return this.factoryKind;
    }

    public ObjectNode specNode() {
        return this.specNode;
    }
}

