/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.httpfn;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.flink.util.Preconditions;

final class UnixDomainHttpEndpoint {
    final File unixDomainFile;
    final String pathSegment;

    static boolean validate(URI endpoint) {
        String scheme = endpoint.getScheme();
        return "http+unix".equalsIgnoreCase(scheme) || "https+unix".equalsIgnoreCase(scheme);
    }

    static UnixDomainHttpEndpoint parseFrom(URI endpoint) {
        Preconditions.checkArgument((boolean)UnixDomainHttpEndpoint.validate(endpoint));
        Path path = Paths.get(endpoint.getPath(), new String[0]);
        int sockPathIndex = UnixDomainHttpEndpoint.indexOfSockFile(path);
        String filePath = "/" + path.subpath(0, sockPathIndex + 1).toString();
        File unixDomainFile = new File(filePath);
        if (sockPathIndex == path.getNameCount() - 1) {
            return new UnixDomainHttpEndpoint(unixDomainFile, "/");
        }
        String pathSegment = "/" + path.subpath(sockPathIndex + 1, path.getNameCount()).toString();
        return new UnixDomainHttpEndpoint(unixDomainFile, pathSegment);
    }

    private static int indexOfSockFile(Path path) {
        for (int i = 0; i < path.getNameCount(); ++i) {
            if (!path.getName(i).toString().endsWith(".sock")) continue;
            return i;
        }
        throw new IllegalStateException("Unix Domain Socket path should contain a .sock file");
    }

    private UnixDomainHttpEndpoint(File unixDomainFile, String endpoint) {
        this.unixDomainFile = Objects.requireNonNull(unixDomainFile);
        this.pathSegment = Objects.requireNonNull(endpoint);
    }
}

