/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.jsonmodule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonPointer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.statefun.extensions.ComponentBinder;
import org.apache.flink.statefun.extensions.ComponentJsonObject;
import org.apache.flink.statefun.flink.common.json.Selectors;
import org.apache.flink.statefun.flink.core.spi.ExtensionResolver;
import org.apache.flink.statefun.flink.core.spi.ExtensionResolverAccessor;
import org.apache.flink.statefun.sdk.TypeName;
import org.apache.flink.statefun.sdk.spi.StatefulFunctionModule;

@Deprecated
public final class LegacyRemoteModuleV30
implements StatefulFunctionModule {
    private final JsonNode moduleSpecNode;
    private static final JsonPointer ENDPOINTS = JsonPointer.compile((String)"/endpoints");
    private static final JsonPointer INGRESSES = JsonPointer.compile((String)"/ingresses");
    private static final JsonPointer EGRESSES = JsonPointer.compile((String)"/egresses");
    private static final JsonPointer ENDPOINT_KIND = JsonPointer.compile((String)"/endpoint/meta/kind");
    private static final JsonPointer ENDPOINT_SPEC = JsonPointer.compile((String)"/endpoint/spec");
    private static final JsonPointer INGRESS_KIND = JsonPointer.compile((String)"/ingress/meta/type");
    private static final JsonPointer INGRESS_ID = JsonPointer.compile((String)"/ingress/meta/id");
    private static final JsonPointer INGRESS_SPEC = JsonPointer.compile((String)"/ingress/spec");
    private static final JsonPointer EGRESS_KIND = JsonPointer.compile((String)"/egress/meta/type");
    private static final JsonPointer EGRESS_ID = JsonPointer.compile((String)"/egress/meta/id");
    private static final JsonPointer EGRESS_SPEC = JsonPointer.compile((String)"/egress/spec");
    private static final Map<String, TypeName> LEGACY_KIND_CONVERSIONS = new HashMap<String, TypeName>();

    LegacyRemoteModuleV30(JsonNode moduleSpecNode) {
        this.moduleSpecNode = Objects.requireNonNull(moduleSpecNode);
    }

    public void configure(Map<String, String> globalConfiguration, StatefulFunctionModule.Binder moduleBinder) {
        LegacyRemoteModuleV30.components(this.moduleSpecNode).forEach(component -> LegacyRemoteModuleV30.bindComponent(component, moduleBinder));
    }

    private static Iterable<ComponentJsonObject> components(JsonNode moduleRootNode) {
        ArrayList<ComponentJsonObject> components = new ArrayList<ComponentJsonObject>();
        components.addAll(LegacyRemoteModuleV30.endpointComponents(moduleRootNode));
        components.addAll(LegacyRemoteModuleV30.ingressComponents(moduleRootNode));
        components.addAll(LegacyRemoteModuleV30.egressComponents(moduleRootNode));
        return components;
    }

    private static List<ComponentJsonObject> endpointComponents(JsonNode moduleRootNode) {
        Iterable endpointComponentNodes = Selectors.listAt((JsonNode)moduleRootNode, (JsonPointer)ENDPOINTS);
        return StreamSupport.stream(endpointComponentNodes.spliterator(), false).map(LegacyRemoteModuleV30::parseEndpointComponentNode).collect(Collectors.toList());
    }

    private static List<ComponentJsonObject> ingressComponents(JsonNode moduleRootNode) {
        Iterable ingressComponentNodes = Selectors.listAt((JsonNode)moduleRootNode, (JsonPointer)INGRESSES);
        return StreamSupport.stream(ingressComponentNodes.spliterator(), false).map(LegacyRemoteModuleV30::parseIngressComponentNode).collect(Collectors.toList());
    }

    private static List<ComponentJsonObject> egressComponents(JsonNode moduleRootNode) {
        Iterable egressComponentNodes = Selectors.listAt((JsonNode)moduleRootNode, (JsonPointer)EGRESSES);
        return StreamSupport.stream(egressComponentNodes.spliterator(), false).map(LegacyRemoteModuleV30::parseEgressComponentNode).collect(Collectors.toList());
    }

    private static ComponentJsonObject parseEndpointComponentNode(JsonNode node) {
        TypeName binderKind = LegacyRemoteModuleV30.tryConvertLegacyBinderKindTypeName(Selectors.textAt((JsonNode)node, (JsonPointer)ENDPOINT_KIND));
        return LegacyRemoteModuleV30.reconstructComponentJsonObject(binderKind, node.at(ENDPOINT_SPEC));
    }

    private static ComponentJsonObject parseIngressComponentNode(JsonNode node) {
        TypeName binderKind = LegacyRemoteModuleV30.tryConvertLegacyBinderKindTypeName(Selectors.textAt((JsonNode)node, (JsonPointer)INGRESS_KIND));
        JsonNode specNode = node.at(INGRESS_SPEC);
        String idString = Selectors.textAt((JsonNode)node, (JsonPointer)INGRESS_ID);
        ((ObjectNode)specNode).put("id", idString);
        return LegacyRemoteModuleV30.reconstructComponentJsonObject(binderKind, specNode);
    }

    private static ComponentJsonObject parseEgressComponentNode(JsonNode node) {
        TypeName binderKind = LegacyRemoteModuleV30.tryConvertLegacyBinderKindTypeName(Selectors.textAt((JsonNode)node, (JsonPointer)EGRESS_KIND));
        JsonNode specNode = node.at(EGRESS_SPEC);
        String idString = Selectors.textAt((JsonNode)node, (JsonPointer)EGRESS_ID);
        ((ObjectNode)specNode).put("id", idString);
        return LegacyRemoteModuleV30.reconstructComponentJsonObject(binderKind, specNode);
    }

    private static TypeName tryConvertLegacyBinderKindTypeName(String binderKindString) {
        TypeName binderKind = LEGACY_KIND_CONVERSIONS.get(binderKindString);
        if (binderKind != null) {
            return binderKind;
        }
        return TypeName.parseFrom((String)binderKindString);
    }

    private static ComponentJsonObject reconstructComponentJsonObject(TypeName binderTypename, JsonNode specJsonNode) {
        ObjectNode reconstructedNode = new ObjectMapper().createObjectNode();
        reconstructedNode.put("kind", binderTypename.canonicalTypenameString());
        reconstructedNode.set("spec", specJsonNode);
        return new ComponentJsonObject((JsonNode)reconstructedNode);
    }

    private static void bindComponent(ComponentJsonObject component, StatefulFunctionModule.Binder moduleBinder) {
        ExtensionResolver extensionResolver = ExtensionResolverAccessor.getExtensionResolver(moduleBinder);
        ComponentBinder componentBinder = extensionResolver.resolveExtension(component.binderTypename(), ComponentBinder.class);
        componentBinder.bind(component, moduleBinder);
    }

    static {
        LEGACY_KIND_CONVERSIONS.put("http", TypeName.parseFrom((String)"io.statefun.endpoints.v1/http"));
        LEGACY_KIND_CONVERSIONS.put("io.statefun.kafka/ingress", TypeName.parseFrom((String)"io.statefun.kafka.v1/ingress"));
        LEGACY_KIND_CONVERSIONS.put("io.statefun.kafka/egress", TypeName.parseFrom((String)"io.statefun.kafka.v1/egress"));
        LEGACY_KIND_CONVERSIONS.put("io.statefun.kinesis/ingress", TypeName.parseFrom((String)"io.statefun.kinesis.v1/ingress"));
        LEGACY_KIND_CONVERSIONS.put("io.statefun.kinesis/egress", TypeName.parseFrom((String)"io.statefun.kinesis.v1/egress"));
    }
}

