/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.types;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.statefun.flink.common.protobuf.ProtobufTypeInformation;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.message.MessageFactoryKey;
import org.apache.flink.statefun.flink.core.message.MessageTypeInformation;

@NotThreadSafe
public final class StaticallyRegisteredTypes {
    private final Map<Class<?>, TypeInformation<?>> registeredTypes = new HashMap();
    private final MessageFactoryKey messageFactoryKey;

    public StaticallyRegisteredTypes(MessageFactoryKey messageFactoryKey) {
        this.messageFactoryKey = messageFactoryKey;
    }

    public <T> TypeInformation<T> registerType(Class<T> type) {
        return this.registeredTypes.computeIfAbsent(type, this::typeInformation);
    }

    @Nullable
    <T> TypeInformation<T> getType(Class<T> valueType) {
        return this.registeredTypes.get(valueType);
    }

    private TypeInformation<?> typeInformation(Class<?> valueType) {
        if (com.google.protobuf.Message.class.isAssignableFrom(valueType)) {
            Class<?> message = valueType;
            return new ProtobufTypeInformation(message);
        }
        if (Message.class.isAssignableFrom(valueType)) {
            return new MessageTypeInformation(this.messageFactoryKey);
        }
        return TypeInformation.of(valueType);
    }
}

