/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.iteration.DataStreamList;
import org.apache.flink.iteration.IterationBody;
import org.apache.flink.iteration.IterationBodyResult;
import org.apache.flink.iteration.IterationConfig;
import org.apache.flink.iteration.IterationID;
import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.ReplayableDataStreamList;
import org.apache.flink.iteration.compile.DraftExecutionEnvironment;
import org.apache.flink.iteration.operator.HeadOperator;
import org.apache.flink.iteration.operator.HeadOperatorFactory;
import org.apache.flink.iteration.operator.InputOperator;
import org.apache.flink.iteration.operator.OperatorWrapper;
import org.apache.flink.iteration.operator.OutputOperator;
import org.apache.flink.iteration.operator.ReplayOperator;
import org.apache.flink.iteration.operator.TailOperator;
import org.apache.flink.iteration.operator.allround.AllRoundOperatorWrapper;
import org.apache.flink.iteration.operator.perround.PerRoundOperatorWrapper;
import org.apache.flink.iteration.typeinfo.IterationRecordTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.co.CoProcessFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

@Experimental
public class Iterations {
    public static DataStreamList iterateUnboundedStreams(DataStreamList initVariableStreams, DataStreamList dataStreams, IterationBody body) {
        return Iterations.createIteration(initVariableStreams, dataStreams, Collections.emptySet(), body, new AllRoundOperatorWrapper(), false);
    }

    public static DataStreamList iterateBoundedStreamsUntilTermination(DataStreamList initVariableStreams, ReplayableDataStreamList dataStreams, IterationConfig config, IterationBody body) {
        OperatorWrapper wrapper = config.getOperatorLifeCycle() == IterationConfig.OperatorLifeCycle.ALL_ROUND ? new AllRoundOperatorWrapper() : new PerRoundOperatorWrapper();
        ArrayList allDatastreams = new ArrayList();
        allDatastreams.addAll(dataStreams.getReplayedDataStreams());
        allDatastreams.addAll(dataStreams.getNonReplayedStreams());
        Set<Integer> replayedIndices = IntStream.range(0, dataStreams.getReplayedDataStreams().size()).boxed().collect(Collectors.toSet());
        return Iterations.createIteration(initVariableStreams, new DataStreamList(allDatastreams), replayedIndices, body, wrapper, true);
    }

    private static DataStreamList createIteration(DataStreamList initVariableStreams, DataStreamList dataStreams, Set<Integer> replayedDataStreamIndices, IterationBody body, OperatorWrapper<?, IterationRecord<?>> initialOperatorWrapper, boolean mayHaveCriteria) {
        Preconditions.checkState((initVariableStreams.size() > 0 ? 1 : 0) != 0, (Object)"There should be at least one variable stream");
        IterationID iterationId = new IterationID();
        List<TypeInformation<?>> initVariableTypeInfos = Iterations.getTypeInfos(initVariableStreams);
        List<TypeInformation<?>> dataStreamTypeInfos = Iterations.getTypeInfos(dataStreams);
        int totalInitVariableParallelism = Iterations.map(initVariableStreams, (DataStream<?> dataStream) -> dataStream.getParallelism() > 0 ? dataStream.getParallelism() : dataStream.getExecutionEnvironment().getConfig().getParallelism()).stream().mapToInt(i -> i).sum();
        DataStreamList initVariableInputs = Iterations.addInputs(initVariableStreams);
        DataStreamList headStreams = Iterations.addHeads(initVariableStreams, initVariableInputs, iterationId, totalInitVariableParallelism, false, 0);
        DataStreamList dataStreamInputs = Iterations.addInputs(dataStreams);
        if (replayedDataStreamIndices.size() > 0) {
            dataStreamInputs = Iterations.addReplayer(headStreams.get(0), dataStreams, dataStreamInputs, replayedDataStreamIndices);
        }
        StreamExecutionEnvironment env = initVariableStreams.get(0).getExecutionEnvironment();
        DraftExecutionEnvironment draftEnv = new DraftExecutionEnvironment(env, initialOperatorWrapper);
        DataStreamList draftHeadStreams = Iterations.addDraftSources(headStreams, draftEnv, initVariableTypeInfos);
        DataStreamList draftDataStreamInputs = Iterations.addDraftSources(dataStreamInputs, draftEnv, dataStreamTypeInfos);
        IterationBodyResult iterationBodyResult = body.process(draftHeadStreams, draftDataStreamInputs);
        Iterations.ensuresTransformationAdded(iterationBodyResult.getFeedbackVariableStreams(), draftEnv);
        Iterations.ensuresTransformationAdded(iterationBodyResult.getOutputStreams(), draftEnv);
        draftEnv.copyToActualEnvironment();
        DataStreamList feedbackStreams = Iterations.getActualDataStreams(iterationBodyResult.getFeedbackVariableStreams(), draftEnv);
        Preconditions.checkState((feedbackStreams.size() == initVariableStreams.size() ? 1 : 0) != 0, (Object)("The number of feedback streams " + feedbackStreams.size() + " does not match the initialized one " + initVariableStreams.size()));
        for (int i2 = 0; i2 < feedbackStreams.size(); ++i2) {
            Preconditions.checkState((feedbackStreams.get(i2).getParallelism() == headStreams.get(i2).getParallelism() ? 1 : 0) != 0, (Object)String.format("The feedback stream %d have different parallelism %d with the initial stream, which is %d", i2, feedbackStreams.get(i2).getParallelism(), headStreams.get(i2).getParallelism()));
        }
        DataStreamList tails = Iterations.addTails(feedbackStreams, iterationId, 0);
        for (int i3 = 0; i3 < headStreams.size(); ++i3) {
            String coLocationGroupKey = "co-" + iterationId.toHexString() + "-" + i3;
            headStreams.get(i3).getTransformation().setCoLocationGroupKey(coLocationGroupKey);
            tails.get(i3).getTransformation().setCoLocationGroupKey(coLocationGroupKey);
        }
        ArrayList tailsAndCriteriaTails = new ArrayList(tails.getDataStreams());
        Preconditions.checkState((mayHaveCriteria || iterationBodyResult.getTerminationCriteria() == null ? 1 : 0) != 0, (Object)"The current iteration type does not support the termination criteria.");
        if (iterationBodyResult.getTerminationCriteria() != null) {
            DataStreamList criteriaTails = Iterations.addCriteriaStream(iterationBodyResult.getTerminationCriteria(), iterationId, env, draftEnv, initVariableStreams, headStreams, totalInitVariableParallelism);
            tailsAndCriteriaTails.addAll(criteriaTails.getDataStreams());
        }
        DataStream<Integer> tailsUnion = Iterations.unionAllTails(env, new DataStreamList(tailsAndCriteriaTails));
        return Iterations.addOutputs(Iterations.getActualDataStreams(iterationBodyResult.getOutputStreams(), draftEnv), tailsUnion);
    }

    private static DataStreamList addReplayer(DataStream<?> firstHeadStream, DataStreamList originalDataStreams, DataStreamList dataStreamInputs, Set<Integer> replayedDataStreamIndices) {
        ArrayList result = new ArrayList(dataStreamInputs.size());
        for (int i = 0; i < dataStreamInputs.size(); ++i) {
            if (!replayedDataStreamIndices.contains(i)) {
                result.add(dataStreamInputs.get(i));
                continue;
            }
            SingleOutputStreamOperator replayedInput = dataStreamInputs.get(i).connect(((SingleOutputStreamOperator)firstHeadStream).getSideOutput(HeadOperator.ALIGN_NOTIFY_OUTPUT_TAG).broadcast()).transform("Replayer-" + originalDataStreams.get(i).getTransformation().getName(), dataStreamInputs.get(i).getType(), new ReplayOperator()).setParallelism(dataStreamInputs.get(i).getParallelism());
            result.add((DataStream<?>)replayedInput);
        }
        return new DataStreamList(result);
    }

    private static DataStreamList addCriteriaStream(DataStream<?> draftCriteriaStream, IterationID iterationId, StreamExecutionEnvironment env, DraftExecutionEnvironment draftEnv, DataStreamList initVariableStreams, DataStreamList headStreams, int totalInitVariableParallelism) {
        DataStream terminationCriteria = draftEnv.getActualStream(draftCriteriaStream.getId());
        Preconditions.checkState((boolean)terminationCriteria.getType().getClass().equals(IterationRecordTypeInfo.class), (Object)"The termination criteria should always return IterationRecord.");
        TypeInformation innerType = ((IterationRecordTypeInfo)terminationCriteria.getType()).getInnerTypeInfo();
        SingleOutputStreamOperator emptyCriteriaSource = env.addSource(new DraftExecutionEnvironment.EmptySource()).returns(innerType).name(terminationCriteria.getTransformation().getName()).setParallelism(terminationCriteria.getParallelism());
        DataStreamList criteriaSources = DataStreamList.of(new DataStream[]{emptyCriteriaSource});
        DataStreamList criteriaInputs = Iterations.addInputs(criteriaSources);
        DataStreamList criteriaHeaders = Iterations.addHeads(criteriaSources, criteriaInputs, iterationId, totalInitVariableParallelism, true, initVariableStreams.size());
        DataStream<?> mergedHeadAndCriteria = Iterations.mergeCriteriaHeadAndCriteriaStream(env, criteriaHeaders.get(0), terminationCriteria, innerType);
        DataStreamList criteriaTails = Iterations.addTails(DataStreamList.of(mergedHeadAndCriteria), iterationId, initVariableStreams.size());
        String coLocationGroupKey = "co-" + iterationId.toHexString() + "-cri";
        criteriaHeaders.get(0).getTransformation().setCoLocationGroupKey(coLocationGroupKey);
        criteriaTails.get(0).getTransformation().setCoLocationGroupKey(coLocationGroupKey);
        Iterations.setCriteriaParallelism(headStreams, terminationCriteria.getParallelism());
        Iterations.setCriteriaParallelism(criteriaHeaders, terminationCriteria.getParallelism());
        return criteriaTails;
    }

    private static DataStream<?> mergeCriteriaHeadAndCriteriaStream(StreamExecutionEnvironment env, DataStream<?> head, DataStream<?> criteriaStream, TypeInformation<?> criteriaStreamType) {
        DraftExecutionEnvironment criteriaDraftEnv = new DraftExecutionEnvironment(env, new AllRoundOperatorWrapper());
        DataStream<?> draftHeadStream = criteriaDraftEnv.addDraftSource(head, criteriaStreamType);
        DataStream<?> draftTerminationCriteria = criteriaDraftEnv.addDraftSource(criteriaStream, criteriaStreamType);
        SingleOutputStreamOperator draftMergedStream = draftHeadStream.connect(draftTerminationCriteria).process((CoProcessFunction)new CriteriaMergeProcessor()).returns(criteriaStreamType).setParallelism(criteriaStream.getParallelism() > 0 ? criteriaStream.getParallelism() : env.getConfig().getParallelism()).name("criteria-merge");
        criteriaDraftEnv.copyToActualEnvironment();
        return criteriaDraftEnv.getActualStream(draftMergedStream.getId());
    }

    private static DataStream<Integer> unionAllTails(StreamExecutionEnvironment env, DataStreamList tailsAndCriteriaTails) {
        return (DataStream)Iterations.map(tailsAndCriteriaTails, (DataStream<?> tail) -> tail.filter((FilterFunction & Serializable)r -> false).name("filter-tail").returns(Types.INT).setParallelism(tail.getParallelism() > 0 ? tail.getParallelism() : env.getConfig().getParallelism())).stream().reduce((rec$, xva$0) -> ((DataStream)rec$).union(new DataStream[]{xva$0})).get();
    }

    private static List<TypeInformation<?>> getTypeInfos(DataStreamList dataStreams) {
        return Iterations.map(dataStreams, DataStream::getType);
    }

    private static DataStreamList addInputs(DataStreamList dataStreams) {
        return new DataStreamList(Iterations.map(dataStreams, (DataStream<?> dataStream) -> dataStream.transform("input-" + dataStream.getTransformation().getName(), new IterationRecordTypeInfo(dataStream.getType()), new InputOperator()).setParallelism(dataStream.getParallelism())));
    }

    private static DataStreamList addHeads(DataStreamList variableStreams, DataStreamList inputStreams, IterationID iterationId, int totalInitVariableParallelism, boolean isCriteriaStream, int startHeaderIndex) {
        return new DataStreamList(Iterations.map(inputStreams, (Integer index, DataStream<?> dataStream) -> ((SingleOutputStreamOperator)dataStream).transform("head-" + variableStreams.get((int)index).getTransformation().getName(), (TypeInformation)((IterationRecordTypeInfo)dataStream.getType()), (OneInputStreamOperatorFactory)new HeadOperatorFactory(iterationId, startHeaderIndex + index, isCriteriaStream, totalInitVariableParallelism)).setParallelism(dataStream.getParallelism())));
    }

    private static DataStreamList addTails(DataStreamList dataStreams, IterationID iterationId, int startIndex) {
        return new DataStreamList(Iterations.map(dataStreams, (Integer index, DataStream<?> dataStream) -> {
            Transformation inputTransformation = dataStream.getTransformation();
            if (!(inputTransformation instanceof PhysicalTransformation) && inputTransformation.getInputs().size() > 1) {
                throw new UnsupportedOperationException("Tail operator should have only one input. Please check whether operator \"" + inputTransformation.getName() + "\" contains multiple inputs.");
            }
            return dataStream.transform("tail-" + dataStream.getTransformation().getName(), new IterationRecordTypeInfo(dataStream.getType()), (OneInputStreamOperator)new TailOperator(iterationId, startIndex + index)).setParallelism(dataStream.getParallelism());
        }));
    }

    private static DataStreamList addOutputs(DataStreamList dataStreams, DataStream tailsUnion) {
        return new DataStreamList(Iterations.map(dataStreams, (Integer index, DataStream<?> dataStream) -> {
            IterationRecordTypeInfo inputType = (IterationRecordTypeInfo)dataStream.getType();
            return dataStream.union(new DataStream[]{tailsUnion.map((MapFunction & Serializable)x -> x).name("tail-map-" + dataStream.getTransformation().getName()).returns((TypeInformation)inputType).setParallelism(1)}).transform("output-" + dataStream.getTransformation().getName(), inputType.getInnerTypeInfo(), new OutputOperator()).setParallelism(dataStream.getParallelism());
        }));
    }

    private static DataStreamList addDraftSources(DataStreamList dataStreams, DraftExecutionEnvironment draftEnv, List<TypeInformation<?>> typeInfos) {
        return new DataStreamList(Iterations.map(dataStreams, (Integer index, DataStream<?> dataStream) -> draftEnv.addDraftSource((DataStream<?>)dataStream, (TypeInformation)typeInfos.get((int)index))));
    }

    private static void ensuresTransformationAdded(DataStreamList dataStreams, DraftExecutionEnvironment draftEnv) {
        Iterations.map(dataStreams, (DataStream<?> dataStream) -> {
            draftEnv.addOperatorIfNotExists(dataStream.getTransformation());
            return null;
        });
    }

    private static void setCriteriaParallelism(DataStreamList headStreams, int criteriaParallelism) {
        Iterations.map(headStreams, (DataStream<?> dataStream) -> {
            ((HeadOperatorFactory)((OneInputTransformation)dataStream.getTransformation()).getOperatorFactory()).setCriteriaStreamParallelism(criteriaParallelism);
            return null;
        });
    }

    private static DataStreamList getActualDataStreams(DataStreamList draftStreams, DraftExecutionEnvironment draftEnv) {
        return new DataStreamList(Iterations.map(draftStreams, (DataStream<?> dataStream) -> draftEnv.getActualStream(dataStream.getId())));
    }

    private static <R> List<R> map(DataStreamList dataStreams, Function<DataStream<?>, R> mapper) {
        return Iterations.map(dataStreams, (Integer i, DataStream<?> dataStream) -> mapper.apply((DataStream<?>)dataStream));
    }

    private static <R> List<R> map(DataStreamList dataStreams, BiFunction<Integer, DataStream<?>, R> mapper) {
        ArrayList<R> results = new ArrayList<R>(dataStreams.size());
        for (int i = 0; i < dataStreams.size(); ++i) {
            DataStream dataStream = dataStreams.get(i);
            results.add(mapper.apply(i, dataStream));
        }
        return results;
    }

    private static class CriteriaMergeProcessor
    extends CoProcessFunction<Object, Object, Object> {
        private CriteriaMergeProcessor() {
        }

        public void processElement1(Object value, CoProcessFunction.Context ctx, Collector<Object> out) throws Exception {
        }

        public void processElement2(Object value, CoProcessFunction.Context ctx, Collector<Object> out) throws Exception {
            out.collect(value);
        }
    }
}

