/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.checkpoint;

import java.io.IOException;
import java.io.OutputStream;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.iteration.datacache.nonkeyed.DataCacheSnapshot;
import org.apache.flink.iteration.datacache.nonkeyed.DataCacheWriter;
import org.apache.flink.runtime.state.OperatorStateCheckpointOutputStream;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ResourceGuard;
import org.apache.flink.util.function.SupplierWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checkpoints<T>
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(Checkpoints.class);
    private final TypeSerializer<T> typeSerializer;
    private final FileSystem fileSystem;
    private final SupplierWithException<Path, IOException> pathSupplier;
    private final ConcurrentHashMap<Long, Tuple2<PendingCheckpoint, Boolean>> uncompletedCheckpoints = new ConcurrentHashMap();
    private final TreeMap<Long, PendingCheckpoint> sortedUncompletedCheckpoints = new TreeMap();
    private long latestCompletedCheckpointId;

    public Checkpoints(TypeSerializer<T> typeSerializer, FileSystem fileSystem, SupplierWithException<Path, IOException> pathSupplier) {
        this.typeSerializer = typeSerializer;
        this.fileSystem = fileSystem;
        Preconditions.checkState((!fileSystem.isDistributedFS() ? 1 : 0) != 0, (Object)"Currently only local fs is supported");
        this.pathSupplier = pathSupplier;
    }

    public TypeSerializer<T> getTypeSerializer() {
        return this.typeSerializer;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public SupplierWithException<Path, IOException> getPathSupplier() {
        return this.pathSupplier;
    }

    public void startLogging(long checkpointId, OperatorStateCheckpointOutputStream outputStream) throws IOException {
        if (checkpointId <= this.latestCompletedCheckpointId) {
            return;
        }
        Tuple2 possibleCheckpoint = this.uncompletedCheckpoints.computeIfAbsent(checkpointId, ignored -> {
            try {
                DataCacheWriter<T> dataCacheWriter = new DataCacheWriter<T>(this.typeSerializer, this.fileSystem, this.pathSupplier);
                ResourceGuard.Lease snapshotLease = outputStream.acquireLease();
                return new Tuple2((Object)new PendingCheckpoint(dataCacheWriter, outputStream, snapshotLease), (Object)false);
            }
            catch (IOException e) {
                throw new FlinkRuntimeException((Throwable)e);
            }
        });
        if (((Boolean)possibleCheckpoint.f1).booleanValue()) {
            return;
        }
        this.sortedUncompletedCheckpoints.put(checkpointId, (PendingCheckpoint)possibleCheckpoint.f0);
    }

    public void abort(long checkpointId) {
        this.uncompletedCheckpoints.compute(checkpointId, (k, v) -> {
            if (v == null) {
                return new Tuple2(null, (Object)true);
            }
            ((PendingCheckpoint)v.f0).snapshotLease.close();
            return new Tuple2((Object)((PendingCheckpoint)v.f0), (Object)true);
        });
    }

    public void append(T element) throws IOException {
        for (PendingCheckpoint pendingCheckpoint : this.sortedUncompletedCheckpoints.values()) {
            pendingCheckpoint.dataCacheWriter.addRecord(element);
        }
    }

    public void commitCheckpointsUntil(long checkpointId) {
        if (this.latestCompletedCheckpointId < checkpointId) {
            this.latestCompletedCheckpointId = checkpointId;
        }
        NavigableMap<Long, PendingCheckpoint> completedCheckpoints = this.sortedUncompletedCheckpoints.headMap(checkpointId, true);
        completedCheckpoints.values().forEach(pendingCheckpoint -> {
            try {
                pendingCheckpoint.dataCacheWriter.finish();
                pendingCheckpoint.dataCacheWriter.writeSegmentsToFiles();
                DataCacheSnapshot snapshot = new DataCacheSnapshot(this.fileSystem, null, pendingCheckpoint.dataCacheWriter.getSegments());
                pendingCheckpoint.checkpointOutputStream.startNewPartition();
                snapshot.writeTo((OutputStream)pendingCheckpoint.checkpointOutputStream);
                pendingCheckpoint.dataCacheWriter.clear();
            }
            catch (Exception e) {
                LOG.error("Failed to commit checkpoint until " + checkpointId, (Throwable)e);
                throw new FlinkRuntimeException((Throwable)e);
            }
            finally {
                pendingCheckpoint.snapshotLease.close();
            }
        });
        completedCheckpoints.clear();
    }

    @Override
    public void close() {
        this.sortedUncompletedCheckpoints.forEach((checkpointId, pendingCheckpoint) -> {
            pendingCheckpoint.snapshotLease.close();
            try {
                pendingCheckpoint.dataCacheWriter.clear();
            }
            catch (IOException e) {
                LOG.error("Failed to cleanup " + checkpointId, (Throwable)e);
            }
        });
        this.sortedUncompletedCheckpoints.clear();
        this.uncompletedCheckpoints.clear();
    }

    private class PendingCheckpoint {
        final DataCacheWriter<T> dataCacheWriter;
        final OperatorStateCheckpointOutputStream checkpointOutputStream;
        final ResourceGuard.Lease snapshotLease;

        public PendingCheckpoint(DataCacheWriter<T> dataCacheWriter, OperatorStateCheckpointOutputStream checkpointOutputStream, ResourceGuard.Lease snapshotLease) {
            this.dataCacheWriter = dataCacheWriter;
            this.checkpointOutputStream = checkpointOutputStream;
            this.snapshotLease = snapshotLease;
        }
    }
}

