/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.iteration.IterationID;
import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.broadcast.BroadcastOutput;
import org.apache.flink.iteration.broadcast.BroadcastOutputFactory;
import org.apache.flink.iteration.checkpoint.Checkpoints;
import org.apache.flink.iteration.checkpoint.CheckpointsBroker;
import org.apache.flink.iteration.datacache.nonkeyed.DataCacheSnapshot;
import org.apache.flink.iteration.operator.HeadOperatorCheckpointAligner;
import org.apache.flink.iteration.operator.OperatorStateUtils;
import org.apache.flink.iteration.operator.OperatorUtils;
import org.apache.flink.iteration.operator.event.CoordinatorCheckpointEvent;
import org.apache.flink.iteration.operator.event.GloballyAlignedEvent;
import org.apache.flink.iteration.operator.event.SubtaskAlignedEvent;
import org.apache.flink.iteration.operator.event.TerminatingOnInitializeEvent;
import org.apache.flink.iteration.operator.headprocessor.HeadOperatorRecordProcessor;
import org.apache.flink.iteration.operator.headprocessor.HeadOperatorState;
import org.apache.flink.iteration.operator.headprocessor.RegularHeadOperatorRecordProcessor;
import org.apache.flink.iteration.operator.headprocessor.TerminatingHeadOperatorRecordProcessor;
import org.apache.flink.iteration.typeinfo.IterationRecordTypeInfo;
import org.apache.flink.iteration.utils.ReflectionUtils;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumerWithPartialRecordLength;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartitionView;
import org.apache.flink.runtime.io.network.partition.PrioritizedDeque;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.LocalInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.operators.coordination.OperatorEventGateway;
import org.apache.flink.runtime.operators.coordination.OperatorEventHandler;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StatePartitionStreamProvider;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.statefun.flink.core.feedback.FeedbackChannel;
import org.apache.flink.statefun.flink.core.feedback.FeedbackChannelBroker;
import org.apache.flink.statefun.flink.core.feedback.FeedbackConsumer;
import org.apache.flink.statefun.flink.core.feedback.FeedbackKey;
import org.apache.flink.statefun.flink.core.feedback.SubtaskFeedbackKey;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.mailbox.TaskMailbox;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingRunnable;

public class HeadOperator
extends AbstractStreamOperator<IterationRecord<?>>
implements OneInputStreamOperator<IterationRecord<?>, IterationRecord<?>>,
FeedbackConsumer<StreamRecord<IterationRecord<?>>>,
OperatorEventHandler,
BoundedOneInput {
    public static final OutputTag<IterationRecord<Void>> ALIGN_NOTIFY_OUTPUT_TAG = new OutputTag("aligned", new IterationRecordTypeInfo(BasicTypeInfo.VOID_TYPE_INFO));
    private final IterationID iterationId;
    private final int feedbackIndex;
    private final boolean isCriteriaStream;
    private final OperatorEventGateway operatorEventGateway;
    private final MailboxExecutorWithYieldTimeout mailboxExecutor;
    private transient BroadcastOutput<?> eventBroadcastOutput;
    private transient ContextImpl processorContext;
    private HeadOperatorStatus status;
    private HeadOperatorRecordProcessor recordProcessor;
    private HeadOperatorCheckpointAligner checkpointAligner;
    private ListState<Integer> parallelismState;
    private ListState<Integer> statusState;
    private ListState<HeadOperatorState> processorState;
    private Checkpoints<IterationRecord<?>> checkpoints;

    public HeadOperator(IterationID iterationId, int feedbackIndex, boolean isCriteriaStream, MailboxExecutor mailboxExecutor, OperatorEventGateway operatorEventGateway, ProcessingTimeService processingTimeService) {
        this.iterationId = Objects.requireNonNull(iterationId);
        this.feedbackIndex = feedbackIndex;
        this.isCriteriaStream = isCriteriaStream;
        this.mailboxExecutor = new MailboxExecutorWithYieldTimeout(Objects.requireNonNull(mailboxExecutor));
        this.operatorEventGateway = Objects.requireNonNull(operatorEventGateway);
        this.processingTimeService = processingTimeService;
    }

    public void setup(StreamTask<?, ?> containingTask, StreamConfig config, Output<StreamRecord<IterationRecord<?>>> output) {
        super.setup(containingTask, config, output);
        this.eventBroadcastOutput = BroadcastOutputFactory.createBroadcastOutput(output, this.metrics.getIOMetricGroup().getNumRecordsOutCounter());
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.parallelismState = context.getOperatorStateStore().getUnionListState(new ListStateDescriptor("parallelism", (TypeSerializer)IntSerializer.INSTANCE));
        OperatorStateUtils.getUniqueElement(this.parallelismState, "parallelism").ifPresent(oldParallelism -> Preconditions.checkState((oldParallelism.intValue() == this.getRuntimeContext().getNumberOfParallelSubtasks() ? 1 : 0) != 0, (Object)("The head operator is recovered with parallelism changed from " + oldParallelism + " to " + this.getRuntimeContext().getNumberOfParallelSubtasks())));
        this.processorContext = new ContextImpl();
        this.statusState = context.getOperatorStateStore().getListState(new ListStateDescriptor("status", Integer.class));
        this.status = HeadOperatorStatus.values()[OperatorStateUtils.getUniqueElement(this.statusState, "status").orElse(0)];
        this.recordProcessor = this.status == HeadOperatorStatus.RUNNING ? new RegularHeadOperatorRecordProcessor(this.processorContext) : new TerminatingHeadOperatorRecordProcessor(this.processorContext);
        this.processorState = context.getOperatorStateStore().getListState(new ListStateDescriptor("processorState", HeadOperatorState.TYPE_INFO));
        OperatorStateUtils.getUniqueElement(this.processorState, "processorState").ifPresent(headOperatorState -> this.recordProcessor.initializeState((HeadOperatorState)headOperatorState, context.getRawOperatorStateInputs()));
        this.checkpointAligner = new HeadOperatorCheckpointAligner();
        Path dataCachePath = OperatorUtils.getDataCachePath(this.getRuntimeContext().getTaskManagerRuntimeInfo().getConfiguration(), this.getContainingTask().getEnvironment().getIOManager().getSpillingDirectoriesPaths());
        this.checkpoints = new Checkpoints(this.config.getTypeSerializerOut(((Object)((Object)this)).getClass().getClassLoader()), dataCachePath.getFileSystem(), OperatorUtils.createDataCacheFileGenerator(dataCachePath, "header-cp", this.getOperatorConfig().getOperatorID()));
        CheckpointsBroker.get().setCheckpoints(OperatorUtils.createFeedbackKey(this.iterationId, this.feedbackIndex).withSubTaskIndex(this.getRuntimeContext().getIndexOfThisSubtask(), this.getRuntimeContext().getAttemptNumber()), this.checkpoints);
        try {
            for (StatePartitionStreamProvider rawStateInput : context.getRawOperatorStateInputs()) {
                DataCacheSnapshot.replay(rawStateInput.getStream(), this.checkpoints.getTypeSerializer(), record -> this.recordProcessor.processFeedbackElement(new StreamRecord(record)));
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to replay the records", (Throwable)e);
        }
        this.registerFeedbackConsumer(runnable -> {
            if (this.status != HeadOperatorStatus.TERMINATED) {
                this.mailboxExecutor.execute(runnable::run, "Head feedback");
            }
        });
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        super.prepareSnapshotPreBarrier(checkpointId);
        this.checkpointAligner.waitTillCoordinatorNotified(this.status, checkpointId, this.mailboxExecutor::yield);
    }

    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.parallelismState.clear();
        if (this.getRuntimeContext().getIndexOfThisSubtask() == 0) {
            this.parallelismState.update(Collections.singletonList(this.getRuntimeContext().getNumberOfParallelSubtasks()));
        }
        this.statusState.update(Collections.singletonList(this.status.ordinal()));
        HeadOperatorState currentProcessorState = this.recordProcessor.snapshotState();
        this.processorState.update(Collections.singletonList(currentProcessorState));
        if (this.status == HeadOperatorStatus.RUNNING) {
            this.checkpoints.startLogging(context.getCheckpointId(), context.getRawOperatorStateOutput());
        }
        this.checkpointAligner.onStateSnapshot(context.getCheckpointId()).forEach(this::processGloballyAlignedEvent);
    }

    public void notifyCheckpointAborted(long checkpointId) throws Exception {
        super.notifyCheckpointAborted(checkpointId);
        this.checkpointAligner.onCheckpointAborted(checkpointId).forEach(this::processGloballyAlignedEvent);
    }

    public void processElement(StreamRecord<IterationRecord<?>> element) throws Exception {
        this.recordProcessor.processElement(element);
    }

    public void processFeedback(StreamRecord<IterationRecord<?>> iterationRecord) throws Exception {
        if (((IterationRecord)iterationRecord.getValue()).getType() == IterationRecord.Type.BARRIER) {
            this.checkpoints.commitCheckpointsUntil(((IterationRecord)iterationRecord.getValue()).getCheckpointId());
            return;
        }
        this.checkpoints.append((IterationRecord)iterationRecord.getValue());
        boolean terminated = this.recordProcessor.processFeedbackElement(iterationRecord);
        if (terminated) {
            Preconditions.checkState((this.status == HeadOperatorStatus.TERMINATING ? 1 : 0) != 0);
            this.status = HeadOperatorStatus.TERMINATED;
        }
    }

    public void handleOperatorEvent(OperatorEvent operatorEvent) {
        if (operatorEvent instanceof GloballyAlignedEvent) {
            this.checkpointAligner.checkHoldingGloballyAlignedEvent((GloballyAlignedEvent)operatorEvent).ifPresent(this::processGloballyAlignedEvent);
        } else if (operatorEvent instanceof CoordinatorCheckpointEvent) {
            this.checkpointAligner.coordinatorNotify((CoordinatorCheckpointEvent)operatorEvent);
        } else {
            throw new FlinkRuntimeException("Unsupported operator event: " + operatorEvent);
        }
    }

    private void processGloballyAlignedEvent(GloballyAlignedEvent globallyAlignedEvent) {
        boolean shouldTerminate = this.recordProcessor.onGloballyAligned(globallyAlignedEvent);
        if (shouldTerminate) {
            this.status = HeadOperatorStatus.TERMINATING;
            this.recordProcessor = new TerminatingHeadOperatorRecordProcessor(this.processorContext);
        }
    }

    public void endInput() throws Exception {
        if (this.status == HeadOperatorStatus.RUNNING) {
            this.recordProcessor.processElement(new StreamRecord(IterationRecord.newEpochWatermark(0, "fake")));
        }
        Preconditions.checkState((this.getContainingTask().getEnvironment().getAllInputGates().length == 1 ? 1 : 0) != 0);
        Preconditions.checkState((this.getContainingTask().getEnvironment().getAllInputGates()[0].getNumberOfInputChannels() == 1 ? 1 : 0) != 0);
        InputChannel inputChannel = this.getContainingTask().getEnvironment().getAllInputGates()[0].getChannel(0);
        boolean endOfPartitionReceived = false;
        long lastTriggerCheckpointId = 0L;
        while (!endOfPartitionReceived && this.status != HeadOperatorStatus.TERMINATED) {
            this.mailboxExecutor.yield(200L, TimeUnit.MILLISECONDS);
            List<AbstractEvent> events = this.parseInputChannelEvents(inputChannel);
            for (AbstractEvent event : events) {
                if (event instanceof CheckpointBarrier) {
                    CheckpointBarrier barrier = (CheckpointBarrier)event;
                    if (barrier.getId() <= lastTriggerCheckpointId) continue;
                    this.getContainingTask().triggerCheckpointAsync(new CheckpointMetaData(barrier.getId(), barrier.getTimestamp()), barrier.getCheckpointOptions());
                    lastTriggerCheckpointId = barrier.getId();
                    continue;
                }
                if (!(event instanceof EndOfPartitionEvent)) continue;
                endOfPartitionReceived = true;
            }
        }
        while (this.status != HeadOperatorStatus.TERMINATED) {
            this.mailboxExecutor.yield();
        }
    }

    public void close() throws Exception {
        if (this.checkpoints != null) {
            this.checkpoints.close();
        }
    }

    private void registerFeedbackConsumer(Executor mailboxExecutor) {
        int indexOfThisSubtask = this.getRuntimeContext().getIndexOfThisSubtask();
        int attemptNum = this.getRuntimeContext().getAttemptNumber();
        FeedbackKey feedbackKey = OperatorUtils.createFeedbackKey(this.iterationId, this.feedbackIndex);
        SubtaskFeedbackKey key = feedbackKey.withSubTaskIndex(indexOfThisSubtask, attemptNum);
        FeedbackChannelBroker broker = FeedbackChannelBroker.get();
        FeedbackChannel channel = broker.getChannel(key);
        OperatorUtils.registerFeedbackConsumer(channel, this, mailboxExecutor);
    }

    private List<AbstractEvent> parseInputChannelEvents(InputChannel inputChannel) throws Exception {
        ArrayList<AbstractEvent> events = new ArrayList<AbstractEvent>();
        if (inputChannel instanceof RemoteInputChannel) {
            Class<?> seqBufferClass = Class.forName("org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel$SequenceBuffer");
            PrioritizedDeque queue = (PrioritizedDeque)ReflectionUtils.getFieldValue(inputChannel, RemoteInputChannel.class, "receivedBuffers");
            for (Object sequenceBuffer : queue) {
                Buffer buffer = (Buffer)ReflectionUtils.getFieldValue(sequenceBuffer, seqBufferClass, "buffer");
                if (buffer.isBuffer()) continue;
                events.add(EventSerializer.fromBuffer((Buffer)buffer, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
            }
        } else if (inputChannel instanceof LocalInputChannel) {
            PipelinedSubpartitionView subpartitionView = (PipelinedSubpartitionView)ReflectionUtils.getFieldValue(inputChannel, LocalInputChannel.class, "subpartitionView");
            PipelinedSubpartition pipelinedSubpartition = (PipelinedSubpartition)ReflectionUtils.getFieldValue(subpartitionView, PipelinedSubpartitionView.class, "parent");
            PrioritizedDeque queue = (PrioritizedDeque)ReflectionUtils.getFieldValue(pipelinedSubpartition, PipelinedSubpartition.class, "buffers");
            for (BufferConsumerWithPartialRecordLength bufferConsumer : queue) {
                if (bufferConsumer.getBufferConsumer().isBuffer()) continue;
                events.add(EventSerializer.fromBuffer((Buffer)bufferConsumer.getBufferConsumer().copy().build(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
            }
        } else {
            LOG.warn("Unknown input channel type: " + inputChannel);
        }
        return events;
    }

    @VisibleForTesting
    public OperatorEventGateway getOperatorEventGateway() {
        return this.operatorEventGateway;
    }

    @VisibleForTesting
    MailboxExecutor getMailboxExecutor() {
        return this.mailboxExecutor;
    }

    @VisibleForTesting
    HeadOperatorRecordProcessor getRecordProcessor() {
        return this.recordProcessor;
    }

    @VisibleForTesting
    public HeadOperatorStatus getStatus() {
        return this.status;
    }

    private static class MailboxExecutorWithYieldTimeout
    implements MailboxExecutor {
        private final MailboxExecutor mailboxExecutor;
        private final Timer timer;

        private MailboxExecutorWithYieldTimeout(MailboxExecutor mailboxExecutor) {
            this.mailboxExecutor = mailboxExecutor;
            this.timer = new Timer(true);
        }

        public void execute(ThrowingRunnable<? extends Exception> command, String descriptionFormat, Object ... descriptionArgs) {
            this.mailboxExecutor.execute(command, descriptionFormat, descriptionArgs);
        }

        public void yield() throws InterruptedException, FlinkRuntimeException {
            this.mailboxExecutor.yield();
        }

        public boolean tryYield() throws FlinkRuntimeException {
            return this.mailboxExecutor.tryYield();
        }

        private void yield(long time, TimeUnit unit) throws InterruptedException {
            if (this.mailboxExecutor.tryYield()) {
                return;
            }
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    block2: {
                        try {
                            mailboxExecutor.execute(() -> {}, "NoOp runnable to trigger yield timeout");
                        }
                        catch (RejectedExecutionException e) {
                            if (e.getCause() instanceof TaskMailbox.MailboxClosedException) break block2;
                            throw e;
                        }
                    }
                }
            }, unit.toMillis(time));
            this.mailboxExecutor.yield();
        }
    }

    private class ContextImpl
    implements HeadOperatorRecordProcessor.Context {
        private ContextImpl() {
        }

        @Override
        public StreamConfig getStreamConfig() {
            return HeadOperator.this.config;
        }

        @Override
        public TaskInfo getTaskInfo() {
            return HeadOperator.this.getContainingTask().getEnvironment().getTaskInfo();
        }

        @Override
        public void output(StreamRecord<IterationRecord<?>> record) {
            HeadOperator.this.output.collect(record);
        }

        @Override
        public void output(OutputTag<IterationRecord<?>> outputTag, StreamRecord<IterationRecord<?>> record) {
            HeadOperator.this.output.collect(outputTag, record);
        }

        @Override
        public void broadcastOutput(StreamRecord<IterationRecord<?>> record) {
            try {
                HeadOperator.this.eventBroadcastOutput.broadcastEmit(record);
            }
            catch (IOException e) {
                throw new FlinkRuntimeException("Failed to broadcast event", (Throwable)e);
            }
        }

        @Override
        public void updateEpochToCoordinator(int epoch, long numFeedbackRecords) {
            HeadOperator.this.operatorEventGateway.sendEventToCoordinator((OperatorEvent)new SubtaskAlignedEvent(epoch, numFeedbackRecords, HeadOperator.this.isCriteriaStream));
        }

        @Override
        public void notifyTerminatingOnInitialize() {
            HeadOperator.this.operatorEventGateway.sendEventToCoordinator((OperatorEvent)TerminatingOnInitializeEvent.INSTANCE);
        }
    }

    @VisibleForTesting
    static enum HeadOperatorStatus {
        RUNNING,
        TERMINATING,
        TERMINATED;

    }
}

