/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator;

import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class OutputOperator<T>
extends AbstractStreamOperator<T>
implements OneInputStreamOperator<IterationRecord<T>, T> {
    private transient StreamRecord<T> reusable;

    public OutputOperator() {
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    public void open() throws Exception {
        super.open();
        this.reusable = new StreamRecord(null);
    }

    public void processElement(StreamRecord<IterationRecord<T>> streamRecord) throws Exception {
        if (((IterationRecord)streamRecord.getValue()).getType() == IterationRecord.Type.RECORD) {
            this.reusable.replace(((IterationRecord)streamRecord.getValue()).getValue(), streamRecord.getTimestamp());
            this.output.collect(this.reusable);
        } else if (((IterationRecord)streamRecord.getValue()).getType() == IterationRecord.Type.EPOCH_WATERMARK && ((IterationRecord)streamRecord.getValue()).getEpoch() == Integer.MAX_VALUE) {
            this.output.emitWatermark(new Watermark(Long.MAX_VALUE));
        }
    }
}

