/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.broadcast.operator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.IteratorUtils;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.iteration.datacache.nonkeyed.DataCacheReader;
import org.apache.flink.iteration.datacache.nonkeyed.DataCacheSnapshot;
import org.apache.flink.iteration.datacache.nonkeyed.DataCacheWriter;
import org.apache.flink.iteration.datacache.nonkeyed.Segment;
import org.apache.flink.iteration.operator.OperatorUtils;
import org.apache.flink.iteration.proxy.state.ProxyStreamOperatorStateContext;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.ml.common.broadcast.BroadcastContext;
import org.apache.flink.ml.common.broadcast.BroadcastStreamingRuntimeContext;
import org.apache.flink.ml.common.broadcast.typeinfo.CacheElement;
import org.apache.flink.ml.common.broadcast.typeinfo.CacheElementSerializer;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.groups.InternalOperatorIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.InternalOperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.operators.coordination.OperatorEventDispatcher;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.OperatorStateCheckpointOutputStream;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StatePartitionStreamProvider;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.runtime.util.NonClosingInputStreamDecorator;
import org.apache.flink.runtime.util.NonClosingOutputStreamDecorator;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactoryUtil;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.StreamOperatorStateContext;
import org.apache.flink.streaming.api.operators.StreamOperatorStateHandler;
import org.apache.flink.streaming.api.operators.StreamTaskStateInitializer;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBroadcastWrapperOperator<T, S extends StreamOperator<T>>
implements StreamOperator<T>,
StreamOperatorStateHandler.CheckpointedStreamOperator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBroadcastWrapperOperator.class);
    protected final StreamOperatorParameters<T> parameters;
    protected final StreamConfig streamConfig;
    protected final StreamTask<?, ?> containingTask;
    protected final Output<StreamRecord<T>> output;
    protected final StreamOperatorFactory<T> operatorFactory;
    protected final OperatorMetricGroup metrics;
    protected final S wrappedOperator;
    protected transient StreamOperatorStateHandler stateHandler;
    protected transient InternalTimeServiceManager<?> timeServiceManager;
    private MailboxExecutor mailboxExecutor;
    private String[] broadcastStreamNames;
    private boolean[] isBlocked;
    private TypeSerializer<?>[] inTypeSerializers;
    private boolean broadcastVariablesReady;
    protected transient int indexOfSubtask;
    protected int numInputs;
    private BroadcastStreamingRuntimeContext wrappedOperatorRuntimeContext;
    private Path basePath;
    private DataCacheWriter[] dataCacheWriters;
    private boolean[] hasPendingElements;
    private final boolean hasRichFunction;

    AbstractBroadcastWrapperOperator(StreamOperatorParameters<T> parameters, StreamOperatorFactory<T> operatorFactory, String[] broadcastStreamNames) {
        this.parameters = Objects.requireNonNull(parameters);
        this.streamConfig = Objects.requireNonNull(parameters.getStreamConfig());
        this.containingTask = Objects.requireNonNull(parameters.getContainingTask());
        this.output = Objects.requireNonNull(parameters.getOutput());
        this.operatorFactory = Objects.requireNonNull(operatorFactory);
        this.metrics = this.createOperatorMetricGroup(this.containingTask.getEnvironment(), this.streamConfig);
        this.wrappedOperator = (StreamOperator)StreamOperatorFactoryUtil.createOperator(operatorFactory, this.containingTask, (StreamConfig)this.streamConfig, this.output, (OperatorEventDispatcher)parameters.getOperatorEventDispatcher()).f0;
        boolean bl = this.hasRichFunction = this.wrappedOperator instanceof AbstractUdfStreamOperator && ((AbstractUdfStreamOperator)this.wrappedOperator).getUserFunction() instanceof RichFunction;
        if (this.hasRichFunction) {
            int numNetworkInputs;
            this.wrappedOperatorRuntimeContext = new BroadcastStreamingRuntimeContext(this.containingTask.getEnvironment(), this.containingTask.getEnvironment().getAccumulatorRegistry().getUserMap(), this.wrappedOperator.getMetricGroup(), this.wrappedOperator.getOperatorID(), ((AbstractUdfStreamOperator)this.wrappedOperator).getProcessingTimeService(), null, this.containingTask.getEnvironment().getExternalResourceInfoProvider());
            ((RichFunction)((AbstractUdfStreamOperator)this.wrappedOperator).getUserFunction()).setRuntimeContext((RuntimeContext)this.wrappedOperatorRuntimeContext);
            this.mailboxExecutor = this.containingTask.getMailboxExecutorFactory().createExecutor(-1);
            this.indexOfSubtask = this.containingTask.getIndexInSubtaskGroup();
            for (String name : broadcastStreamNames) {
                BroadcastContext.putMailBoxExecutor(name + "-" + this.indexOfSubtask, this.mailboxExecutor);
            }
            this.broadcastStreamNames = broadcastStreamNames;
            StreamConfig.InputConfig[] inputConfigs = this.streamConfig.getInputs(this.containingTask.getUserCodeClassLoader());
            for (numNetworkInputs = 0; numNetworkInputs < inputConfigs.length && inputConfigs[numNetworkInputs] instanceof StreamConfig.NetworkInputConfig; ++numNetworkInputs) {
            }
            this.numInputs = numNetworkInputs;
            this.isBlocked = new boolean[this.numInputs];
            Arrays.fill(this.isBlocked, false);
            this.inTypeSerializers = new TypeSerializer[this.numInputs];
            for (int i = 0; i < this.numInputs; ++i) {
                this.inTypeSerializers[i] = this.streamConfig.getTypeSerializerIn(i, this.containingTask.getUserCodeClassLoader());
            }
            this.broadcastVariablesReady = false;
            this.basePath = OperatorUtils.getDataCachePath(this.containingTask.getEnvironment().getTaskManagerInfo().getConfiguration(), this.containingTask.getEnvironment().getIOManager().getSpillingDirectoriesPaths());
            this.dataCacheWriters = new DataCacheWriter[this.numInputs];
            this.hasPendingElements = new boolean[this.numInputs];
            Arrays.fill(this.hasPendingElements, true);
        }
    }

    protected boolean areBroadcastVariablesReady() {
        if (this.broadcastVariablesReady) {
            return true;
        }
        for (String name : this.broadcastStreamNames) {
            if (!BroadcastContext.isCacheFinished(name + "-" + this.indexOfSubtask)) {
                return false;
            }
            String key = name + "-" + this.indexOfSubtask;
            String userKey = name.substring(name.indexOf(45) + 1);
            this.wrappedOperatorRuntimeContext.setBroadcastVariable(userKey, BroadcastContext.getBroadcastVariable(key));
        }
        this.broadcastVariablesReady = true;
        return true;
    }

    private OperatorMetricGroup createOperatorMetricGroup(Environment environment, StreamConfig streamConfig) {
        try {
            InternalOperatorMetricGroup operatorMetricGroup = environment.getMetricGroup().getOrAddOperator(streamConfig.getOperatorID(), streamConfig.getOperatorName());
            if (streamConfig.isChainEnd()) {
                ((InternalOperatorIOMetricGroup)operatorMetricGroup.getIOMetricGroup()).reuseOutputMetricsForTask();
            }
            return operatorMetricGroup;
        }
        catch (Exception e) {
            LOG.warn("An error occurred while instantiating task metrics.", (Throwable)e);
            return UnregisteredMetricGroups.createUnregisteredOperatorMetricGroup();
        }
    }

    protected void processElementX(StreamRecord streamRecord, int inputIndex, ThrowingConsumer<StreamRecord, Exception> elementConsumer, ThrowingConsumer<Watermark, Exception> watermarkConsumer, ThrowingConsumer<StreamRecord, Exception> keyContextSetter) throws Exception {
        if (!this.hasRichFunction) {
            elementConsumer.accept((Object)streamRecord);
        } else if (this.isBlocked[inputIndex]) {
            while (!this.areBroadcastVariablesReady()) {
                this.mailboxExecutor.yield();
            }
            elementConsumer.accept((Object)streamRecord);
        } else if (!this.areBroadcastVariablesReady()) {
            this.dataCacheWriters[inputIndex].addRecord(CacheElement.newRecord(streamRecord.getValue()));
        } else {
            if (this.hasPendingElements[inputIndex]) {
                this.processPendingElementsAndWatermarks(inputIndex, elementConsumer, watermarkConsumer, keyContextSetter);
                this.hasPendingElements[inputIndex] = false;
            }
            keyContextSetter.accept((Object)streamRecord);
            elementConsumer.accept((Object)streamRecord);
        }
    }

    protected void processWatermarkX(Watermark watermark, int inputIndex, ThrowingConsumer<StreamRecord, Exception> elementConsumer, ThrowingConsumer<Watermark, Exception> watermarkConsumer, ThrowingConsumer<StreamRecord, Exception> keyContextSetter) throws Exception {
        if (!this.hasRichFunction) {
            watermarkConsumer.accept((Object)watermark);
        } else if (this.isBlocked[inputIndex]) {
            while (!this.areBroadcastVariablesReady()) {
                this.mailboxExecutor.yield();
            }
            watermarkConsumer.accept((Object)watermark);
        } else if (!this.areBroadcastVariablesReady()) {
            this.dataCacheWriters[inputIndex].addRecord(CacheElement.newWatermark(watermark.getTimestamp()));
        } else {
            if (this.hasPendingElements[inputIndex]) {
                this.processPendingElementsAndWatermarks(inputIndex, elementConsumer, watermarkConsumer, keyContextSetter);
                this.hasPendingElements[inputIndex] = false;
            }
            watermarkConsumer.accept((Object)watermark);
        }
    }

    protected void endInputX(int inputIndex, ThrowingConsumer<StreamRecord, Exception> elementConsumer, ThrowingConsumer<Watermark, Exception> watermarkConsumer, ThrowingConsumer<StreamRecord, Exception> keyContextSetter) throws Exception {
        if (!this.hasRichFunction) {
            return;
        }
        while (!this.areBroadcastVariablesReady()) {
            this.mailboxExecutor.yield();
        }
        if (this.hasPendingElements[inputIndex]) {
            this.processPendingElementsAndWatermarks(inputIndex, elementConsumer, watermarkConsumer, keyContextSetter);
            this.hasPendingElements[inputIndex] = false;
        }
    }

    private void processPendingElementsAndWatermarks(int inputIndex, ThrowingConsumer<StreamRecord, Exception> elementConsumer, ThrowingConsumer<Watermark, Exception> watermarkConsumer, ThrowingConsumer<StreamRecord, Exception> keyContextSetter) throws Exception {
        List<Segment> pendingSegments = this.dataCacheWriters[inputIndex].getSegments();
        if (pendingSegments.size() != 0) {
            DataCacheReader dataCacheReader = new DataCacheReader(new CacheElementSerializer(this.inTypeSerializers[inputIndex]), pendingSegments);
            block4: while (dataCacheReader.hasNext()) {
                CacheElement cacheElement = (CacheElement)dataCacheReader.next();
                switch (cacheElement.getType()) {
                    case RECORD: {
                        StreamRecord record = new StreamRecord(cacheElement.getRecord());
                        keyContextSetter.accept((Object)record);
                        elementConsumer.accept((Object)record);
                        continue block4;
                    }
                    case WATERMARK: {
                        watermarkConsumer.accept((Object)new Watermark(cacheElement.getWatermark()));
                        continue block4;
                    }
                }
                throw new RuntimeException("Unsupported CacheElement type: " + (Object)((Object)cacheElement.getType()));
            }
            this.dataCacheWriters[inputIndex].clear();
        }
    }

    public void open() throws Exception {
        this.wrappedOperator.open();
    }

    public void close() throws Exception {
        this.wrappedOperator.close();
        if (!this.hasRichFunction) {
            return;
        }
        for (String name : this.broadcastStreamNames) {
            BroadcastContext.remove(name + "-" + this.indexOfSubtask);
        }
    }

    public void finish() throws Exception {
        this.wrappedOperator.finish();
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        this.wrappedOperator.prepareSnapshotPreBarrier(checkpointId);
    }

    public void initializeState(StreamTaskStateInitializer streamTaskStateManager) throws Exception {
        TypeSerializer keySerializer = this.streamConfig.getStateKeySerializer(this.containingTask.getUserCodeClassLoader());
        StreamOperatorStateContext streamOperatorStateContext = streamTaskStateManager.streamOperatorStateContext(this.getOperatorID(), this.getClass().getSimpleName(), this.parameters.getProcessingTimeService(), (KeyContext)this, keySerializer, this.containingTask.getCancelables(), (MetricGroup)this.metrics, this.streamConfig.getManagedMemoryFractionOperatorUseCaseOfSlot(ManagedMemoryUseCase.STATE_BACKEND, this.containingTask.getEnvironment().getTaskManagerInfo().getConfiguration(), this.containingTask.getUserCodeClassLoader()), false);
        this.stateHandler = new StreamOperatorStateHandler(streamOperatorStateContext, this.containingTask.getExecutionConfig(), this.containingTask.getCancelables());
        this.stateHandler.initializeOperatorState((StreamOperatorStateHandler.CheckpointedStreamOperator)this);
        this.timeServiceManager = streamOperatorStateContext.internalTimerServiceManager();
        this.wrappedOperator.initializeState((operatorID, operatorClassName, processingTimeService, keyContext, keySerializerX, streamTaskCloseableRegistry, metricGroup, managedMemoryFraction, isUsingCustomRawKeyedState) -> new ProxyStreamOperatorStateContext(streamOperatorStateContext, "wrapped-", (Iterator<StatePartitionStreamProvider>)CloseableIterator.empty(), 0));
    }

    public OperatorSnapshotFutures snapshotState(long checkpointId, long timestamp, CheckpointOptions checkpointOptions, CheckpointStreamFactory storageLocation) throws Exception {
        return this.stateHandler.snapshotState((StreamOperatorStateHandler.CheckpointedStreamOperator)this, Optional.ofNullable(this.timeServiceManager), this.streamConfig.getOperatorName(), checkpointId, timestamp, checkpointOptions, storageLocation, false);
    }

    public void initializeState(StateInitializationContext stateInitializationContext) throws Exception {
        List inputs = IteratorUtils.toList(stateInitializationContext.getRawOperatorStateInputs().iterator());
        Preconditions.checkState((inputs.size() < 2 ? 1 : 0) != 0, (Object)"The input from raw operator state should be one or zero.");
        if (!this.hasRichFunction) {
            return;
        }
        if (inputs.size() == 0) {
            for (int i = 0; i < this.numInputs; ++i) {
                this.dataCacheWriters[i] = new DataCacheWriter(new CacheElementSerializer(this.inTypeSerializers[i]), this.basePath.getFileSystem(), OperatorUtils.createDataCacheFileGenerator(this.basePath, "cache", this.streamConfig.getOperatorID()));
            }
        } else {
            InputStream inputStream = ((StatePartitionStreamProvider)inputs.get(0)).getStream();
            DataInputStream dis = new DataInputStream((InputStream)new NonClosingInputStreamDecorator(inputStream));
            Preconditions.checkState((dis.readInt() == this.numInputs ? 1 : 0) != 0, (Object)"Number of input is wrong.");
            for (int i = 0; i < this.numInputs; ++i) {
                DataCacheSnapshot dataCacheSnapshot = DataCacheSnapshot.recover(inputStream, this.basePath.getFileSystem(), OperatorUtils.createDataCacheFileGenerator(this.basePath, "cache", this.streamConfig.getOperatorID()));
                this.dataCacheWriters[i] = new DataCacheWriter(new CacheElementSerializer(this.inTypeSerializers[i]), this.basePath.getFileSystem(), OperatorUtils.createDataCacheFileGenerator(this.basePath, "cache", this.streamConfig.getOperatorID()), dataCacheSnapshot.getSegments());
            }
        }
    }

    public void snapshotState(StateSnapshotContext stateSnapshotContext) throws Exception {
        if (this.wrappedOperator instanceof StreamOperatorStateHandler.CheckpointedStreamOperator) {
            ((StreamOperatorStateHandler.CheckpointedStreamOperator)this.wrappedOperator).snapshotState(stateSnapshotContext);
        }
        if (!this.hasRichFunction) {
            return;
        }
        OperatorStateCheckpointOutputStream checkpointOutputStream = stateSnapshotContext.getRawOperatorStateOutput();
        checkpointOutputStream.startNewPartition();
        try (DataOutputStream dos = new DataOutputStream((OutputStream)new NonClosingOutputStreamDecorator((OutputStream)checkpointOutputStream));){
            dos.writeInt(this.numInputs);
        }
        for (int i = 0; i < this.numInputs; ++i) {
            this.dataCacheWriters[i].writeSegmentsToFiles();
            DataCacheSnapshot dataCacheSnapshot = new DataCacheSnapshot(this.basePath.getFileSystem(), null, this.dataCacheWriters[i].getSegments());
            dataCacheSnapshot.writeTo((OutputStream)checkpointOutputStream);
        }
    }

    public void setKeyContextElement1(StreamRecord<?> record) throws Exception {
        this.wrappedOperator.setKeyContextElement1(record);
    }

    public void setKeyContextElement2(StreamRecord<?> record) throws Exception {
        this.wrappedOperator.setKeyContextElement2(record);
    }

    public OperatorMetricGroup getMetricGroup() {
        return this.wrappedOperator.getMetricGroup();
    }

    public OperatorID getOperatorID() {
        return this.wrappedOperator.getOperatorID();
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        this.wrappedOperator.notifyCheckpointComplete(checkpointId);
    }

    public void notifyCheckpointAborted(long checkpointId) throws Exception {
        this.wrappedOperator.notifyCheckpointAborted(checkpointId);
    }

    public void setCurrentKey(Object key) {
        this.wrappedOperator.setCurrentKey(key);
    }

    public Object getCurrentKey() {
        return this.wrappedOperator.getCurrentKey();
    }
}

