/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.datastream;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.runtime.typeutils.ExternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

public class TableUtils {
    private static final Set<LogicalTypeRoot> LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO = new HashSet<LogicalTypeRoot>();

    public static RowTypeInfo getRowTypeInfo(ResolvedSchema schema) {
        TypeInformation[] types = new TypeInformation[schema.getColumnCount()];
        String[] names = new String[schema.getColumnCount()];
        for (int i = 0; i < schema.getColumnCount(); ++i) {
            Column column = (Column)schema.getColumn(i).get();
            types[i] = TableUtils.getTypeInformationFromDataType(column.getDataType());
            names[i] = column.getName();
        }
        return new RowTypeInfo(types, names);
    }

    public static TypeInformation<?> getTypeInfoByName(ResolvedSchema schema, String name) {
        for (Column column : schema.getColumns()) {
            if (!column.getName().equals(name)) continue;
            return TableUtils.getTypeInformationFromDataType(column.getDataType());
        }
        return null;
    }

    public static int[] getColumnIndexes(ResolvedSchema schema, String[] columnNames) {
        int i;
        HashMap<String, Integer> nameToIndex = new HashMap<String, Integer>();
        int[] result = new int[columnNames.length];
        for (i = 0; i < schema.getColumnCount(); ++i) {
            Column column = (Column)schema.getColumn(i).get();
            nameToIndex.put(column.getName(), i);
        }
        for (i = 0; i < columnNames.length; ++i) {
            result[i] = (Integer)nameToIndex.get(columnNames[i]);
        }
        return result;
    }

    public static StreamExecutionEnvironment getExecutionEnvironment(StreamTableEnvironment tEnv) {
        Table table = tEnv.fromValues(new Expression[0]);
        DataStream dataStream = tEnv.toDataStream(table);
        return dataStream.getExecutionEnvironment();
    }

    private static TypeInformation<?> getTypeInformationFromDataType(DataType dataType) {
        if (LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.contains(dataType.getLogicalType().getTypeRoot())) {
            return ExternalTypeInfo.of((DataType)dataType);
        }
        return TypeInformation.of((Class)dataType.getConversionClass());
    }

    static {
        LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.add(LogicalTypeRoot.CHAR);
        LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.add(LogicalTypeRoot.VARCHAR);
        LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.add(LogicalTypeRoot.BINARY);
        LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.add(LogicalTypeRoot.VARBINARY);
        LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.add(LogicalTypeRoot.DECIMAL);
        LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.add(LogicalTypeRoot.DATE);
        LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.add(LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE);
        LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.add(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.add(LogicalTypeRoot.INTERVAL_DAY_TIME);
        LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.add(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE);
        LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.add(LogicalTypeRoot.ARRAY);
        LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.add(LogicalTypeRoot.MAP);
        LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.add(LogicalTypeRoot.MULTISET);
        LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.add(LogicalTypeRoot.ROW);
        LOGICAL_TYPE_ROOTS_USING_EXTERNAL_TYPE_INFO.add(LogicalTypeRoot.STRUCTURED_TYPE);
    }
}

