/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.binarizer;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Transformer;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.binarizer.BinarizerParams;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorTypeInfo;
import org.apache.flink.ml.linalg.typeinfo.SparseVectorTypeInfo;
import org.apache.flink.ml.linalg.typeinfo.VectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class Binarizer
implements Transformer<Binarizer>,
BinarizerParams<Binarizer> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public Binarizer() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        String[] inputCols = this.getInputCols();
        Preconditions.checkArgument((inputCols.length == this.getThresholds().length ? 1 : 0) != 0);
        Object[] outputTypes = new TypeInformation[inputCols.length];
        for (int i = 0; i < inputCols.length; ++i) {
            int idx = inputTypeInfo.getFieldIndex(inputCols[i]);
            Class typeClass = inputTypeInfo.getTypeAt(idx).getTypeClass();
            outputTypes[i] = typeClass.equals(SparseVector.class) ? SparseVectorTypeInfo.INSTANCE : (typeClass.equals(DenseVector.class) ? DenseVectorTypeInfo.INSTANCE : (typeClass.equals(Vector.class) ? VectorTypeInfo.INSTANCE : Types.DOUBLE));
        }
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])outputTypes), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])this.getOutputCols()));
        SingleOutputStreamOperator output = tEnv.toDataStream(inputs[0]).map((MapFunction)new BinarizeFunction(inputCols, this.getThresholds()), (TypeInformation)outputTypeInfo);
        Table outputTable = tEnv.fromDataStream((DataStream)output);
        return new Table[]{outputTable};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
    }

    public static Binarizer load(StreamTableEnvironment env, String path) throws IOException {
        return (Binarizer)ReadWriteUtils.loadStageParam(path);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static class BinarizeFunction
    implements MapFunction<Row, Row> {
        private final String[] inputCols;
        private final Double[] thresholds;

        public BinarizeFunction(String[] inputCols, Double[] thresholds) {
            this.inputCols = inputCols;
            this.thresholds = thresholds;
        }

        public Row map(Row input) {
            if (null == input) {
                return null;
            }
            Row result = new Row(this.inputCols.length);
            for (int i = 0; i < this.inputCols.length; ++i) {
                result.setField(i, this.binarizerFunc(input.getField(this.inputCols[i]), this.thresholds[i]));
            }
            return Row.join((Row)input, (Row[])new Row[]{result});
        }

        private Object binarizerFunc(Object obj, double threshold) {
            if (obj instanceof DenseVector) {
                DenseVector inputVec = (DenseVector)obj;
                DenseVector vec = inputVec.clone();
                for (int i = 0; i < vec.size(); ++i) {
                    vec.values[i] = inputVec.get(i) > threshold ? 1.0 : 0.0;
                }
                return vec;
            }
            if (obj instanceof SparseVector) {
                SparseVector inputVec = (SparseVector)obj;
                int[] newIndices = new int[inputVec.indices.length];
                int pos = 0;
                for (int i = 0; i < inputVec.indices.length; ++i) {
                    if (!(inputVec.values[i] > threshold)) continue;
                    newIndices[pos++] = inputVec.indices[i];
                }
                double[] newValues = new double[pos];
                Arrays.fill(newValues, 1.0);
                return new SparseVector(inputVec.size(), Arrays.copyOf(newIndices, pos), newValues);
            }
            return Double.parseDouble(obj.toString()) > threshold ? 1.0 : 0.0;
        }
    }
}

