/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.featurehasher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Transformer;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.featurehasher.FeatureHasherParams;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.typeinfo.VectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.shaded.guava30.com.google.common.hash.Hashing;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class FeatureHasher
implements Transformer<FeatureHasher>,
FeatureHasherParams<FeatureHasher> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private static final org.apache.flink.shaded.guava30.com.google.common.hash.HashFunction HASH = Hashing.murmur3_32((int)0);

    public FeatureHasher() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        ResolvedSchema tableSchema = inputs[0].getResolvedSchema();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(tableSchema);
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{VectorTypeInfo.INSTANCE}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        SingleOutputStreamOperator output = tEnv.toDataStream(inputs[0]).map((MapFunction)new HashFunction(this.getInputCols(), this.generateCategoricalCols(tableSchema, this.getInputCols(), this.getCategoricalCols()), this.getNumFeatures()), (TypeInformation)outputTypeInfo);
        Table outputTable = tEnv.fromDataStream((DataStream)output);
        return new Table[]{outputTable};
    }

    private String[] generateCategoricalCols(ResolvedSchema tableSchema, String[] inputCols, String[] categoricalCols) {
        if (null == inputCols) {
            return categoricalCols;
        }
        List<String> categoricalList = Arrays.asList(categoricalCols);
        List<String> inputList = Arrays.asList(inputCols);
        if (categoricalCols.length > 0 && !inputList.containsAll(categoricalList)) {
            throw new IllegalArgumentException("CategoricalCols must be included in inputCols!");
        }
        List dataColTypes = tableSchema.getColumnDataTypes();
        List dataColNames = tableSchema.getColumnNames();
        ArrayList<DataType> inputColTypes = new ArrayList<DataType>();
        block0: for (String col : inputCols) {
            for (int i = 0; i < dataColNames.size(); ++i) {
                if (!col.equals(dataColNames.get(i))) continue;
                inputColTypes.add((DataType)dataColTypes.get(i));
                continue block0;
            }
        }
        ArrayList<String> resultColList = new ArrayList<String>();
        for (int i = 0; i < inputCols.length; ++i) {
            boolean included = categoricalList.contains(inputCols[i]);
            if (!included && !DataTypes.BOOLEAN().equals(inputColTypes.get(i)) && !DataTypes.STRING().equals(inputColTypes.get(i))) continue;
            resultColList.add(inputCols[i]);
        }
        return resultColList.toArray(new String[0]);
    }

    private static void updateMap(String s, double value, TreeMap<Integer, Double> feature, int numFeature) {
        int hashValue = Math.abs(HASH.hashUnencodedChars((CharSequence)s).asInt());
        int index = Math.floorMod(hashValue, numFeature);
        if (feature.containsKey(index)) {
            feature.put(index, feature.get(index) + value);
        } else {
            feature.put(index, value);
        }
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
    }

    public static FeatureHasher load(StreamTableEnvironment env, String path) throws IOException {
        return (FeatureHasher)ReadWriteUtils.loadStageParam(path);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static class HashFunction
    implements MapFunction<Row, Row> {
        private final String[] categoricalCols;
        private final int numFeatures;
        private final String[] numericCols;

        public HashFunction(String[] inputCols, String[] categoricalCols, int numFeatures) {
            this.categoricalCols = categoricalCols;
            this.numFeatures = numFeatures;
            this.numericCols = (String[])ArrayUtils.removeElements((Object[])inputCols, (Object[])this.categoricalCols);
        }

        public Row map(Row row) {
            TreeMap feature = new TreeMap();
            for (String col : this.numericCols) {
                if (null == row.getField(col)) continue;
                double value = ((Number)row.getFieldAs(col)).doubleValue();
                FeatureHasher.updateMap(col, value, feature, this.numFeatures);
            }
            for (String col : this.categoricalCols) {
                if (null == row.getField(col)) continue;
                FeatureHasher.updateMap(col + "=" + row.getField(col), 1.0, feature, this.numFeatures);
            }
            int nnz = feature.size();
            int[] indices = new int[nnz];
            double[] values = new double[nnz];
            int pos = 0;
            for (Map.Entry entry : feature.entrySet()) {
                indices[pos] = (Integer)entry.getKey();
                values[pos] = (Double)entry.getValue();
                ++pos;
            }
            return Row.join((Row)row, (Row[])new Row[]{Row.of((Object[])new Object[]{new SparseVector(this.numFeatures, indices, values)})});
        }
    }
}

