/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.lsh;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.ml.feature.lsh.LSH;
import org.apache.flink.ml.feature.lsh.MinHashLSHModel;
import org.apache.flink.ml.feature.lsh.MinHashLSHModelData;
import org.apache.flink.ml.feature.lsh.MinHashLSHParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;

public class MinHashLSH
extends LSH<MinHashLSH, MinHashLSHModel>
implements MinHashLSHParams<MinHashLSH> {
    @Override
    protected MinHashLSHModel createModel(DataStream<Integer> inputDim, StreamTableEnvironment tEnv) {
        SingleOutputStreamOperator modelData = inputDim.map((MapFunction & Serializable)dim -> MinHashLSHModelData.generateModelData(this.getNumHashTables(), this.getNumHashFunctionsPerTable(), dim, this.getSeed()));
        MinHashLSHModel model = (MinHashLSHModel)new MinHashLSHModel().setModelData(new Table[]{tEnv.fromDataStream((DataStream)modelData)});
        ParamUtils.updateExistingParams(model, this.getParamMap());
        return model;
    }

    public static MinHashLSH load(StreamTableEnvironment tEnv, String path) throws IOException {
        return (MinHashLSH)ReadWriteUtils.loadStageParam(path);
    }
}

