/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.minmaxscaler;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class MinMaxScalerModelData {
    public DenseVector minVector;
    public DenseVector maxVector;

    public MinMaxScalerModelData() {
    }

    public MinMaxScalerModelData(DenseVector minVector, DenseVector maxVector) {
        this.minVector = minVector;
        this.maxVector = maxVector;
    }

    public static DataStream<MinMaxScalerModelData> getModelDataStream(Table modelDataTable) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelDataTable).getTableEnvironment();
        return tEnv.toDataStream(modelDataTable).map((MapFunction & Serializable)x -> new MinMaxScalerModelData((DenseVector)x.getField(0), (DenseVector)x.getField(1)));
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<MinMaxScalerModelData> {
        public StreamFormat.Reader<MinMaxScalerModelData> createReader(Configuration config, final FSDataInputStream stream) {
            return new StreamFormat.Reader<MinMaxScalerModelData>(){
                private final DenseVectorSerializer serializer = new DenseVectorSerializer();

                public MinMaxScalerModelData read() throws IOException {
                    DataInputViewStreamWrapper source = new DataInputViewStreamWrapper((InputStream)stream);
                    try {
                        DenseVector minVector = this.serializer.deserialize((DataInputView)source);
                        DenseVector maxVector = this.serializer.deserialize((DataInputView)source);
                        return new MinMaxScalerModelData(minVector, maxVector);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    stream.close();
                }
            };
        }

        public TypeInformation<MinMaxScalerModelData> getProducedType() {
            return TypeInformation.of(MinMaxScalerModelData.class);
        }
    }

    public static class ModelDataEncoder
    implements Encoder<MinMaxScalerModelData> {
        private final DenseVectorSerializer serializer = new DenseVectorSerializer();

        public void encode(MinMaxScalerModelData modelData, OutputStream outputStream) throws IOException {
            DataOutputViewStreamWrapper dataOutputView = new DataOutputViewStreamWrapper(outputStream);
            this.serializer.serialize(modelData.minVector, (DataOutputView)dataOutputView);
            this.serializer.serialize(modelData.maxVector, (DataOutputView)dataOutputView);
        }
    }
}

