/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.robustscaler;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class RobustScalerModelData {
    public DenseVector medians;
    public DenseVector ranges;

    public RobustScalerModelData() {
    }

    public RobustScalerModelData(DenseVector medians, DenseVector ranges) {
        this.medians = medians;
        this.ranges = ranges;
    }

    public static DataStream<RobustScalerModelData> getModelDataStream(Table modelDataTable) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelDataTable).getTableEnvironment();
        return tEnv.toDataStream(modelDataTable).map((MapFunction & Serializable)x -> new RobustScalerModelData((DenseVector)x.getField("medians"), (DenseVector)x.getField("ranges")));
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<RobustScalerModelData> {
        public StreamFormat.Reader<RobustScalerModelData> createReader(Configuration configuration, final FSDataInputStream inputStream) throws IOException {
            return new StreamFormat.Reader<RobustScalerModelData>(){
                private final DenseVectorSerializer serializer = new DenseVectorSerializer();

                public RobustScalerModelData read() throws IOException {
                    DataInputViewStreamWrapper inputViewStreamWrapper = new DataInputViewStreamWrapper((InputStream)inputStream);
                    try {
                        DenseVector medians = this.serializer.deserialize((DataInputView)inputViewStreamWrapper);
                        DenseVector ranges = this.serializer.deserialize((DataInputView)inputViewStreamWrapper);
                        return new RobustScalerModelData(medians, ranges);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    inputStream.close();
                }
            };
        }

        public TypeInformation<RobustScalerModelData> getProducedType() {
            return TypeInformation.of(RobustScalerModelData.class);
        }
    }

    public static class ModelDataEncoder
    implements Encoder<RobustScalerModelData> {
        private final DenseVectorSerializer serializer = new DenseVectorSerializer();

        public void encode(RobustScalerModelData modelData, OutputStream outputStream) throws IOException {
            DataOutputViewStreamWrapper outputViewStreamWrapper = new DataOutputViewStreamWrapper(outputStream);
            this.serializer.serialize(modelData.medians, (DataOutputView)outputViewStreamWrapper);
            this.serializer.serialize(modelData.ranges, (DataOutputView)outputViewStreamWrapper);
        }
    }
}

