/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.standardscaler;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class StandardScalerModelData {
    public DenseVector mean;
    public DenseVector std;
    public long version;
    public long timestamp;

    public StandardScalerModelData() {
    }

    public StandardScalerModelData(DenseVector mean, DenseVector std) {
        this(mean, std, 0L, Long.MAX_VALUE);
    }

    public StandardScalerModelData(DenseVector mean, DenseVector std, long version, long timestamp) {
        this.mean = mean;
        this.std = std;
        this.version = version;
        this.timestamp = timestamp;
    }

    public static DataStream<StandardScalerModelData> getModelDataStream(Table modelData) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelData).getTableEnvironment();
        return tEnv.toDataStream(modelData).map((MapFunction & Serializable)row -> new StandardScalerModelData((DenseVector)row.getFieldAs("mean"), (DenseVector)row.getFieldAs("std"), (Long)row.getFieldAs("version"), (Long)row.getFieldAs("timestamp"))).setParallelism(1);
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<StandardScalerModelData> {
        public StreamFormat.Reader<StandardScalerModelData> createReader(Configuration configuration, final FSDataInputStream inputStream) {
            return new StreamFormat.Reader<StandardScalerModelData>(){
                private final DenseVectorSerializer serializer = new DenseVectorSerializer();

                public StandardScalerModelData read() throws IOException {
                    DataInputViewStreamWrapper inputViewStreamWrapper = new DataInputViewStreamWrapper((InputStream)inputStream);
                    try {
                        DenseVector mean = this.serializer.deserialize((DataInputView)inputViewStreamWrapper);
                        DenseVector std = this.serializer.deserialize((DataInputView)inputViewStreamWrapper);
                        long version = LongSerializer.INSTANCE.deserialize((DataInputView)inputViewStreamWrapper);
                        long timestamp = LongSerializer.INSTANCE.deserialize((DataInputView)inputViewStreamWrapper);
                        return new StandardScalerModelData(mean, std, version, timestamp);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    inputStream.close();
                }
            };
        }

        public TypeInformation<StandardScalerModelData> getProducedType() {
            return TypeInformation.of(StandardScalerModelData.class);
        }
    }

    public static class ModelDataEncoder
    implements Encoder<StandardScalerModelData> {
        private final DenseVectorSerializer serializer = new DenseVectorSerializer();

        public void encode(StandardScalerModelData modelData, OutputStream outputStream) throws IOException {
            DataOutputViewStreamWrapper outputViewStreamWrapper = new DataOutputViewStreamWrapper(outputStream);
            this.serializer.serialize(modelData.mean, (DataOutputView)outputViewStreamWrapper);
            this.serializer.serialize(modelData.std, (DataOutputView)outputViewStreamWrapper);
            LongSerializer.INSTANCE.serialize(Long.valueOf(modelData.version), (DataOutputView)outputViewStreamWrapper);
            LongSerializer.INSTANCE.serialize(Long.valueOf(modelData.timestamp), (DataOutputView)outputViewStreamWrapper);
        }
    }
}

