/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.internal.QueryObserverAdapter;
import org.apache.geode.cache.query.internal.index.CompactMapRangeIndex;
import org.apache.geode.cache.query.internal.index.MapRangeIndex;
import org.apache.geode.internal.cache.PartitionedRegionQueryEvaluator;

public class IndexTrackingQueryObserver
extends QueryObserverAdapter {
    private static final ThreadLocal indexInfo = new ThreadLocal();
    private static final ThreadLocal lastKeyUsed = new ThreadLocal();
    private static final ThreadLocal lastIndexUsed = new ThreadLocal();
    private volatile PartitionedRegionQueryEvaluator.TestHook th;

    @Override
    public void beforeIndexLookup(Index index, int oper, Object key) {
        String indexName;
        HashMap<String, IndexInfo> indexMap = (HashMap<String, IndexInfo>)indexInfo.get();
        if (indexMap == null) {
            indexMap = new HashMap<String, IndexInfo>();
            indexInfo.set(indexMap);
        }
        IndexInfo iInfo = indexMap.containsKey(indexName = this.getIndexName(index, key)) ? (IndexInfo)indexMap.get(indexName) : new IndexInfo();
        iInfo.addRegionId(index.getRegion().getFullPath());
        indexMap.put(indexName, iInfo);
        lastIndexUsed.set(index);
        lastKeyUsed.set(key);
        if (this.th != null) {
            this.th.hook(1);
        }
    }

    @Override
    public void beforeIndexLookup(Index index, int lowerBoundOperator, Object lowerBoundKey, int upperBoundOperator, Object upperBoundKey, Set NotEqualKeys) {
        HashMap<String, IndexInfo> indexMap = (HashMap<String, IndexInfo>)indexInfo.get();
        if (indexMap == null) {
            indexMap = new HashMap<String, IndexInfo>();
            indexInfo.set(indexMap);
        }
        IndexInfo iInfo = indexMap.containsKey(index.getName()) ? (IndexInfo)indexMap.get(index.getName()) : new IndexInfo();
        iInfo.addRegionId(index.getRegion().getFullPath());
        indexMap.put(index.getName(), iInfo);
        lastIndexUsed.set(index);
        if (this.th != null) {
            this.th.hook(2);
        }
    }

    @Override
    public void afterIndexLookup(Collection results) {
        IndexInfo indexInfo;
        if (results == null) {
            return;
        }
        Map indexMap = (Map)IndexTrackingQueryObserver.indexInfo.get();
        Index index = (Index)lastIndexUsed.get();
        if (index != null && (indexInfo = (IndexInfo)indexMap.get(this.getIndexName(index, lastKeyUsed.get()))) != null) {
            indexInfo.getResults().put(index.getRegion().getFullPath(), results.size());
        }
        lastIndexUsed.set(null);
        lastKeyUsed.set(null);
        if (this.th != null) {
            this.th.hook(3);
        }
    }

    private String getIndexName(Index index, Object key) {
        String indexName = (index instanceof MapRangeIndex || index instanceof CompactMapRangeIndex) && key instanceof Object[] ? index.getName() + "-" + ((Object[])key)[1] : index.getName();
        return indexName;
    }

    public void reset() {
        if (this.th != null) {
            this.th.hook(4);
        }
        indexInfo.set(null);
    }

    public void setIndexInfo(Map indexInfoMap) {
        indexInfo.set(indexInfoMap);
    }

    public Map getUsedIndexes() {
        Map map = (Map)indexInfo.get();
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        return map;
    }

    public void setTestHook(PartitionedRegionQueryEvaluator.TestHook testHook) {
        this.th = testHook;
    }

    public Map getUsedIndexes(String fullPath) {
        Map map = (Map)indexInfo.get();
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap newMap = new HashMap();
        for (Map.Entry obj : map.entrySet()) {
            Map.Entry entry = obj;
            if (entry == null || !((IndexInfo)entry.getValue()).getRegionIds().contains(fullPath)) continue;
            newMap.put(entry.getKey(), ((IndexInfo)entry.getValue()).getResults().get(fullPath));
        }
        return newMap;
    }

    public PartitionedRegionQueryEvaluator.TestHook getTestHook() {
        return this.th;
    }

    public class IndexInfo {
        private final Map<String, Integer> results = new Object2ObjectOpenHashMap();

        public Map getResults() {
            return this.results;
        }

        public void addResults(Map rslts) {
            Iterator iterator = rslts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry obj;
                Map.Entry ent = obj = iterator.next();
                this.results.put((String)ent.getKey(), (Integer)ent.getValue());
            }
        }

        public Set getRegionIds() {
            return this.results.keySet();
        }

        public void addRegionId(String regionId) {
            this.results.put(regionId, 0);
        }

        public String toString() {
            int total = 0;
            for (Integer i : this.results.values()) {
                total += i.intValue();
            }
            return "(Results: " + total + ")";
        }

        public void merge(IndexInfo src) {
            this.addResults(src.getResults());
        }
    }
}

