/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CancelStatListenerResponse;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class CancelStatListenerRequest
extends AdminRequest {
    private int listenerId;

    public static CancelStatListenerRequest create(int listenerId) {
        CancelStatListenerRequest m = new CancelStatListenerRequest();
        m.listenerId = listenerId;
        return m;
    }

    public CancelStatListenerRequest() {
        this.friendlyName = "Remove statistic resource listener";
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return CancelStatListenerResponse.create(dm, this.getSender(), this.listenerId);
    }

    public int getDSFID() {
        return 1017;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.listenerId);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.listenerId = in.readInt();
    }

    @Override
    public String toString() {
        return String.format("CancelStatListenerRequest from %s for %s", this.getRecipient(), this.listenerId);
    }
}

