/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.cache.DiskDirSizesUnit;
import org.apache.geode.internal.cache.DiskDirectoryStats;

public class DirectoryHolder {
    private final File dir;
    private final long capacity;
    private final AtomicLong totalOplogSize = new AtomicLong();
    private final int index;
    private final DiskDirectoryStats dirStats;
    private final DiskDirSizesUnit diskDirSizesUnit;

    DirectoryHolder(StatisticsFactory factory, File dir, long space, int index) {
        this(dir.getPath(), factory, dir, space, index);
    }

    DirectoryHolder(String ownersName, StatisticsFactory factory, File dir, long space, int index) {
        this(ownersName, factory, dir, space, index, DiskDirSizesUnit.MEGABYTES);
    }

    @VisibleForTesting
    DirectoryHolder(String ownersName, StatisticsFactory factory, File dir, long space, int index, DiskDirSizesUnit unit) {
        this.dir = dir;
        this.diskDirSizesUnit = unit;
        if (this.diskDirSizesUnit == DiskDirSizesUnit.BYTES) {
            this.capacity = space;
        } else if (this.diskDirSizesUnit == DiskDirSizesUnit.MEGABYTES) {
            this.capacity = space * 1024L * 1024L;
        } else {
            throw new IllegalArgumentException("Invalid value for disk size units. Only megabytes and bytes are accepted.");
        }
        this.index = index;
        this.dirStats = new DiskDirectoryStats(factory, ownersName);
        this.dirStats.setMaxSpace(this.capacity);
    }

    public long getUsedSpace() {
        return this.totalOplogSize.get();
    }

    public long getAvailableSpace() {
        return this.getCapacity() - this.getUsedSpace();
    }

    public String toString() {
        return "dir=" + this.getDir() + " maxSpace=" + this.getCapacity() + " usedSpace=" + this.getUsedSpace() + " availableSpace=" + this.getAvailableSpace();
    }

    public void incrementTotalOplogSize(long incrementSize) {
        this.totalOplogSize.addAndGet(incrementSize);
        this.dirStats.incDiskSpace(incrementSize);
    }

    public void decrementTotalOplogSize(long decrementSize) {
        this.totalOplogSize.addAndGet(-decrementSize);
        this.dirStats.incDiskSpace(-decrementSize);
    }

    public File getDir() {
        return this.dir;
    }

    public int getArrayIndex() {
        return this.index;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void close() {
        this.dirStats.close();
    }

    public long getDirStatsDiskSpaceUsage() {
        return this.dirStats.getDiskSpace();
    }

    public DiskDirectoryStats getDiskDirectoryStats() {
        return this.dirStats;
    }
}

