/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.pdx.internal.TypeRegistration;

class TypeRegistrationStatistics {
    static final String TYPE_DEFINED = "typeDefined";
    static final String TYPE_CREATED = "typeCreated";
    static final String ENUM_DEFINED = "enumDefined";
    static final String ENUM_CREATED = "enumCreated";
    static final String SIZE = "size";
    private final TypeRegistration typeRegistration;
    private final int typeDefinedId;
    private final int typeCreatedId;
    private final int enumDefinedId;
    private final int enumCreatedId;
    private final Statistics statistics;

    TypeRegistrationStatistics(StatisticsFactory statisticsFactory, TypeRegistration typeRegistration) {
        this.typeRegistration = typeRegistration;
        StatisticsType statisticsType = statisticsFactory.createType("PdxTypeRegistration", "PDX type registration statistics.", new StatisticDescriptor[]{statisticsFactory.createLongCounter(TYPE_DEFINED, "Number of PDX types defined.", "ops"), statisticsFactory.createLongCounter(TYPE_CREATED, "Number of PDX types created.", "ops"), statisticsFactory.createLongCounter(ENUM_DEFINED, "Number of PDX enums defined.", "ops"), statisticsFactory.createLongCounter(ENUM_CREATED, "Number of PDX enums created.", "ops"), statisticsFactory.createLongGauge(SIZE, "Size of PDX type and enum registry.", "entries")});
        this.typeDefinedId = statisticsType.nameToId(TYPE_DEFINED);
        this.typeCreatedId = statisticsType.nameToId(TYPE_CREATED);
        this.enumDefinedId = statisticsType.nameToId(ENUM_DEFINED);
        this.enumCreatedId = statisticsType.nameToId(ENUM_CREATED);
        this.statistics = statisticsFactory.createAtomicStatistics(statisticsType, typeRegistration.getClass().getSimpleName());
    }

    public void initialize() {
        this.statistics.setLongSupplier(SIZE, this.typeRegistration::getLocalSize);
    }

    void typeDefined() {
        this.statistics.incLong(this.typeDefinedId, 1L);
    }

    void typeCreated() {
        this.statistics.incLong(this.typeCreatedId, 1L);
    }

    void enumDefined() {
        this.statistics.incLong(this.enumDefinedId, 1L);
    }

    void enumCreated() {
        this.statistics.incLong(this.enumCreatedId, 1L);
    }
}

