/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.repository.serializer;

import java.util.Collection;
import java.util.Collections;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.repository.serializer.SerializerUtil;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.pdx.PdxInstance;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;

class PdxLuceneSerializer
implements LuceneSerializer {
    private static final Logger logger = LogService.getLogger();

    public Collection<Document> toDocuments(LuceneIndex index, Object value) {
        Document doc = new Document();
        PdxInstance pdx = (PdxInstance)value;
        for (String field : index.getFieldNames()) {
            Object fieldValue;
            if (!pdx.hasField(field) || (fieldValue = pdx.getField(field)) == null) continue;
            SerializerUtil.addField(doc, field, fieldValue);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("PdxLuceneSerializer.toDocument:" + doc);
        }
        return Collections.singleton(doc);
    }
}

