/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client;

import java.util.Properties;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.PoolFactory;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.SocketFactory;
import org.apache.geode.cache.client.internal.InternalClientCache;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.cache.CacheConfig;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCacheBuilder;
import org.apache.geode.metrics.internal.InternalDistributedSystemMetricsService;
import org.apache.geode.metrics.internal.MetricsService;
import org.apache.geode.pdx.PdxSerializer;

public class ClientCacheFactory {
    private PoolFactory pf;
    private final Properties dsProps;
    private final CacheConfig cacheConfig = new CacheConfig();

    public ClientCacheFactory() {
        this.dsProps = new Properties();
    }

    public ClientCacheFactory(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        this.dsProps = props;
    }

    public ClientCacheFactory set(String name, String value) {
        this.dsProps.setProperty(name, value);
        return this;
    }

    public ClientCache create() {
        return this.basicCreate();
    }

    private static InternalClientCache getInternalClientCache() {
        return GemFireCacheImpl.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientCache basicCreate() {
        Class<ClientCacheFactory> clazz = ClientCacheFactory.class;
        synchronized (ClientCacheFactory.class) {
            int mcastPort;
            InternalClientCache instance = ClientCacheFactory.getInternalClientCache();
            String propValue = this.dsProps.getProperty("mcast-port");
            if (propValue != null && (mcastPort = Integer.parseInt(propValue)) != 0) {
                throw new IllegalStateException("On a client cache the mcast-port must be set to 0 or not set. It was set to " + mcastPort);
            }
            propValue = this.dsProps.getProperty("locators");
            if (propValue != null && !propValue.isEmpty()) {
                throw new IllegalStateException("On a client cache the locators property must be set to an empty string or not set. It was set to \"" + propValue + "\".");
            }
            this.dsProps.setProperty("mcast-port", "0");
            this.dsProps.setProperty("locators", "");
            InternalDistributedSystem system = this.connectInternalDistributedSystem();
            if (instance != null && !instance.isClosed()) {
                if (!instance.isClient()) {
                    throw new IllegalStateException("A client cache can not be created because a non-client cache already exists.");
                }
                instance.validatePoolFactory(this.pf);
                this.cacheConfig.validateCacheConfig(instance);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (InternalClientCache)((Object)new InternalCacheBuilder(this.cacheConfig).setIsClient(true).setPoolFactory(this.pf).create(system));
        }
    }

    private InternalDistributedSystem connectInternalDistributedSystem() {
        MetricsService.Builder metricsServiceBuilder = new InternalDistributedSystemMetricsService.Builder().setIsClient(true);
        return InternalDistributedSystem.connectInternal(this.dsProps, null, metricsServiceBuilder);
    }

    private PoolFactory getPoolFactory() {
        if (this.pf == null) {
            this.pf = PoolManager.createFactory();
        }
        return this.pf;
    }

    public ClientCacheFactory setPoolSocketConnectTimeout(int socketConnectTimeout) {
        this.getPoolFactory().setSocketConnectTimeout(socketConnectTimeout);
        return this;
    }

    public ClientCacheFactory setPoolFreeConnectionTimeout(int connectionTimeout) {
        this.getPoolFactory().setFreeConnectionTimeout(connectionTimeout);
        return this;
    }

    public ClientCacheFactory setPoolServerConnectionTimeout(int connectionTimeout) {
        this.getPoolFactory().setServerConnectionTimeout(connectionTimeout);
        return this;
    }

    public ClientCacheFactory setPoolLoadConditioningInterval(int loadConditioningInterval) {
        this.getPoolFactory().setLoadConditioningInterval(loadConditioningInterval);
        return this;
    }

    public ClientCacheFactory setPoolSocketBufferSize(int bufferSize) {
        this.getPoolFactory().setSocketBufferSize(bufferSize);
        return this;
    }

    @Deprecated
    public ClientCacheFactory setPoolThreadLocalConnections(boolean threadLocalConnections) {
        this.getPoolFactory().setThreadLocalConnections(threadLocalConnections);
        return this;
    }

    public ClientCacheFactory setPoolReadTimeout(int timeout) {
        this.getPoolFactory().setReadTimeout(timeout);
        return this;
    }

    public ClientCacheFactory setPoolMinConnections(int minConnections) {
        this.getPoolFactory().setMinConnections(minConnections);
        return this;
    }

    public ClientCacheFactory setPoolMaxConnections(int maxConnections) {
        this.getPoolFactory().setMaxConnections(maxConnections);
        return this;
    }

    public ClientCacheFactory setPoolIdleTimeout(long idleTimeout) {
        this.getPoolFactory().setIdleTimeout(idleTimeout);
        return this;
    }

    public ClientCacheFactory setPoolRetryAttempts(int retryAttempts) {
        this.getPoolFactory().setRetryAttempts(retryAttempts);
        return this;
    }

    public ClientCacheFactory setPoolPingInterval(long pingInterval) {
        this.getPoolFactory().setPingInterval(pingInterval);
        return this;
    }

    public ClientCacheFactory setPoolStatisticInterval(int statisticInterval) {
        this.getPoolFactory().setStatisticInterval(statisticInterval);
        return this;
    }

    public ClientCacheFactory setPoolServerGroup(String group) {
        this.getPoolFactory().setServerGroup(group);
        return this;
    }

    public ClientCacheFactory addPoolLocator(String host, int port) {
        this.getPoolFactory().addLocator(host, port);
        return this;
    }

    public ClientCacheFactory addPoolServer(String host, int port) {
        this.getPoolFactory().addServer(host, port);
        return this;
    }

    public ClientCacheFactory setPoolSubscriptionEnabled(boolean enabled) {
        this.getPoolFactory().setSubscriptionEnabled(enabled);
        return this;
    }

    public ClientCacheFactory setPoolSubscriptionRedundancy(int redundancy) {
        this.getPoolFactory().setSubscriptionRedundancy(redundancy);
        return this;
    }

    public ClientCacheFactory setPoolSubscriptionTimeoutMultiplier(int multiplier) {
        this.getPoolFactory().setSubscriptionTimeoutMultiplier(multiplier);
        return this;
    }

    public ClientCacheFactory setPoolSubscriptionMessageTrackingTimeout(int messageTrackingTimeout) {
        this.getPoolFactory().setSubscriptionMessageTrackingTimeout(messageTrackingTimeout);
        return this;
    }

    public ClientCacheFactory setPoolSocketFactory(SocketFactory socketFactory) {
        this.getPoolFactory().setSocketFactory(socketFactory);
        return this;
    }

    public ClientCacheFactory setPoolSubscriptionAckInterval(int ackInterval) {
        this.getPoolFactory().setSubscriptionAckInterval(ackInterval);
        return this;
    }

    public ClientCacheFactory setPoolPRSingleHopEnabled(boolean enabled) {
        this.getPoolFactory().setPRSingleHopEnabled(enabled);
        return this;
    }

    public ClientCacheFactory setPoolMultiuserAuthentication(boolean enabled) {
        this.getPoolFactory().setMultiuserAuthentication(enabled);
        return this;
    }

    public static String getVersion() {
        return GemFireVersion.getGemFireVersion();
    }

    public static synchronized ClientCache getAnyInstance() {
        InternalClientCache instance = ClientCacheFactory.getInternalClientCache();
        if (instance == null) {
            throw new CacheClosedException("A cache has not yet been created.");
        }
        if (!instance.isClient()) {
            throw new IllegalStateException("The singleton cache was created by CacheFactory not ClientCacheFactory.");
        }
        instance.getCancelCriterion().checkCancelInProgress(null);
        return instance;
    }

    public ClientCacheFactory setPdxReadSerialized(boolean pdxReadSerialized) {
        this.cacheConfig.setPdxReadSerialized(pdxReadSerialized);
        return this;
    }

    public ClientCacheFactory setPdxSerializer(PdxSerializer serializer) {
        this.cacheConfig.setPdxSerializer(serializer);
        return this;
    }

    @Deprecated
    public ClientCacheFactory setPdxDiskStore(String diskStoreName) {
        this.cacheConfig.setPdxDiskStore(diskStoreName);
        return this;
    }

    @Deprecated
    public ClientCacheFactory setPdxPersistent(boolean isPersistent) {
        this.cacheConfig.setPdxPersistent(isPersistent);
        return this;
    }

    public ClientCacheFactory setPdxIgnoreUnreadFields(boolean ignore) {
        this.cacheConfig.setPdxIgnoreUnreadFields(ignore);
        return this;
    }
}

