/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.io.IOException;
import org.apache.geode.cache.client.SocketFactory;
import org.apache.geode.cache.client.internal.ClientSideHandshakeImpl;
import org.apache.geode.cache.client.internal.ClientUpdater;
import org.apache.geode.cache.client.internal.ConnectionImpl;
import org.apache.geode.cache.client.internal.Endpoint;
import org.apache.geode.cache.client.internal.EndpointManager;
import org.apache.geode.cache.client.internal.QueueManager;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.tier.ClientSideHandshake;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.cache.tier.sockets.CacheClientUpdater;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ConnectionConnector {
    private static final Logger logger = LogService.getLogger();
    private final ClientSideHandshakeImpl handshake;
    private final int socketBufferSize;
    private final int handshakeTimeout;
    private final boolean usedByGateway;
    private final SocketCreator socketCreator;
    private final int readTimeout;
    private final InternalDistributedSystem distributedSystem;
    private final EndpointManager endpointManager;
    private final GatewaySender gatewaySender;
    private final SocketFactory socketFactory;

    public ConnectionConnector(EndpointManager endpointManager, InternalDistributedSystem distributedSystem, int socketBufferSize, int handshakeTimeout, int readTimeout, boolean usedByGateway, GatewaySender gatewaySender, SocketCreator socketCreator, ClientSideHandshakeImpl handshake, SocketFactory socketFactory) {
        this.handshake = handshake;
        this.handshake.setClientReadTimeout(readTimeout);
        this.endpointManager = endpointManager;
        this.distributedSystem = distributedSystem;
        this.socketBufferSize = socketBufferSize;
        this.handshakeTimeout = handshakeTimeout;
        this.readTimeout = readTimeout;
        this.usedByGateway = usedByGateway;
        this.gatewaySender = gatewaySender;
        this.socketCreator = socketCreator;
        this.socketFactory = socketFactory;
        if (this.socketCreator != null && (this.usedByGateway || gatewaySender != null) && gatewaySender != null && !gatewaySender.getGatewayTransportFilters().isEmpty()) {
            this.socketCreator.initializeTransportFilterClientSocketFactory(gatewaySender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionImpl connectClientToServer(ServerLocation location, boolean forQueue) throws IOException {
        ConnectionImpl connection = null;
        boolean initialized = false;
        try {
            connection = this.getConnection(this.distributedSystem);
            ClientSideHandshake connHandShake = this.getClientSideHandshake(this.handshake);
            connection.connect(this.endpointManager, location, connHandShake, this.socketBufferSize, this.handshakeTimeout, this.readTimeout, this.getCommMode(forQueue), this.gatewaySender, this.socketCreator, this.socketFactory);
            connection.setHandshake(connHandShake);
            initialized = true;
            ConnectionImpl connectionImpl = connection;
            return connectionImpl;
        }
        finally {
            if (!initialized && connection != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Destroying failed connection to {}", (Object)location);
                }
                this.destroyConnection(connection);
            }
        }
    }

    void destroyConnection(ConnectionImpl connection) {
        connection.destroy();
    }

    ConnectionImpl getConnection(InternalDistributedSystem ds) {
        return new ConnectionImpl(ds);
    }

    ClientSideHandshake getClientSideHandshake(ClientSideHandshakeImpl handshake) {
        return new ClientSideHandshakeImpl(handshake);
    }

    CacheClientUpdater connectServerToClient(Endpoint endpoint, QueueManager qManager, boolean isPrimary, ClientUpdater failedUpdater, String clientUpdateName) {
        CacheClientUpdater updater = new CacheClientUpdater(clientUpdateName, endpoint.getLocation(), isPrimary, this.distributedSystem, new ClientSideHandshakeImpl(this.handshake), qManager, this.endpointManager, endpoint, this.handshakeTimeout, this.socketCreator, this.socketFactory);
        if (!updater.isConnected()) {
            return null;
        }
        updater.setFailedUpdater(failedUpdater);
        updater.start();
        return updater;
    }

    private CommunicationMode getCommMode(boolean forQueue) {
        if (this.usedByGateway || this.gatewaySender != null) {
            return CommunicationMode.GatewayToGateway;
        }
        if (forQueue) {
            return CommunicationMode.ClientToServerForQueue;
        }
        return CommunicationMode.ClientToServer;
    }
}

