/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.internal.utils.LimitIterator;
import org.apache.geode.cache.query.internal.utils.PDXUtils;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.serialization.BufferDataOutputStream;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class CumulativeNonDistinctResults<E>
implements SelectResults<E>,
DataSerializableFixedID {
    private CollectionType collectionType;
    private Collection<E> data;

    public CumulativeNonDistinctResults() {
    }

    public CumulativeNonDistinctResults(Collection<? extends Collection<E>> results, int limit, ObjectType elementType, List<Metadata> collectionsMetadata) {
        this.collectionType = new CollectionTypeImpl(CumulativeNonDistinctResults.class, elementType);
        this.data = new CumulativeNonDistinctResultsCollection(results, limit, collectionsMetadata);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.data.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.data.toArray(a);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException("Addition to collection not supported");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Removal from collection not supported");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.data.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("Addition to collection not supported");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Removal from collection not supported");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Removal from collection not supported");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Removal from collection not supported");
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    public int occurrences(E element) {
        int count = 0;
        for (E v : this) {
            if (!(element == null ? v == null : element.equals(v))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Set<E> asSet() {
        return new HashSet(this);
    }

    @Override
    public List<E> asList() {
        return new ArrayList(this);
    }

    @Override
    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    @Override
    public void setElementType(ObjectType elementType) {
        throw new UnsupportedOperationException(" not supported");
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        ObjectType elementType = (ObjectType)context.getDeserializer().readObject(in);
        this.collectionType = new CollectionTypeImpl(CumulativeNonDistinctResults.class, elementType);
        boolean isStruct = elementType.isStructType();
        long size = in.readLong();
        this.data = new ArrayList((int)size);
        for (long numLeft = size; numLeft > 0L; --numLeft) {
            if (isStruct) {
                Object[] fields = DataSerializer.readObjectArray(in);
                this.data.add(new StructImpl((StructTypeImpl)elementType, fields));
                continue;
            }
            Object element = context.getDeserializer().readObject(in);
            this.data.add(element);
        }
    }

    public int getDSFID() {
        return 168;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        boolean isStruct = this.collectionType.getElementType().isStructType();
        context.getSerializer().writeObject((Object)this.collectionType.getElementType(), out);
        HeapDataOutputStream hdos = new HeapDataOutputStream(1024, null);
        BufferDataOutputStream.LongUpdater lu = hdos.reserveLong();
        Iterator<E> iter = this.iterator();
        int numElements = 0;
        while (iter.hasNext()) {
            E data = iter.next();
            if (isStruct) {
                Object[] fields = ((Struct)data).getFieldValues();
                DataSerializer.writeObjectArray(fields, hdos);
            } else {
                context.getSerializer().writeObject(data, (DataOutput)hdos);
            }
            ++numElements;
        }
        lu.update((long)numElements);
        hdos.sendTo(out);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CumulativeNonDistinctResults::");
        builder.append('[');
        for (E e : this) {
            builder.append(e).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(']');
        return builder.toString();
    }

    public static Metadata getCollectionMetadata(boolean getDomainObjectForPdx, boolean getDeserializedObject, boolean localResults) {
        return new Metadata(getDomainObjectForPdx, getDeserializedObject, localResults);
    }

    public static class Metadata {
        final boolean getDomainObjectForPdx;
        final boolean getDeserializedObject;
        final boolean localResults;

        private Metadata(boolean getDomainObjectForPdx, boolean getDeserializedObject, boolean localResults) {
            this.getDomainObjectForPdx = getDomainObjectForPdx;
            this.getDeserializedObject = getDeserializedObject;
            this.localResults = localResults;
        }
    }

    private class CumulativeNonDistinctResultsCollection
    extends AbstractCollection<E> {
        private final Collection<? extends Collection<E>> results;
        private final List<Metadata> collectionsMetdata;
        private final int limit;

        public CumulativeNonDistinctResultsCollection(Collection<? extends Collection<E>> results, int limit, List<Metadata> collectionsMetadata) {
            this.results = results;
            this.limit = limit;
            this.collectionsMetdata = collectionsMetadata;
        }

        @Override
        public int size() {
            int totalSize = 0;
            for (Collection result : this.results) {
                totalSize += result.size();
            }
            if (this.limit >= 0) {
                return totalSize > this.limit ? this.limit : totalSize;
            }
            return totalSize;
        }

        @Override
        public Iterator<E> iterator() {
            Iterator iter = new CumulativeCollectionIterator();
            if (this.limit > -1) {
                iter = new LimitIterator(iter, this.limit);
            }
            return iter;
        }

        private class CumulativeCollectionIterator
        implements Iterator<E> {
            protected final Iterator<E>[] iterators;
            protected int currentIterator = 0;
            private Boolean cachedHasNext = null;
            private final boolean isStruct;
            private final boolean[] objectChangedMarker = new boolean[1];

            protected CumulativeCollectionIterator() {
                this.iterators = new Iterator[CumulativeNonDistinctResultsCollection.this.results.size()];
                Iterator listIter = CumulativeNonDistinctResultsCollection.this.results.iterator();
                int index = 0;
                while (listIter.hasNext()) {
                    Iterator temp = ((Collection)listIter.next()).iterator();
                    this.iterators[index++] = temp;
                }
                this.isStruct = CumulativeNonDistinctResults.this.collectionType.getElementType().isStructType();
            }

            @Override
            public boolean hasNext() {
                if (this.cachedHasNext != null) {
                    return this.cachedHasNext;
                }
                boolean hasNext = false;
                for (int i = this.currentIterator; i < this.iterators.length; ++i) {
                    if (!this.iterators[i].hasNext()) continue;
                    hasNext = true;
                    this.currentIterator = i;
                    break;
                }
                this.cachedHasNext = hasNext;
                return hasNext;
            }

            @Override
            public E next() {
                if (this.cachedHasNext == null) {
                    this.hasNext();
                }
                this.cachedHasNext = null;
                Metadata metadata = (Metadata)CumulativeNonDistinctResultsCollection.this.collectionsMetdata.get(this.currentIterator);
                Object original = this.iterators[this.currentIterator].next();
                Object e = PDXUtils.convertPDX(original, this.isStruct, metadata.getDomainObjectForPdx, metadata.getDeserializedObject, metadata.localResults, this.objectChangedMarker, false);
                if (this.isStruct) {
                    if (this.objectChangedMarker[0]) {
                        return new StructImpl((StructTypeImpl)CumulativeNonDistinctResults.this.collectionType.getElementType(), (Object[])e);
                    }
                    return original;
                }
                return e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        }
    }
}

