/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;

public class ExpireDisconnectedClientTransactionsMessage
extends HighPriorityDistributionMessage {
    Set<TXId> txIds;

    static void send(DistributionManager dm, Set<InternalDistributedMember> recipients, Set<TXId> txIds) {
        ExpireDisconnectedClientTransactionsMessage msg = new ExpireDisconnectedClientTransactionsMessage();
        msg.txIds = txIds;
        HashSet<InternalDistributedMember> newVersionRecipients = new HashSet<InternalDistributedMember>();
        for (InternalDistributedMember recipient : recipients) {
            if (!recipient.getVersion().isNotOlderThan((Version)KnownVersion.GEODE_1_7_0)) continue;
            newVersionRecipients.add(recipient);
        }
        msg.setRecipients(newVersionRecipients);
        dm.putOutgoing(msg);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writeHashSet((HashSet)this.txIds, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.txIds = DataSerializer.readHashSet(in);
    }

    public int getDSFID() {
        return 138;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        InternalCache cache = dm.getCache();
        InternalDistributedMember sender = this.getSender();
        if (cache != null) {
            TXManagerImpl mgr = cache.getTXMgr();
            if (sender.getVersion().isNotOlderThan((Version)KnownVersion.GEODE_1_7_0)) {
                mgr.expireDisconnectedClientTransactions(this.txIds, false);
            } else {
                mgr.removeExpiredClientTransactions(this.txIds);
            }
        }
    }
}

