/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.internal.cache.PartitionedRegionStats;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

class PartitionedRegionRedundancyTracker {
    private static final Logger logger = LogService.getLogger();
    private final PartitionedRegionStats stats;
    private final String regionPath;
    private final int totalBuckets;
    private final int targetRedundancy;
    private int lowRedundancyBuckets;
    private int noCopiesBuckets;
    private int lowestBucketCopies;
    private volatile int actualRedundancy;

    PartitionedRegionRedundancyTracker(int totalBuckets, int redundantCopies, PartitionedRegionStats stats, String regionPath) {
        this.stats = stats;
        this.regionPath = regionPath;
        this.totalBuckets = totalBuckets;
        this.targetRedundancy = redundantCopies;
        this.lowestBucketCopies = redundantCopies + 1;
    }

    int getLowestBucketCopies() {
        return this.lowestBucketCopies;
    }

    int getLowRedundancyBuckets() {
        return this.lowRedundancyBuckets;
    }

    synchronized void incrementLowRedundancyBucketCount() {
        if (this.lowRedundancyBuckets == this.totalBuckets) {
            return;
        }
        ++this.lowRedundancyBuckets;
        this.stats.incLowRedundancyBucketCount(1);
    }

    synchronized void reportBucketCount(int bucketCopies) {
        if (bucketCopies < this.lowestBucketCopies) {
            this.lowestBucketCopies = bucketCopies;
            logger.warn("Redundancy has dropped below {} configured copies to {} actual copies for {}", new Object[]{this.targetRedundancy + 1, bucketCopies, this.regionPath});
        }
    }

    synchronized void incrementNoCopiesBucketCount() {
        if (this.noCopiesBuckets == this.totalBuckets) {
            return;
        }
        ++this.noCopiesBuckets;
        this.stats.incNoCopiesBucketCount(1);
        if (this.noCopiesBuckets == 1) {
            logger.warn("All in memory copies of some data have been lost for " + this.regionPath);
        }
    }

    synchronized void decrementLowRedundancyBucketCount() {
        if (this.lowRedundancyBuckets == 0) {
            return;
        }
        --this.lowRedundancyBuckets;
        this.stats.incLowRedundancyBucketCount(-1);
        if (this.lowRedundancyBuckets == 0) {
            this.lowestBucketCopies = this.targetRedundancy + 1;
            logger.info("Configured redundancy of " + (this.targetRedundancy + 1) + " copies has been restored to " + this.regionPath);
        }
    }

    synchronized void decrementNoCopiesBucketCount() {
        if (this.noCopiesBuckets == 0) {
            return;
        }
        --this.noCopiesBuckets;
        this.stats.incNoCopiesBucketCount(-1);
        if (this.noCopiesBuckets == 0) {
            this.lowestBucketCopies = 1;
        }
    }

    public int getActualRedundancy() {
        return this.actualRedundancy;
    }

    void setActualRedundancy(int actualRedundancy) {
        int nonNegativeRedundancy;
        this.actualRedundancy = nonNegativeRedundancy = Math.max(actualRedundancy, 0);
        this.stats.setActualRedundantCopies(nonNegativeRedundancy);
    }
}

