/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.internal.cache.backup.RestoreScript;
import org.apache.geode.internal.lang.utils.JavaWorkarounds;

class BackupDefinition {
    private final Map<DiskStore, Set<Path>> oplogFilesByDiskStore = new HashMap<DiskStore, Set<Path>>();
    private final Set<Path> configFiles = new HashSet<Path>();
    private final Map<Path, Path> userFiles = new HashMap<Path, Path>();
    private final Map<Path, Path> deployedJars = new HashMap<Path, Path>();
    private final Map<DiskStore, Path> diskInitFiles = new HashMap<DiskStore, Path>();
    private RestoreScript restoreScript;

    BackupDefinition() {
    }

    void addConfigFileToBackup(Path configFile) {
        this.configFiles.add(configFile);
    }

    void addUserFilesToBackup(Path userFile, Path source) {
        this.userFiles.put(userFile, source);
    }

    void addDeployedJarToBackup(Path deployedJar, Path source) {
        this.deployedJars.put(deployedJar, source);
    }

    void addDiskInitFile(DiskStore diskStore, Path diskInitFile) {
        this.diskInitFiles.put(diskStore, diskInitFile);
    }

    void setRestoreScript(RestoreScript restoreScript) {
        this.restoreScript = restoreScript;
    }

    Map<DiskStore, Collection<Path>> getOplogFilesByDiskStore() {
        return Collections.unmodifiableMap(this.oplogFilesByDiskStore);
    }

    Set<Path> getConfigFiles() {
        return Collections.unmodifiableSet(this.configFiles);
    }

    Map<Path, Path> getUserFiles() {
        return Collections.unmodifiableMap(this.userFiles);
    }

    Map<Path, Path> getDeployedJars() {
        return Collections.unmodifiableMap(this.deployedJars);
    }

    Map<DiskStore, Path> getDiskInitFiles() {
        return Collections.unmodifiableMap(this.diskInitFiles);
    }

    RestoreScript getRestoreScript() {
        return this.restoreScript;
    }

    void addOplogFileToBackup(DiskStore diskStore, Path fileLocation) {
        Set files = (Set)JavaWorkarounds.computeIfAbsent(this.oplogFilesByDiskStore, (Object)diskStore, k -> new HashSet());
        files.add(fileLocation);
    }
}

