/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.DynamicRegionFactory;
import org.apache.geode.cache.operations.UnregisterInterestOperationContext;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.geode.security.ResourcePermission;
import org.jetbrains.annotations.NotNull;

public class UnregisterInterestList
extends BaseCommand {
    @Immutable
    private static final UnregisterInterestList singleton = new UnregisterInterestList();

    public static Command getCommand() {
        return singleton;
    }

    private UnregisterInterestList() {
    }

    @Override
    public void cmdExecute(@NotNull Message clientMessage, @NotNull ServerConnection serverConnection, @NotNull SecurityService securityService, long start) throws IOException, ClassNotFoundException {
        boolean keepAlive;
        serverConnection.setAsTrue(2);
        Part regionNamePart = clientMessage.getPart(0);
        String regionName = regionNamePart.getCachedString();
        Part isClosingListPart = clientMessage.getPart(1);
        byte[] isClosingListPartBytes = (byte[])isClosingListPart.getObject();
        boolean isClosingList = isClosingListPartBytes[0] == 1;
        try {
            Part keepAlivePart = clientMessage.getPart(2);
            byte[] keepAlivePartBytes = (byte[])keepAlivePart.getObject();
            keepAlive = keepAlivePartBytes[0] == 1;
        }
        catch (Exception e) {
            UnregisterInterestList.writeChunkedException(clientMessage, e, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        Part numberOfKeysPart = clientMessage.getPart(3);
        int numberOfKeys = numberOfKeysPart.getInt();
        int partNumber = 4;
        List<Object> keys = new ArrayList<Object>();
        for (int i = 0; i < numberOfKeys; ++i) {
            Object key;
            Part keyPart = clientMessage.getPart(partNumber + i);
            try {
                key = keyPart.getStringOrObject();
            }
            catch (Exception e) {
                UnregisterInterestList.writeException(clientMessage, e, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
            keys.add(key);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received unregister interest request ({} bytes) from {} for the following {} keys in region {}: {}", (Object)serverConnection.getName(), (Object)clientMessage.getPayloadLength(), (Object)serverConnection.getSocketString(), (Object)numberOfKeys, (Object)regionName, keys);
        }
        if (keys.isEmpty() || regionName == null) {
            String errMessage = null;
            if (keys.isEmpty() && regionName == null) {
                errMessage = "The input list of keys is empty and the input region name is null for the unregister interest request.";
            } else if (keys.isEmpty()) {
                errMessage = "The input list of keys for the unregister interest request is empty.";
            } else if (regionName == null) {
                errMessage = "The input region name for the unregister interest request is null.";
            }
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)errMessage);
            UnregisterInterestList.writeErrorResponse(clientMessage, 23, errMessage, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        try {
            securityService.authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, regionName);
        }
        catch (NotAuthorizedException ex) {
            UnregisterInterestList.writeException(clientMessage, ex, false, serverConnection);
            serverConnection.setAsTrue(1);
            return;
        }
        AuthorizeRequest authorizeRequest = serverConnection.getAuthzRequest();
        if (authorizeRequest != null && !DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
            try {
                UnregisterInterestOperationContext unregisterContext = authorizeRequest.unregisterInterestListAuthorize(regionName, keys);
                keys = (List)unregisterContext.getKey();
            }
            catch (NotAuthorizedException ex) {
                UnregisterInterestList.writeException(clientMessage, ex, false, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        serverConnection.getAcceptor().getCacheClientNotifier().unregisterClientInterest(regionName, keys, isClosingList, serverConnection.getProxyID(), keepAlive);
        this.writeReply(clientMessage, serverConnection);
        serverConnection.setAsTrue(1);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sent unregister interest response for the following {} keys in region {}: {}", (Object)serverConnection.getName(), (Object)numberOfKeys, (Object)regionName, keys);
        }
    }
}

