/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan.parallel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.geode.GemFireException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.wan.GatewayQueueEvent;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.RegionQueue;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.GatewaySenderEventDispatcher;
import org.apache.geode.internal.cache.wan.GatewaySenderEventImpl;
import org.apache.geode.internal.cache.wan.GatewaySenderException;
import org.apache.geode.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import org.apache.geode.internal.cache.wan.parallel.ParallelGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.parallel.ParallelGatewaySenderQueue;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ConcurrentParallelGatewaySenderEventProcessor
extends AbstractGatewaySenderEventProcessor {
    protected static final Logger logger = LogService.getLogger();
    protected ParallelGatewaySenderEventProcessor[] processors;
    private GemFireException ex = null;
    final int nDispatcher;

    public ConcurrentParallelGatewaySenderEventProcessor(AbstractGatewaySender sender, ThreadsMonitoring tMonitoring, boolean cleanQueues) {
        super("Event Processor for GatewaySender_" + sender.getId(), sender, tMonitoring);
        logger.info("ConcurrentParallelGatewaySenderEventProcessor: dispatcher threads {}", (Object)sender.getDispatcherThreads());
        this.nDispatcher = sender.getDispatcherThreads();
        HashSet targetRs = new HashSet();
        for (InternalRegion pr : sender.getCache().getApplicationRegions()) {
            if (!pr.getAllGatewaySenderIds().contains(sender.getId())) continue;
            targetRs.add(pr);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("The target PRs are {} Dispatchers: {}", targetRs, (Object)this.nDispatcher);
        }
        this.createProcessors(sender.getDispatcherThreads(), targetRs, cleanQueues);
        this.queue = new ConcurrentParallelGatewaySenderQueue(sender, this.processors);
    }

    protected void createProcessors(int dispatcherThreads, Set<Region<?, ?>> targetRs, boolean cleanQueues) {
        this.processors = new ParallelGatewaySenderEventProcessor[this.sender.getDispatcherThreads()];
        if (logger.isDebugEnabled()) {
            logger.debug("Creating AsyncEventProcessor");
        }
        for (int i = 0; i < this.sender.getDispatcherThreads(); ++i) {
            this.processors[i] = new ParallelGatewaySenderEventProcessor(this.sender, i, this.sender.getDispatcherThreads(), this.getThreadMonitorObj(), cleanQueues);
        }
    }

    @Override
    protected void initializeMessageQueue(String id, boolean cleanQueues) {
    }

    @Override
    public int eventQueueSize() {
        ConcurrentParallelGatewaySenderQueue queue = (ConcurrentParallelGatewaySenderQueue)this.getQueue();
        return queue == null ? 0 : queue.localSize();
    }

    @Override
    public void enqueueEvent(EnumListenerEvent operation, EntryEvent<?, ?> event, Object substituteValue) throws CacheException, IOException {
        this.enqueueEvent(operation, event, substituteValue, false);
    }

    @Override
    public void enqueueEvent(EnumListenerEvent operation, EntryEvent<?, ?> event, Object substituteValue, boolean isLastEventInTransaction) throws CacheException, IOException {
        int bucketId = ((EntryEventImpl)event).getEventId().getBucketID();
        if (bucketId < 0) {
            return;
        }
        int pId = bucketId % this.nDispatcher;
        this.processors[pId].enqueueEvent(operation, event, substituteValue, isLastEventInTransaction);
    }

    @Override
    protected void registerEventDroppedInPrimaryQueue(EntryEventImpl droppedEvent) {
        if (this.queue == null) {
            return;
        }
        ConcurrentParallelGatewaySenderQueue cpgsq = (ConcurrentParallelGatewaySenderQueue)this.queue;
        PartitionedRegion prQ = cpgsq.getRegion(droppedEvent.getRegion().getFullPath());
        if (prQ == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("shadow partitioned region " + droppedEvent.getRegion().getFullPath() + " is not created yet.");
            }
            return;
        }
        int bucketId = PartitionedRegionHelper.getHashKey(droppedEvent);
        long shadowKey = droppedEvent.getTailKey();
        ParallelGatewaySenderQueue pgsq = (ParallelGatewaySenderQueue)cpgsq.getQueueByBucket(bucketId);
        boolean isPrimary = prQ.getRegionAdvisor().getBucketAdvisor(bucketId).isPrimary();
        if (isPrimary) {
            pgsq.sendQueueRemovalMessageForDroppedEvent(prQ, bucketId, shadowKey);
            this.sender.getStatistics().incEventsDroppedDueToPrimarySenderNotRunning();
            if (logger.isDebugEnabled()) {
                logger.debug("register dropped event for primary queue. BucketId is " + bucketId + ", shadowKey is " + shadowKey + ", prQ is " + prQ.getFullPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        for (int i = 0; i < this.processors.length; ++i) {
            if (isDebugEnabled) {
                logger.debug("Starting the ParallelProcessors {}", (Object)i);
            }
            this.processors[i].start();
        }
        try {
            this.waitForRunningStatus();
        }
        catch (GatewaySenderException e) {
            this.ex = e;
        }
        ParallelGatewaySenderEventProcessor[] parallelGatewaySenderEventProcessorArray = this.getRunningStateLock();
        synchronized (parallelGatewaySenderEventProcessorArray) {
            if (this.ex != null) {
                this.setException(this.ex);
                this.setIsStopped(true);
            } else {
                this.setIsStopped(false);
            }
            this.getRunningStateLock().notifyAll();
        }
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            try {
                parallelProcessor.join();
            }
            catch (InterruptedException e) {
                if (!isDebugEnabled) continue;
                logger.debug("Got InterruptedException while waiting for child threads to finish.");
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRunningStatus() {
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            Object object = parallelProcessor.getRunningStateLock();
            synchronized (object) {
                while (parallelProcessor.getException() == null && parallelProcessor.isStopped()) {
                    try {
                        parallelProcessor.getRunningStateLock().wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                Exception ex = parallelProcessor.getException();
                if (ex != null) {
                    throw new GatewaySenderException(String.format("Could not start a gateway sender %s because of exception %s", this.sender.getId(), ex.getMessage()), ex.getCause());
                }
            }
        }
    }

    @Override
    public void stopProcessing() {
        if (!this.isAlive()) {
            return;
        }
        this.setIsStopped(true);
        ArrayList<AbstractGatewaySenderEventProcessor.SenderStopperCallable> stopperCallables = new ArrayList<AbstractGatewaySenderEventProcessor.SenderStopperCallable>();
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            stopperCallables.add(new AbstractGatewaySenderEventProcessor.SenderStopperCallable(parallelProcessor));
        }
        ExecutorService stopperService = LoggingExecutors.newFixedThreadPool((int)this.processors.length, (String)"ConcurrentParallelGatewaySenderEventProcessor Stopper Thread", (boolean)true);
        try {
            List futures = stopperService.invokeAll(stopperCallables);
            for (Future f : futures) {
                try {
                    Boolean b = (Boolean)f.get();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("ConcurrentParallelGatewaySenderEventProcessor: {} stopped dispatching: {}", (Object)(b != false ? "Successfully" : "Unsuccessfully"), (Object)this);
                }
                catch (ExecutionException e) {
                    logger.warn(String.format("GatewaySender %s caught exception while stopping: %s", this.sender, e.getCause()));
                }
            }
        }
        catch (InterruptedException e) {
            throw new InternalGemFireException(e);
        }
        stopperService.shutdown();
        this.closeProcessor();
        if (logger.isDebugEnabled()) {
            logger.debug("ConcurrentParallelGatewaySenderEventProcessor: Stopped dispatching: {}", (Object)this);
        }
    }

    @Override
    public void closeProcessor() {
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            parallelProcessor.closeProcessor();
        }
    }

    @Override
    public void pauseDispatching() {
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            parallelProcessor.pauseDispatching();
        }
        super.pauseDispatching();
        if (logger.isDebugEnabled()) {
            logger.debug("ConcurrentParallelGatewaySenderEventProcessor: Paused dispatching: {}", (Object)this);
        }
    }

    @Override
    public void waitForDispatcherToPause() {
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            parallelProcessor.waitForDispatcherToPause();
        }
    }

    @Override
    public void resumeDispatching() {
        for (ParallelGatewaySenderEventProcessor parallelProcessor : this.processors) {
            parallelProcessor.resumeDispatching();
        }
        super.resumeDispatching();
        if (logger.isDebugEnabled()) {
            logger.debug("ConcurrentParallelGatewaySenderEventProcessor: Resumed dispatching: {}", (Object)this);
        }
    }

    @Override
    protected void waitForResumption() throws InterruptedException {
        super.waitForResumption();
    }

    public List<ParallelGatewaySenderEventProcessor> getProcessors() {
        return new LinkedList<ParallelGatewaySenderEventProcessor>(Arrays.asList(this.processors));
    }

    @Override
    public RegionQueue getQueue() {
        return this.queue;
    }

    @Override
    public GatewaySenderEventDispatcher getDispatcher() {
        return this.processors[0].getDispatcher();
    }

    @Override
    protected void rebalance() {
    }

    @Override
    public void initializeEventDispatcher() {
    }

    @Override
    protected void enqueueEvent(GatewayQueueEvent<?, ?> event) {
        int pId = ((GatewaySenderEventImpl)event).getBucketId() % this.nDispatcher;
        this.processors[pId].enqueueEvent(event);
    }

    private ThreadsMonitoring getThreadMonitorObj() {
        DistributionManager distributionManager = this.sender.getDistributionManager();
        if (distributionManager != null) {
            return distributionManager.getThreadMonitoring();
        }
        return null;
    }
}

