/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans.stats;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.apache.geode.management.internal.FederationComponent;

public class IntegerStatsDeltaAggregator {
    private final AtomicIntegerArray prevCounters;
    private final AtomicIntegerArray currCounters;
    private final List<String> keys;

    public IntegerStatsDeltaAggregator(List<String> keys) {
        this.keys = keys;
        this.prevCounters = new AtomicIntegerArray(keys.size());
        this.currCounters = new AtomicIntegerArray(keys.size());
        this.initializeArray(this.currCounters);
    }

    public void aggregate(FederationComponent newState, FederationComponent oldState) {
        this.incData(newState, oldState);
    }

    private void incData(FederationComponent newComp, FederationComponent oldComp) {
        Map<String, Object> oldState;
        Map<String, Object> newState;
        Map<String, Object> map = newState = newComp != null ? newComp.getObjectState() : null;
        if (oldComp != null && oldComp.getOldState().size() > 0) {
            oldState = oldComp.getOldState();
        } else {
            Map<String, Object> map2 = oldState = oldComp != null ? oldComp.getObjectState() : null;
        }
        if (newState != null) {
            for (int index = 0; index < this.keys.size(); ++index) {
                Object val;
                this.prevCounters.set(index, this.currCounters.get(index));
                Integer newVal = (Integer)newState.get(this.keys.get(index));
                if (newVal == null) continue;
                Integer oldVal = 0;
                if (oldState != null && (val = oldState.get(this.keys.get(index))) != null) {
                    oldVal = (Integer)val;
                }
                this.currCounters.addAndGet(index, newVal - oldVal);
            }
        }
    }

    public int getDelta(String key) {
        int index = this.keys.indexOf(key);
        if (index == -1) {
            return 0;
        }
        return this.currCounters.get(this.keys.indexOf(key)) - this.prevCounters.get(this.keys.indexOf(key));
    }

    private void initializeArray(AtomicIntegerArray arr) {
        for (int i = 0; i < arr.length(); ++i) {
            arr.set(i, 0);
        }
    }
}

