/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import java.util.Collection;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;

public class ContinuousQueryFunction
implements InternalFunction<String> {
    private static final long serialVersionUID = 1L;
    private static final String ID = "org.apache.geode.management.internal.cli.functions.ContinuousQueryFunction";

    public String getId() {
        return ID;
    }

    public void execute(FunctionContext<String> context) {
        try {
            CacheClientNotifier cacheClientNotifier;
            Acceptor acceptor;
            CacheServerImpl server;
            String clientID = (String)context.getArguments();
            InternalCache cache = (InternalCache)context.getCache();
            if (cache.getCacheServers().size() > 0 && (server = (CacheServerImpl)cache.getCacheServers().iterator().next()) != null && (acceptor = server.getAcceptor()) != null && (cacheClientNotifier = acceptor.getCacheClientNotifier()) != null) {
                Collection cacheClientProxySet = cacheClientNotifier.getClientProxies();
                ClientInfo clientInfo = null;
                boolean foundClientinCCP = false;
                for (CacheClientProxy ccp : cacheClientProxySet) {
                    String clientIdFromProxy;
                    if (ccp == null || (clientIdFromProxy = ccp.getProxyID().getDSMembership()) == null || !clientIdFromProxy.equals(clientID)) continue;
                    foundClientinCCP = true;
                    String durableId = ccp.getProxyID().getDurableId();
                    boolean isPrimary = ccp.isPrimary();
                    String id = cache.getDistributedSystem().getDistributedMember().getId();
                    clientInfo = new ClientInfo(durableId != null && durableId.length() > 0 ? "Yes" : "No", isPrimary ? id : "", !isPrimary ? id : "");
                    break;
                }
                if (!foundClientinCCP) {
                    ServerConnection[] serverConnections;
                    for (ServerConnection conn : serverConnections = acceptor.getAllServerConnectionList()) {
                        ClientProxyMembershipID cliIdFrmProxy = conn.getProxyID();
                        if (!clientID.equals(cliIdFrmProxy.getDSMembership())) continue;
                        String durableId = cliIdFrmProxy.getDurableId();
                        clientInfo = new ClientInfo(durableId != null && durableId.length() > 0 ? "Yes" : "No", "N.A.", "N.A.");
                    }
                }
                context.getResultSender().lastResult(clientInfo);
            }
        }
        catch (Exception e) {
            context.getResultSender().lastResult((Object)("Exception in ContinuousQueryFunction =" + e.getMessage()));
        }
        context.getResultSender().lastResult(null);
    }

    public boolean hasResult() {
        return true;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return false;
    }

    public class ClientInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String isDurable;
        public String primaryServer;
        public String secondaryServer;

        public ClientInfo(String IsClientDurable, String primaryServerId, String secondaryServerId) {
            this.isDurable = IsClientDurable;
            this.primaryServer = primaryServerId;
            this.secondaryServer = secondaryServerId;
        }

        public String toString() {
            return "ClientInfo [isDurable=" + this.isDurable + ", primaryServer=" + this.primaryServer + ", secondaryServer=" + this.secondaryServer + "]";
        }
    }
}

