/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.help;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.help.HelpBlock;
import org.apache.geode.management.internal.cli.help.Topic;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.springframework.shell.core.MethodTarget;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class Helper {
    static final String NAME_NAME = "NAME";
    static final String SYNONYMS_NAME = "SYNONYMS";
    static final String SYNOPSIS_NAME = "SYNOPSIS";
    static final String SYNTAX_NAME = "SYNTAX";
    static final String OPTIONS_NAME = "PARAMETERS";
    static final String IS_AVAILABLE_NAME = "IS AVAILABLE";
    private static final String REQUIRED_SUB_NAME = "Required: ";
    private static final String SYNONYMS_SUB_NAME = "Synonyms: ";
    private static final String SPECIFIEDDEFAULTVALUE_SUB_NAME = "Default (if the parameter is specified without value): ";
    private static final String UNSPECIFIEDDEFAULTVALUE_VALUE_SUB_NAME = "Default (if the parameter is not specified): ";
    private static final String VALUE_FIELD = "value";
    private static final String TRUE_TOKEN = "true";
    private static final String FALSE_TOKEN = "false";
    private static final String AVAILABLE = "Available";
    private static final String NOT_AVAILABLE = "Not Available";
    private static final String NO_HELP_EXISTS_FOR_THIS_COMMAND = "No help exists for this command.";
    private static final String HELP_INSTRUCTIONS = GfshParser.LINE_SEPARATOR + "Use " + "help" + " <command name> to display detailed usage information for a specific command." + GfshParser.LINE_SEPARATOR + "Help with command and parameter completion can also be obtained by entering all or a portion of either followed by the \"TAB\" key.";
    private final Map<String, Topic> topics = new TreeMap<String, Topic>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Method> commands = new TreeMap<String, Method>();
    private final Map<String, MethodTarget> availabilityIndicators = new HashMap<String, MethodTarget>();

    public Helper() {
        this.initTopic("Geode", "Apache Geode is a distributed data management platform providing dynamic scalability, high performance and database-like persistence.");
        this.initTopic("Region", "A region is the core building block of the Apache Geode distributed system. Cached data is organized into regions and all data puts, gets, and querying activities are done against them.");
        this.initTopic("WAN", "For multiple data centers in remote locations, Geode provides a WAN gateway to facilitate data sharing. The WAN gateway connects two or more remote sites and then sends asynchronous, batched updates as data is changed.");
        this.initTopic("JMX", "JMX technology provides the tools for building distributed, Web-based, modular and dynamic solutions for managing and monitoring devices, applications, and service-driven networks.");
        this.initTopic("Disk Store", "Disk stores are used to persist data to disk as a backup to your in-memory copy or as overflow storage when memory use is too high.");
        this.initTopic("Locator", "JVMs running Geode discover each other through a TCP service named the locator.");
        this.initTopic("Server", "A server is Geode cluster member which holds a Geode cache. Depending on the topology used it can refer to either a system that responds to client requests or a system that is only a peer to other members.");
        this.initTopic("Manager", "The Manager is a member which has the additional role of a managing & monitoring the Geode distributed system.");
        this.initTopic("Statistics", "iEvery application and server in a Apache Geode distributed system can be configured to perform statistical data collection for analysis.");
        this.initTopic("Lifecycle", "Launching, execution and termination of Geode cluster members such as servers and locators.");
        this.initTopic("Management-Monitoring", "The management of and monitoring of Geode systems using Geode tools, such as Apache Geode Pulse or Data Browser, and JConsole, which is provided with the JDK(TM)");
        this.initTopic("Data", "User data as stored in regions of the Geode distributed system.");
        this.initTopic("Configuration", "Configuration of Apache Geode Cache & Servers/Locators hosting the Cache.");
        this.initTopic("Function Execution", "The function execution service provides solutions for these application use cases: \n\tAn application that executes a server-side transaction or carries out data updates using the Geode distributed locking service. \n\tAn application that needs to initialize some of its components once on each server, which might be used later by executed functions. Initialization and startup of a third-party service, such as a messaging service. \n\tAny arbitrary aggregation operation that requires iteration over local data sets that can be done more efficiently through a single call to the cache server. \n\tAny kind of external resource provisioning that can be done by executing a function on a server.");
        this.initTopic("Help", "Provides usage information for gfsh & its commands.");
        this.initTopic("Debug-Utility", "Debugging aids & utilities to use with Apache Geode.");
        this.initTopic("GFSH", "The Geode Shell");
        this.initTopic("Logs", "Generate log contents as per the need");
        this.initTopic("Client", "Client status");
    }

    private void initTopic(String topic, String desc) {
        this.topics.put(topic, new Topic(topic, desc));
    }

    public void addCommand(CliCommand command, Method commandMethod) {
        Arrays.stream(command.value()).forEach(cmd -> this.commands.put((String)cmd, commandMethod));
        CliMetaData cliMetaData = commandMethod.getDeclaredAnnotation(CliMetaData.class);
        if (cliMetaData == null) {
            return;
        }
        String[] related = cliMetaData.relatedTopic();
        String commandString = command.value()[0];
        Arrays.stream(related).forEach(topic -> {
            Topic foundTopic = this.topics.get(topic);
            if (foundTopic == null) {
                throw new IllegalArgumentException("No such topic found in the initial map: " + topic);
            }
            foundTopic.addRelatedCommand(commandString, command.help());
        });
    }

    public void addAvailabilityIndicator(CliAvailabilityIndicator availability, MethodTarget target) {
        Arrays.stream(availability.value()).forEach(command -> this.availabilityIndicators.put((String)command, target));
    }

    public String getMiniHelp(String userInput) {
        if (StringUtils.isBlank((CharSequence)userInput)) {
            return null;
        }
        List methodList = this.commands.keySet().stream().filter(key -> key.startsWith(this.getCommandPart(userInput))).map(this.commands::get).collect(Collectors.toList());
        if (methodList.size() != 1) {
            return null;
        }
        Method m = (Method)methodList.get(0);
        CliCommand cliCommand = m.getDeclaredAnnotation(CliCommand.class);
        Annotation[][] annotations = m.getParameterAnnotations();
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Annotation[] annotation : annotations) {
            String lookFor;
            boolean requiredWithEquals;
            CliOption cliOption = this.getAnnotation(annotation, CliOption.class);
            String option = Helper.getPrimaryKey(cliOption);
            boolean required = cliOption.mandatory();
            boolean bl = requiredWithEquals = !Helper.isNonEmptyAnnotation(cliOption.specifiedDefaultValue());
            if (Helper.isNonEmptyAnnotation(cliOption.unspecifiedDefaultValue())) {
                required = false;
            }
            if (!required || userInput.contains(lookFor = "--" + option + (requiredWithEquals ? "=" : ""))) continue;
            builder.append("  --").append(option).append(requiredWithEquals ? "=" : "").append("  is required").append(GfshParser.LINE_SEPARATOR);
        }
        if (builder.length() > 0) {
            String commandName = cliCommand.value()[0];
            builder.append("Use \"help ").append(commandName).append("\" (without the quotes) for detailed usage information.").append(GfshParser.LINE_SEPARATOR);
            return builder.toString();
        }
        return null;
    }

    private String getCommandPart(String userInput) {
        int parms = userInput.indexOf(" --");
        return (parms < 0 ? userInput : userInput.substring(0, parms)).trim();
    }

    public String getHelp(String buffer, int terminalWidth) {
        if (StringUtils.isBlank((CharSequence)buffer)) {
            return this.getHelp().toString(terminalWidth);
        }
        List methodList = this.commands.keySet().stream().filter(key -> key.startsWith(buffer)).map(this.commands::get).collect(Collectors.toList());
        boolean summarize = methodList.size() > 1;
        String helpString = methodList.stream().map(m -> this.getHelp(m.getDeclaredAnnotation(CliCommand.class), summarize ? (Annotation[][])null : m.getParameterAnnotations(), summarize ? null : m.getParameterTypes())).map(helpBlock -> helpBlock.toString(terminalWidth)).reduce((s, s2) -> s + s2).orElse(NO_HELP_EXISTS_FOR_THIS_COMMAND);
        if (summarize) {
            helpString = helpString + HELP_INSTRUCTIONS;
        }
        return helpString;
    }

    public String getHint(String buffer) {
        List<String> topicKeys = this.topics.keySet().stream().filter(t -> buffer == null || t.toLowerCase().startsWith(buffer.toLowerCase())).sorted().collect(Collectors.toList());
        StringBuilder builder = new StringBuilder();
        if (topicKeys.isEmpty()) {
            builder.append(CliStrings.format((String)"Unknown topic: {0}. Use hint to view the list of available topics.", (Object)buffer)).append(GfshParser.LINE_SEPARATOR).append(GfshParser.LINE_SEPARATOR);
        } else if (topicKeys.size() == 1) {
            Topic oneTopic = this.topics.get(topicKeys.get(0));
            builder.append(oneTopic.desc).append(GfshParser.LINE_SEPARATOR).append(GfshParser.LINE_SEPARATOR);
            oneTopic.relatedCommands.stream().sorted().forEach(command -> builder.append(command.command).append(": ").append(command.desc).append(GfshParser.LINE_SEPARATOR));
        } else {
            builder.append("Hints are available for the following topics. Use \"hint <topic-name>\" for a specific hint.").append(GfshParser.LINE_SEPARATOR).append(GfshParser.LINE_SEPARATOR);
            topicKeys.forEach(topic -> builder.append((String)topic).append(GfshParser.LINE_SEPARATOR));
        }
        return builder.toString();
    }

    public Set<String> getTopicNames() {
        return this.topics.keySet();
    }

    private boolean isAvailable(String command) {
        MethodTarget target = this.availabilityIndicators.get(command);
        if (target == null) {
            return true;
        }
        try {
            return (Boolean)target.getMethod().invoke(target.getTarget(), new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasAvailabilityIndicator(String command) {
        return this.availabilityIndicators.get(command) != null;
    }

    private HelpBlock getHelp() {
        HelpBlock root = new HelpBlock();
        this.commands.keySet().stream().sorted().map(this.commands::get).forEach(method -> root.addChild(this.getHelp(method.getDeclaredAnnotation(CliCommand.class), null, null)));
        return root;
    }

    HelpBlock getHelp(CliCommand cliCommand, Annotation[][] annotations, Class<?>[] parameterTypes) {
        String commandName = cliCommand.value()[0];
        boolean isAvailable = this.isAvailable(commandName);
        if (annotations == null && parameterTypes == null) {
            String available = isAvailable ? AVAILABLE : NOT_AVAILABLE;
            HelpBlock help = new HelpBlock(commandName + " (" + available + ")");
            help.addChild(new HelpBlock(cliCommand.help()));
            return help;
        }
        HelpBlock root = new HelpBlock();
        HelpBlock name = new HelpBlock(NAME_NAME);
        name.addChild(new HelpBlock(commandName));
        root.addChild(name);
        HelpBlock availability = new HelpBlock(IS_AVAILABLE_NAME);
        availability.addChild(new HelpBlock(isAvailable + ""));
        root.addChild(availability);
        String[] allNames = cliCommand.value();
        if (allNames.length > 1) {
            HelpBlock synonyms = new HelpBlock(SYNONYMS_NAME);
            for (int i = 1; i < allNames.length; ++i) {
                synonyms.addChild(new HelpBlock(allNames[i]));
            }
            root.addChild(synonyms);
        }
        if (StringUtils.isNotBlank((CharSequence)cliCommand.help())) {
            HelpBlock synopsis = new HelpBlock(SYNOPSIS_NAME);
            synopsis.addChild(new HelpBlock(cliCommand.help()));
            root.addChild(synopsis);
        }
        HelpBlock syntaxBlock = new HelpBlock(SYNTAX_NAME);
        String syntax = this.getSyntaxString(commandName, annotations, parameterTypes);
        syntaxBlock.addChild(new HelpBlock(syntax));
        root.addChild(syntaxBlock);
        if (annotations.length > 0) {
            HelpBlock options = new HelpBlock(OPTIONS_NAME);
            for (Annotation[] annotation : annotations) {
                CliOption cliOption = this.getAnnotation(annotation, CliOption.class);
                HelpBlock optionNode = this.getOptionDetail(cliOption);
                options.addChild(optionNode);
            }
            root.addChild(options);
        }
        return root;
    }

    HelpBlock getOptionDetail(CliOption cliOption) {
        HelpBlock optionNode = new HelpBlock(Helper.getPrimaryKey(cliOption));
        String help = cliOption.help();
        optionNode.addChild(new HelpBlock(StringUtils.isNotBlank((CharSequence)help) ? help : ""));
        if (Helper.getSynonyms(cliOption).size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (String string : Helper.getSynonyms(cliOption)) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(string);
            }
            optionNode.addChild(new HelpBlock(SYNONYMS_SUB_NAME + builder));
        }
        optionNode.addChild(new HelpBlock(REQUIRED_SUB_NAME + (cliOption.mandatory() ? TRUE_TOKEN : FALSE_TOKEN)));
        if (Helper.isNonEmptyAnnotation(cliOption.specifiedDefaultValue())) {
            optionNode.addChild(new HelpBlock(SPECIFIEDDEFAULTVALUE_SUB_NAME + cliOption.specifiedDefaultValue()));
        }
        if (Helper.isNonEmptyAnnotation(cliOption.unspecifiedDefaultValue())) {
            optionNode.addChild(new HelpBlock(UNSPECIFIEDDEFAULTVALUE_VALUE_SUB_NAME + cliOption.unspecifiedDefaultValue()));
        }
        return optionNode;
    }

    private <T> T getAnnotation(Annotation[] annotations, Class<T> klass) {
        for (Annotation annotation : annotations) {
            if (!klass.isAssignableFrom(annotation.getClass())) continue;
            return (T)annotation;
        }
        return null;
    }

    String getSyntaxString(String commandName, Annotation[][] annotations, Class[] parameterTypes) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(commandName);
        for (int i = 0; i < annotations.length; ++i) {
            CliOption cliOption = this.getAnnotation(annotations[i], CliOption.class);
            String optionString = Helper.getOptionString(cliOption, parameterTypes[i]);
            if (cliOption.mandatory()) {
                buffer.append(" ").append(optionString);
                continue;
            }
            buffer.append(" [").append(optionString).append("]");
        }
        return buffer.toString();
    }

    private static String getOptionString(CliOption cliOption, Class<?> optionType) {
        String key0 = cliOption.key()[0];
        if ("".equals(key0)) {
            return cliOption.key()[1];
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("--").append(key0);
        boolean hasSpecifiedDefault = Helper.isNonEmptyAnnotation(cliOption.specifiedDefaultValue());
        if (hasSpecifiedDefault) {
            buffer.append("(");
        }
        buffer.append("=").append(VALUE_FIELD);
        if (hasSpecifiedDefault) {
            buffer.append(")?");
        }
        if (Helper.isCollectionOrArrayType(optionType)) {
            buffer.append("(").append(",").append(VALUE_FIELD).append(")*");
        }
        return buffer.toString();
    }

    private static boolean isCollectionOrArrayType(Class<?> typeToCheck) {
        return typeToCheck != null && (typeToCheck.isArray() || Collection.class.isAssignableFrom(typeToCheck));
    }

    private static String getPrimaryKey(CliOption option) {
        String[] keys = option.key();
        if (keys.length == 0) {
            throw new RuntimeException("Invalid option keys");
        }
        if ("".equals(keys[0])) {
            return keys[1];
        }
        return keys[0];
    }

    private static List<String> getSynonyms(CliOption option) {
        ArrayList<String> synonyms = new ArrayList<String>();
        String[] keys = option.key();
        if (keys.length < 2) {
            return synonyms;
        }
        if ("".equals(keys[0])) {
            return synonyms;
        }
        synonyms.addAll(Arrays.asList(keys).subList(1, keys.length));
        return synonyms;
    }

    private static boolean isNonEmptyAnnotation(String value) {
        return !StringUtils.isBlank((CharSequence)value) && !"__NULL__".equals(value);
    }

    public Set<String> getCommands() {
        return this.commands.keySet();
    }

    public Method getCommandMethod(String command) {
        return this.commands.get(command);
    }

    public Set<String> getOptions(String command) {
        Method method = this.getCommandMethod(command);
        HashSet<String> optionList = new HashSet<String>();
        Annotation[][] annotations = method.getParameterAnnotations();
        if (annotations == null || annotations.length == 0) {
            return optionList;
        }
        for (Annotation[] annotation : annotations) {
            CliOption cliOption = this.getAnnotation(annotation, CliOption.class);
            optionList.add(Helper.getPrimaryKey(cliOption));
        }
        return optionList;
    }
}

