/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.locator;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.Membership;
import org.apache.geode.distributed.internal.membership.api.MembershipConfig;
import org.apache.geode.distributed.internal.membership.api.MembershipConfigurationException;
import org.apache.geode.distributed.internal.membership.api.MembershipLocator;
import org.apache.geode.distributed.internal.membership.api.MembershipLocatorStatistics;
import org.apache.geode.distributed.internal.membership.gms.GMSMembership;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.geode.distributed.internal.membership.gms.locator.FindCoordinatorRequest;
import org.apache.geode.distributed.internal.membership.gms.locator.GMSLocator;
import org.apache.geode.distributed.internal.membership.gms.locator.GetViewRequest;
import org.apache.geode.distributed.internal.membership.gms.locator.PeerLocatorRequest;
import org.apache.geode.distributed.internal.membership.gms.locator.PrimaryHandler;
import org.apache.geode.distributed.internal.tcpserver.HostAddress;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.ProtocolChecker;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpHandler;
import org.apache.geode.distributed.internal.tcpserver.TcpServer;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.serialization.ObjectDeserializer;
import org.apache.geode.internal.serialization.ObjectSerializer;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class MembershipLocatorImpl<ID extends MemberIdentifier>
implements MembershipLocator<ID> {
    private static final Logger logger = LogService.getLogger();
    private final TcpServer server;
    private final PrimaryHandler handler;
    private final GMSLocator<ID> gmsLocator;
    private final TcpClient locatorClient;

    public MembershipLocatorImpl(int port, HostAddress bindAddress, ProtocolChecker protocolChecker, Supplier<ExecutorService> executorServiceSupplier, TcpSocketCreator socketCreator, ObjectSerializer objectSerializer, ObjectDeserializer objectDeserializer, TcpHandler fallbackHandler, boolean locatorsAreCoordinators, MembershipLocatorStatistics locatorStats, Path workingDirectory, MembershipConfig config) throws MembershipConfigurationException, UnknownHostException {
        this.handler = new PrimaryHandler(fallbackHandler, config.getLocatorWaitTime(), System::currentTimeMillis, Thread::sleep);
        String host = bindAddress == null ? LocalHostUtil.getLocalHostName() : bindAddress.getHostName();
        InetAddress inetAddress = bindAddress == null ? null : bindAddress.getAddress();
        String threadName = "Distribution Locator on " + host + ": " + port;
        this.server = new TcpServer(port, inetAddress, (TcpHandler)this.handler, threadName, protocolChecker, locatorStats::getStatTime, executorServiceSupplier, socketCreator, objectSerializer, objectDeserializer, "gemfire.TcpServer.READ_TIMEOUT", "gemfire.TcpServer.BACKLOG");
        this.locatorClient = new TcpClient(socketCreator, objectSerializer, objectDeserializer, Socket::new);
        this.gmsLocator = new GMSLocator(bindAddress, config.getLocators(), locatorsAreCoordinators, config.isNetworkPartitionDetectionEnabled(), locatorStats, config.getSecurityUDPDHAlgo(), workingDirectory, this.locatorClient, objectSerializer, objectDeserializer);
        this.handler.addHandler(PeerLocatorRequest.class, this.gmsLocator);
        this.handler.addHandler(FindCoordinatorRequest.class, this.gmsLocator);
        this.handler.addHandler(GetViewRequest.class, this.gmsLocator);
    }

    @Override
    public int start() throws IOException {
        if (!this.isAlive()) {
            this.server.start();
        }
        return this.getPort();
    }

    @Override
    public boolean isAlive() {
        return this.server.isAlive();
    }

    @Override
    public int getPort() {
        return this.server.getPort();
    }

    @Override
    public boolean isShuttingDown() {
        return this.server.isShuttingDown();
    }

    @Override
    public void waitToShutdown(long waitTime) throws InterruptedException {
        this.server.join(waitTime);
    }

    @Override
    public void waitToShutdown() throws InterruptedException {
        this.server.join();
    }

    @Override
    public void restarting() throws IOException {
        this.server.restarting();
    }

    @Override
    public SocketAddress getSocketAddress() {
        return this.server.getSocketAddress();
    }

    @Override
    public void setMembership(Membership<ID> membership) {
        GMSMembership gmsMembership = (GMSMembership)membership;
        this.setServices(gmsMembership.getServices());
    }

    @Override
    public void addHandler(Class<?> clazz, TcpHandler handler) {
        this.handler.addHandler(clazz, handler);
    }

    @Override
    public boolean isHandled(Class<?> clazz) {
        return this.handler.isHandled(clazz);
    }

    @VisibleForTesting
    public GMSLocator<ID> getGMSLocator() {
        return this.gmsLocator;
    }

    public void setServices(Services<ID> services) {
        this.gmsLocator.setServices(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.isAlive()) {
            logger.info("Stopping {}", (Object)this);
            try {
                this.locatorClient.stop(new HostAndPort(((InetSocketAddress)this.getSocketAddress()).getHostString(), this.getPort()));
            }
            catch (ConnectException connectException) {
                // empty catch block
            }
            boolean interrupted = Thread.interrupted();
            long waitTimeMillis = 120000L;
            try {
                this.waitToShutdown(waitTimeMillis);
            }
            catch (InterruptedException ex) {
                interrupted = true;
                logger.warn("Interrupted while stopping {}", (Object)this, (Object)ex);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.isAlive()) {
                logger.fatal("Could not stop {} in {} seconds", (Object)this, (Object)TimeUnit.MILLISECONDS.toSeconds(waitTimeMillis));
            }
        }
    }

    public String toString() {
        return "Locator on " + this.getSocketAddress() + ":" + this.getPort();
    }
}

