/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import java.util.Arrays;
import javax.mail.Message;
import javax.mail.search.SearchTerm;

public final class AndTerm
extends SearchTerm {
    private static final long serialVersionUID = -3583274505380989582L;
    private final SearchTerm[] terms;

    public AndTerm(SearchTerm a, SearchTerm b) {
        this.terms = new SearchTerm[]{a, b};
    }

    public AndTerm(SearchTerm[] terms) {
        this.terms = terms;
    }

    public SearchTerm[] getTerms() {
        return this.terms;
    }

    @Override
    public boolean match(Message message) {
        for (int i = 0; i < this.terms.length; ++i) {
            SearchTerm term = this.terms[i];
            if (term.match(message)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AndTerm)) {
            return false;
        }
        return Arrays.equals(this.terms, ((AndTerm)other).terms);
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.terms.length; ++i) {
            hash = hash * 37 + this.terms[i].hashCode();
        }
        return hash;
    }
}

