/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactions;

import java.util.ArrayList;
import org.multiverse.api.Txn;
import org.multiverse.api.TxnStatus;
import org.multiverse.api.blocking.DefaultRetryLatch;
import org.multiverse.api.blocking.RetryLatch;
import org.multiverse.api.exceptions.AbortOnlyException;
import org.multiverse.api.exceptions.DeadTxnException;
import org.multiverse.api.exceptions.IllegalCommuteException;
import org.multiverse.api.exceptions.IllegalTxnStateException;
import org.multiverse.api.exceptions.PreparedTxnException;
import org.multiverse.api.exceptions.ReadWriteConflict;
import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.api.exceptions.RetryError;
import org.multiverse.api.exceptions.RetryNotAllowedException;
import org.multiverse.api.exceptions.RetryNotPossibleException;
import org.multiverse.api.exceptions.RetryTimeoutException;
import org.multiverse.api.exceptions.SpeculativeConfigurationError;
import org.multiverse.api.exceptions.StmMismatchException;
import org.multiverse.api.exceptions.TxnExecutionException;
import org.multiverse.api.functions.Function;
import org.multiverse.api.lifecycle.TxnEvent;
import org.multiverse.api.lifecycle.TxnListener;
import org.multiverse.stms.gamma.GammaConstants;
import org.multiverse.stms.gamma.GammaObjectPool;
import org.multiverse.stms.gamma.GammaStmUtils;
import org.multiverse.stms.gamma.transactionalobjects.BaseGammaTxnRef;
import org.multiverse.stms.gamma.transactionalobjects.GammaObject;
import org.multiverse.stms.gamma.transactionalobjects.Tranlocal;
import org.multiverse.stms.gamma.transactions.GammaTxnConfig;

public abstract class GammaTxn
implements GammaConstants,
Txn {
    public final GammaObjectPool pool = new GammaObjectPool();
    public int status = 1;
    public GammaTxnConfig config;
    public int attempt;
    public long remainingTimeoutNs;
    public boolean hasWrites;
    public final int transactionType;
    public boolean richmansMansConflictScan;
    public boolean abortOnly = false;
    public final RetryLatch retryListener = new DefaultRetryLatch();
    public ArrayList<TxnListener> listeners;
    public boolean commitConflict;
    public boolean evaluatingCommute = false;

    public GammaTxn(GammaTxnConfig config, int transactionType) {
        config.init();
        this.init(config);
        this.transactionType = transactionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(TxnEvent event) {
        ArrayList<TxnListener> permanentListeners;
        if (this.listeners != null) {
            boolean abort = true;
            try {
                for (int k = 0; k < this.listeners.size(); ++k) {
                    this.listeners.get(k).notify(this, event);
                }
                abort = false;
            }
            finally {
                if (abort) {
                    this.abortIfAlive();
                }
            }
        }
        if ((permanentListeners = this.config.permanentListeners) != null) {
            boolean abort = true;
            try {
                for (int k = 0; k < permanentListeners.size(); ++k) {
                    permanentListeners.get(k).notify(this, event);
                }
                abort = false;
            }
            finally {
                if (abort) {
                    this.abortIfAlive();
                }
            }
        }
    }

    protected RetryError newRetryError() {
        return this.config.controlFlowErrorsReused ? RetryError.INSTANCE : new RetryError(true);
    }

    public final boolean isLean() {
        return this.transactionType == 1 || this.transactionType == 2;
    }

    public final void abortIfAlive() {
        if (this.isAlive()) {
            this.abort();
        }
    }

    public AbortOnlyException abortPrepareOnAbortOnly() {
        this.abortIfAlive();
        return new AbortOnlyException(String.format("[%s] Failed to execute transaction.prepare, reason: the transaction was configured as abortOnly", this.config.familyName));
    }

    public AbortOnlyException abortCommitOnAbortOnly() {
        this.abortIfAlive();
        return new AbortOnlyException(String.format("[%s] Failed to execute transaction.commit, reason: the transaction was configured as abortOnly", this.config.familyName));
    }

    public final ReadWriteConflict abortOnReadWriteConflict(GammaObject object) {
        this.abortIfAlive();
        if (this.attempt == this.config.maxRetries || !this.config.controlFlowErrorsReused) {
            return new ReadWriteConflict(String.format("[%s] Failed transaction, reason: object [%s] contains a read/write-conflict", this.config.familyName, GammaStmUtils.toDebugString(object)));
        }
        return ReadWriteConflict.INSTANCE;
    }

    public DeadTxnException failAbortOnAlreadyCommitted() {
        return new DeadTxnException(String.format("[%s] Failed to execute transaction.abort, reason: the transaction is already committed", this.config.familyName));
    }

    public SpeculativeConfigurationError abortOpenForReadOrWriteOnExplicitLockingDetected(BaseGammaTxnRef ref) {
        this.config.updateSpeculativeConfigurationToUseExplicitLocking();
        this.abortIfAlive();
        if (this.config.controlFlowErrorsReused) {
            return SpeculativeConfigurationError.INSTANCE;
        }
        return new SpeculativeConfigurationError(String.format("[%s] Failed to execute TxnRef.openForRead/openForWrite '%s', reason: the transaction is lean, but explicit locking is required", this.config.familyName, GammaStmUtils.toDebugString(ref)));
    }

    public SpeculativeConfigurationError abortOpenForReadOnNonRefTypeDetected(BaseGammaTxnRef ref) {
        this.config.updateSpeculativeConfigurationToUseNonRefType();
        this.abortIfAlive();
        if (this.config.controlFlowErrorsReused) {
            return SpeculativeConfigurationError.INSTANCE;
        }
        return new SpeculativeConfigurationError(String.format("[%s] Failed to execute TxnRef.openForRead/openForWrite '%s', reason: the transaction is lean, but explicit locking is required", this.config.familyName, GammaStmUtils.toDebugString(ref)));
    }

    public final StmMismatchException abortOpenForReadOnBadStm(GammaObject o) {
        this.abortIfAlive();
        return new StmMismatchException(String.format("[%s] Failed to execute TxnRef.openForRead '%s', reason: the stm the ref was created with is a different stm than the stm of the transaction", this.config.familyName, GammaStmUtils.toDebugString(o)));
    }

    public IllegalTxnStateException abortOpenForReadOnNullLockMode(BaseGammaTxnRef object) {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTxnException(String.format("[%s] Failed to execute TxnRef.openForRead '%s', reason: the LockMode is null", this.config.familyName, GammaStmUtils.toDebugString(object)));
            }
            case 3: {
                return new DeadTxnException(String.format("[%s] Failed to execute TxnRef.openForRead '%s', reason: the Lockmode is null", this.config.familyName, GammaStmUtils.toDebugString(object)));
            }
            case 4: {
                return new DeadTxnException(String.format("[%s] Failed to execute TxnRef.openForRead '%s', reason: the LockMode is null", this.config.familyName, GammaStmUtils.toDebugString(object)));
            }
        }
        throw new IllegalStateException();
    }

    public final IllegalTxnStateException abortOpenForReadOnBadStatus(GammaObject object) {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTxnException(String.format("[%s] Failed to execute TxnRef.openForRead '%s', reason: the transaction is prepared", this.config.familyName, GammaStmUtils.toDebugString(object)));
            }
            case 3: {
                return new DeadTxnException(String.format("[%s] Failed to execute TxnRef.openForRead '%s', reason: the transaction is aborted", this.config.familyName, GammaStmUtils.toDebugString(object)));
            }
            case 4: {
                return new DeadTxnException(String.format("[%s] Failed to execute TxnRef.openForRead '%s', reason: the transaction is committed", this.config.familyName, GammaStmUtils.toDebugString(object)));
            }
        }
        throw new IllegalStateException();
    }

    public final ReadonlyException abortOpenForWriteOnReadonly(GammaObject object) {
        this.abortIfAlive();
        return new ReadonlyException(String.format("[%s] Failed to TxnRef.openForWrite '%s', reason: the transaction is readonly", this.config.familyName, GammaStmUtils.toDebugString(object)));
    }

    public final IllegalTxnStateException abortRetryOnNoRetryPossible() {
        this.abortIfAlive();
        throw new RetryNotPossibleException(String.format("[%s] Failed to execute TxnRef.retry, reason: there are no tracked reads", this.config.familyName));
    }

    public final RetryNotAllowedException abortRetryOnNoBlockingAllowed() {
        this.abortIfAlive();
        return new RetryNotAllowedException(String.format("[%s] Failed to execute TxnRef.retry, reason: the transaction doesn't allow blocking", this.config.familyName));
    }

    public final IllegalTxnStateException abortRetryOnBadStatus() {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTxnException(String.format("[%s] Failed to execute Txn.retry, reason: the transaction is prepared", this.config.familyName));
            }
            case 3: {
                return new DeadTxnException(String.format("[%s] Failed to execute Txn.retry, reason: the transaction is aborted", this.config.familyName));
            }
            case 4: {
                return new DeadTxnException(String.format("[%s] Failed to execute Txn.retry, reason: the transaction is committed", this.config.familyName));
            }
        }
        throw new IllegalStateException();
    }

    public final IllegalArgumentException abortOpenForConstructionOnBadReference(GammaObject ref) {
        this.abortIfAlive();
        return new IllegalArgumentException(String.format("[%s] Failed to execute TxnRef.openForConstruction '%s', reason: the object is not new and has previous commits", this.config.familyName, GammaStmUtils.toDebugString(ref)));
    }

    public final IllegalTxnStateException abortOpenForConstructionOnBadStatus(GammaObject o) {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTxnException(String.format("[%s] Failed to execute TxnRef.openForConstruction '%s', reason: the transaction is prepared", this.config.familyName, GammaStmUtils.toDebugString(o)));
            }
            case 3: {
                return new DeadTxnException(String.format("[%s] Failed to execute TxnRef.openForConstruction '%s', reason: the transaction is aborted", this.config.familyName, GammaStmUtils.toDebugString(o)));
            }
            case 4: {
                return new DeadTxnException(String.format("[%s] Failed to execute TxnRef.openForConstruction '%s', reason: the transaction is committed", this.config.familyName, GammaStmUtils.toDebugString(o)));
            }
        }
        throw new IllegalStateException();
    }

    public final StmMismatchException abortOpenForConstructionOnBadStm(GammaObject o) {
        this.abortIfAlive();
        return new StmMismatchException(String.format("[%s] Failed to execute TxnRef.openForConstruction '%s', reason: the stm the ref was created with is a different stm than the stm of the transaction", this.config.familyName, GammaStmUtils.toDebugString(o)));
    }

    public ReadonlyException abortOpenForConstructionOnReadonly(GammaObject o) {
        this.abortIfAlive();
        return new ReadonlyException(String.format("[%s] Failed to execute TxnRef.openForConstruction '%s', reason: the transaction is readonly", this.config.familyName, GammaStmUtils.toDebugString(o)));
    }

    public SpeculativeConfigurationError abortOpenForConstructionRequired(BaseGammaTxnRef ref) {
        this.config.updateSpeculativeConfigurationToUseConstructedObjects();
        this.abortIfAlive();
        if (this.config.controlFlowErrorsReused) {
            return SpeculativeConfigurationError.INSTANCE;
        }
        return new SpeculativeConfigurationError(String.format("[%s] Failed to execute TxnRef.openForConstruction '%s', reason: the transaction is lean, but explicit attachments of constructed objects is required", this.config.familyName, GammaStmUtils.toDebugString(ref)));
    }

    public SpeculativeConfigurationError abortCommuteOnCommuteDetected(BaseGammaTxnRef ref) {
        this.config.updateSpeculativeConfigurationToUseCommute();
        this.abortIfAlive();
        if (this.config.controlFlowErrorsReused) {
            return SpeculativeConfigurationError.INSTANCE;
        }
        return new SpeculativeConfigurationError(String.format("[%s] Failed to execute TxnRef.commute '%s', reason: the transaction is lean, but commute is required", this.config.familyName, GammaStmUtils.toDebugString(ref)));
    }

    public IllegalTxnStateException abortCommuteOnBadStatus(GammaObject object, Function function) {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTxnException(String.format("[%s] Failed to execute TxnRef.commute '%s' with reference '%s', reason: the transaction is prepared", this.config.familyName, GammaStmUtils.toDebugString(object), function));
            }
            case 3: {
                return new DeadTxnException(String.format("[%s] Failed to execute TxnRef.commute '%s' with reference '%s', reason: the transaction is aborted", this.config.familyName, GammaStmUtils.toDebugString(object), function));
            }
            case 4: {
                return new DeadTxnException(String.format("[%s] Failed to execute TxnRef.commute '%s' with reference '%s', reason: the transaction is prepared", this.config.familyName, GammaStmUtils.toDebugString(object), function));
            }
        }
        throw new IllegalStateException();
    }

    public StmMismatchException abortCommuteOnBadStm(GammaObject object) {
        this.abortIfAlive();
        return new StmMismatchException(String.format("[%s] Failed to execute TxnRef.commute '%s', reason: the stm the ref was created with is a different stm than the stm of the transaction", this.config.familyName, GammaStmUtils.toDebugString(object)));
    }

    public ReadonlyException abortCommuteOnReadonly(GammaObject object) {
        this.abortIfAlive();
        return new ReadonlyException(String.format("[%s] Failed to execute TxnRef.commute '%s', reason: the transaction is readonly", this.config.familyName, GammaStmUtils.toDebugString(object)));
    }

    public NullPointerException abortCommuteOnNullFunction(GammaObject object) {
        this.abortIfAlive();
        return new NullPointerException(String.format("[%s] Failed to execute TxnRef.commute '%s', reason: the function is null", this.config.familyName, GammaStmUtils.toDebugString(object)));
    }

    public final IllegalTxnStateException abortLocateOnBadStatus(GammaObject object) {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTxnException(String.format("[%s] Failed to execute Txn.locate '%s' , reason: the transaction is prepared", GammaStmUtils.toDebugString(object), this.config.familyName));
            }
            case 3: {
                return new DeadTxnException(String.format("[%s] Failed to execute Txn.locate, '%s' reason: the transaction is aborted", GammaStmUtils.toDebugString(object), this.config.familyName));
            }
            case 4: {
                return new DeadTxnException(String.format("[%s] Failed to execute Txn.locate, '%s' reason: the transaction is committed", GammaStmUtils.toDebugString(object), this.config.familyName));
            }
        }
        throw new IllegalStateException();
    }

    public final NullPointerException abortLocateOnNullArgument() {
        this.abortIfAlive();
        return new NullPointerException(String.format("[%s] Failed to execute Txn.locate, reason: the reference is null", this.config.familyName));
    }

    private NullPointerException abortRegisterOnNullListener() {
        this.abortIfAlive();
        return new NullPointerException(String.format("[%s] Failed to execute Txn.register , reason: the listener is null", this.config.familyName));
    }

    private IllegalTxnStateException abortRegisterOnBadStatus() {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTxnException(String.format("[%s] Failed to execute Txn.register, reason: the transaction is prepared", this.config.familyName));
            }
            case 3: {
                return new DeadTxnException(String.format("[%s] Failed to execute Txn.register, reason: the transaction is aborted", this.config.familyName));
            }
            case 4: {
                return new DeadTxnException(String.format("[%s] Failed to execute Txn.register, reason: the transaction is prepared", this.config.familyName));
            }
        }
        throw new IllegalStateException();
    }

    public SpeculativeConfigurationError abortRegisterOnListenerRequired() {
        this.config.updateSpeculativeConfigurationToUseListeners();
        this.abortIfAlive();
        if (this.config.controlFlowErrorsReused) {
            return SpeculativeConfigurationError.INSTANCE;
        }
        return new SpeculativeConfigurationError(String.format("[%s] Failed to execute Txn.register, reason: the transaction is lean, but listeners are required", this.config.familyName));
    }

    public final IllegalTxnStateException abortPrepareOnBadStatus() {
        switch (this.status) {
            case 3: {
                return new DeadTxnException(String.format("[%s] Failed to execute Txn.prepare, reason: the transaction already is aborted", this.config.familyName));
            }
            case 4: {
                return new DeadTxnException(String.format("[%s] Failed to execute Txn.prepare, reason: the transaction already is committed", this.config.familyName));
            }
        }
        throw new IllegalStateException();
    }

    public final IllegalTxnStateException abortCommitOnBadStatus() {
        this.abortIfAlive();
        return new DeadTxnException(String.format("[%s] Failed to execute Txn.commit, reason: the transaction already is aborted", this.config.familyName));
    }

    public TxnExecutionException abortOnOpenForConstructionWhileEvaluatingCommute(GammaObject o) {
        this.abort();
        return new IllegalCommuteException(String.format("[%s] Failed to execute TxnRef.openForConstruction '%s', reason: the transaction is already evaluating a commuting function", this.config.familyName, GammaStmUtils.toDebugString(o)));
    }

    public TxnExecutionException abortOnOpenForReadWhileEvaluatingCommute(GammaObject o) {
        this.abortIfAlive();
        return new IllegalCommuteException(String.format("[%s] Failed to execute TxnRef.openForRead '%s', reason: the transaction is already evaluating a commuting function", this.config.familyName, GammaStmUtils.toDebugString(o)));
    }

    public TxnExecutionException abortOnOpenForCommuteWhileEvaluatingCommute(GammaObject o) {
        this.abortIfAlive();
        return new IllegalCommuteException(String.format("[%s] Failed to execute TxnRef.openForCommute '%s', reason: the transaction is already evaluating a commuting function", this.config.familyName, GammaStmUtils.toDebugString(o)));
    }

    public IllegalTxnStateException abortEnsureOnBadStatus(BaseGammaTxnRef o) {
        switch (this.status) {
            case 2: {
                this.abort();
                return new PreparedTxnException(String.format("[%s] Failed to execute TxnRef.ensure with reference '%s', reason: the transaction is prepared", this.config.familyName, GammaStmUtils.toDebugString(o)));
            }
            case 3: {
                return new DeadTxnException(String.format("[%s] Failed to execute TxnRef.ensure with reference '%s', reason: the transaction is aborted", this.config.familyName, GammaStmUtils.toDebugString(o)));
            }
            case 4: {
                return new DeadTxnException(String.format("[%s] Failed to execute TxnRef.ensure with reference '%s', reason: the transaction is committed", this.config.familyName, GammaStmUtils.toDebugString(o)));
            }
        }
        throw new IllegalStateException();
    }

    public final SpeculativeConfigurationError abortOnTransactionTooSmall(int minimalSize) {
        this.config.updateSpeculativeConfigurationToUseMinimalTransactionLength(minimalSize);
        this.abortIfAlive();
        if (this.config.controlFlowErrorsReused) {
            return SpeculativeConfigurationError.INSTANCE;
        }
        return new SpeculativeConfigurationError(String.format("[%s] Failed to execute opening a TxnRef, reason: the transaction is too small for this operation", this.config.familyName));
    }

    public final SpeculativeConfigurationError abortOnRichmanConflictScanDetected() {
        this.config.updateSpeculativeConfigurationToUseRichMansConflictScan();
        this.abortIfAlive();
        if (this.config.controlFlowErrorsReused) {
            return SpeculativeConfigurationError.INSTANCE;
        }
        return new SpeculativeConfigurationError(String.format("[%s] Failed to execute evaluate the Txn read consistency, reason: the transaction is large to be used in combination for a poor mans conflictscan", this.config.familyName));
    }

    public SpeculativeConfigurationError abortEnsureOnEnsureDetected(GammaObject o) {
        this.config.updateSpeculativeConfigurationToUseEnsure();
        this.abortIfAlive();
        if (this.config.controlFlowErrorsReused) {
            return SpeculativeConfigurationError.INSTANCE;
        }
        return new SpeculativeConfigurationError(String.format("[%s] Failed to execute evaluate the TxnRef.ensure [%s], reason: the transaction lean and a fat one needs to be used", this.config.familyName, GammaStmUtils.toDebugString(o)));
    }

    public final NullPointerException abortAcquireOnNullLockMode(GammaObject o) {
        switch (this.status) {
            case 1: {
                this.abort();
                return new NullPointerException();
            }
            case 2: {
                this.abort();
                return new NullPointerException();
            }
            case 3: {
                return new NullPointerException();
            }
            case 4: {
                return new NullPointerException();
            }
        }
        throw new IllegalStateException();
    }

    public final boolean hasWrites() {
        return this.hasWrites;
    }

    @Override
    public abstract void commit();

    @Override
    public abstract void abort();

    public abstract Tranlocal locate(BaseGammaTxnRef var1);

    @Override
    public final GammaTxnConfig getConfig() {
        return this.config;
    }

    @Override
    public final int getAttempt() {
        return this.attempt;
    }

    @Override
    public final long getRemainingTimeoutNs() {
        return this.remainingTimeoutNs;
    }

    @Override
    public boolean isAbortOnly() {
        switch (this.status) {
            case 1: {
                return this.abortOnly;
            }
            case 2: {
                return this.abortOnly;
            }
            case 4: {
                throw new DeadTxnException(String.format("[%s] Failed to execute Txn.isAbortOnly, reason: the transaction is committed", this.config.familyName));
            }
            case 3: {
                throw new DeadTxnException(String.format("[%s] Failed to execute Txn.isAbortOnly, reason: the transaction is aborted", this.config.familyName));
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public final void setAbortOnly() {
        switch (this.status) {
            case 1: {
                if (this.isLean()) {
                    this.config.updateSpeculativeConfigureToUseAbortOnly();
                    this.abort();
                    if (this.config.controlFlowErrorsReused) {
                        throw SpeculativeConfigurationError.INSTANCE;
                    }
                    throw new SpeculativeConfigurationError(String.format("[%s] Failed to execute Txn.setAbortOnly, reason: the transaction is lean, but a fat one is required for dealing with the abortOnly", this.config.familyName));
                }
                this.abortOnly = true;
                break;
            }
            case 2: {
                this.abort();
                throw new PreparedTxnException(String.format("[%s] Failed to execute Txn.setAbortOnly, reason: the transaction is prepared", this.config.familyName));
            }
            case 4: {
                throw new DeadTxnException(String.format("[%s] Failed to execute Txn.setAbortOnly, reason: the transaction is committed", this.config.familyName));
            }
            case 3: {
                throw new DeadTxnException(String.format("[%s] Failed to execute Txn.setAbortOnly, reason: the transaction is aborted", this.config.familyName));
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public void register(TxnListener listener) {
        if (listener == null) {
            throw this.abortRegisterOnNullListener();
        }
        if (this.status != 1) {
            throw this.abortRegisterOnBadStatus();
        }
        if (this.transactionType == 1 || this.transactionType == 2) {
            throw this.abortRegisterOnListenerRequired();
        }
        if (this.listeners == null) {
            this.listeners = this.pool.takeArrayList();
        }
        this.listeners.add(listener);
    }

    public abstract void hardReset();

    public abstract boolean softReset();

    public abstract Tranlocal getRefTranlocal(BaseGammaTxnRef var1);

    public final boolean isAlive() {
        return this.status == 1 || this.status == 2;
    }

    public final void awaitUpdate() {
        long lockEra = this.retryListener.getEra();
        if (this.config.timeoutNs == Long.MAX_VALUE) {
            if (this.config.isInterruptible()) {
                this.retryListener.await(lockEra, this.config.familyName);
            } else {
                this.retryListener.awaitUninterruptible(lockEra);
            }
        } else {
            this.remainingTimeoutNs = this.config.isInterruptible() ? this.retryListener.awaitNanos(lockEra, this.remainingTimeoutNs, this.config.familyName) : this.retryListener.awaitNanosUninterruptible(lockEra, this.remainingTimeoutNs);
            if (this.remainingTimeoutNs < 0L) {
                throw new RetryTimeoutException(String.format("[%s] Txn has timed out with a total timeout of %s ns", this.config.getFamilyName(), this.config.getTimeoutNs()));
            }
        }
    }

    public final void copyForSpeculativeFailure(GammaTxn failingTx) {
        this.remainingTimeoutNs = failingTx.remainingTimeoutNs;
        this.attempt = failingTx.attempt;
    }

    public final void init(GammaTxnConfig config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.config = config;
        this.hardReset();
    }

    public abstract boolean isReadConsistent(Tranlocal var1);

    @Override
    public final TxnStatus getStatus() {
        switch (this.status) {
            case 1: {
                return TxnStatus.Active;
            }
            case 2: {
                return TxnStatus.Prepared;
            }
            case 4: {
                return TxnStatus.Committed;
            }
            case 3: {
                return TxnStatus.Aborted;
            }
        }
        throw new IllegalStateException();
    }

    public final boolean skipPrepare() {
        return this.config.readLockModeAsInt == 3 && !this.config.dirtyCheck;
    }

    public abstract void initLocalConflictCounter();
}

