/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.ldap.LDAPConnectionService;
import org.apache.guacamole.auth.ldap.conf.LDAPConfiguration;
import org.apache.guacamole.auth.ldap.conf.LDAPGuacamoleProperties;
import org.apache.guacamole.net.auth.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectQueryService {
    private static final Logger logger = LoggerFactory.getLogger(ObjectQueryService.class);
    @Inject
    private LDAPConnectionService ldapService;

    public String getIdentifier(Entry entry, Collection<String> attributes) throws LdapInvalidAttributeValueException {
        for (String identifierAttribute : attributes) {
            Attribute identifier = entry.get(identifierAttribute);
            if (identifier == null) continue;
            return identifier.getString();
        }
        return null;
    }

    public ExprNode generateQuery(ExprNode filter, Collection<String> attributes, String attributeValue) {
        AndNode searchFilter = new AndNode();
        searchFilter.addNode(filter);
        if (attributes.size() < 1) {
            return searchFilter;
        }
        OrNode attributeFilter = new OrNode();
        if (attributeValue != null) {
            attributes.forEach(attribute -> attributeFilter.addNode((ExprNode)new EqualityNode(attribute, attributeValue)));
        } else {
            attributes.forEach(attribute -> attributeFilter.addNode((ExprNode)new PresenceNode(attribute)));
        }
        searchFilter.addNode((ExprNode)attributeFilter);
        logger.trace("Sending LDAP filter: \"{}\"", (Object)searchFilter.toString());
        return searchFilter;
    }

    /*
     * Unable to fully structure code
     */
    public List<Entry> search(LDAPConfiguration config, LdapNetworkConnection ldapConnection, Dn baseDN, ExprNode query, int searchHop, Collection<String> attributes) throws GuacamoleException {
        block21: {
            maxHops = config.getMaxReferralHops();
            if (searchHop >= maxHops) {
                ObjectQueryService.logger.debug("Refusing to follow further referrals as the maximum number of referral hops ({}) has been reached. LDAP search results may be incomplete. If further referrals should be followed, consider setting the \"{}\" property to a larger value.", (Object)maxHops, (Object)LDAPGuacamoleProperties.LDAP_MAX_REFERRAL_HOPS.getName());
                return Collections.emptyList();
            }
            ObjectQueryService.logger.debug("Searching \"{}\" for objects matching \"{}\".", (Object)baseDN, (Object)query);
            request = this.ldapService.getSearchRequest(config, baseDN, query);
            if (attributes != null) {
                request.addAttributes(attributes.toArray(new String[0]));
            }
            entries = new ArrayList<Entry>();
            results = ldapConnection.search(request);
lbl13:
            // 2 sources

            try {
                while (results.next()) {
                    block22: {
                        if (results.isEntry()) {
                            entries.add(results.getEntry());
                            continue;
                        }
                        if (!results.isReferral()) continue;
                        if (!request.isFollowReferrals()) break block22;
                        for (String url : results.getReferral().getLdapUrls()) {
                            try {
                                referralConnection = this.ldapService.bindAs(config, url, ldapConnection);
                                try {
                                    if (referralConnection != null) {
                                        ObjectQueryService.logger.debug("Following referral to \"{}\"...", (Object)url);
                                        entries.addAll(this.search(config, referralConnection, baseDN, query, searchHop + 1, attributes));
                                        continue;
                                    }
                                    ObjectQueryService.logger.debug("Could not bind with LDAP server indicated by referral URL \"{}\".", (Object)url);
                                }
                                finally {
                                    if (referralConnection == null) continue;
                                    referralConnection.close();
                                }
                            }
                            catch (GuacamoleException e) {
                                ObjectQueryService.logger.warn("Referral to \"{}\" could not be followed: {}", (Object)url, (Object)e.getMessage());
                                ObjectQueryService.logger.debug("Failed to follow LDAP referral.", (Throwable)e);
                            }
                        }
                        ** GOTO lbl13
                    }
                    ObjectQueryService.logger.debug("Referrals to one or more other LDAP servers were received but are being ignored because following of referrals is not enabled. If referrals must be followed, consider setting the \"{}\" property to \"true\".", (Object)LDAPGuacamoleProperties.LDAP_FOLLOW_REFERRALS.getName());
                }
                var11_12 = entries;
                if (results == null) break block21;
            }
            catch (Throwable var11_13) {
                try {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable var12_15) {
                            var11_13.addSuppressed(var12_15);
                        }
                    }
                    throw var11_13;
                }
                catch (IOException | CursorException | LdapException e) {
                    throw new GuacamoleServerException("Unable to query list of objects from LDAP directory: " + e.getMessage(), e);
                }
            }
            results.close();
        }
        return var11_12;
    }

    public List<Entry> search(LDAPConfiguration config, LdapNetworkConnection ldapConnection, Dn baseDN, ExprNode filter, Collection<String> filterAttributes, String filterValue, Collection<String> attributes) throws GuacamoleException {
        ExprNode query = this.generateQuery(filter, filterAttributes, filterValue);
        return this.search(config, ldapConnection, baseDN, query, 0, attributes);
    }

    public <ObjectType extends Identifiable> Map<String, ObjectType> asMap(List<Entry> entries, Function<Entry, ObjectType> mapper) {
        HashMap<String, Identifiable> objects = new HashMap<String, Identifiable>(entries.size());
        for (Entry entry : entries) {
            Identifiable object = (Identifiable)mapper.apply(entry);
            if (object == null) {
                logger.debug("Ignoring object \"{}\".", (Object)entry.getDn().toString());
                continue;
            }
            String identifier = object.getIdentifier();
            if (objects.putIfAbsent(identifier, object) == null) continue;
            logger.warn("Multiple objects ambiguously map to the same identifier (\"{}\"). Ignoring \"{}\" as a duplicate.", (Object)identifier, (Object)entry.getDn().toString());
        }
        return objects;
    }
}

