/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.internal.InternalServerErrorException;
import com.microsoft.azure.cosmosdb.internal.JavaStreamUtils;
import com.microsoft.azure.cosmosdb.internal.MutableVolatile;
import com.microsoft.azure.cosmosdb.internal.Quadruple;
import com.microsoft.azure.cosmosdb.internal.RequestChargeTracker;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.AddressSelector;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.BarrierRequestHelper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GatewayServiceConfigurationReader;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GoneException;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ReadMode;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ReplicatedResourceClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreReader;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResult;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.TransportClient;
import com.microsoft.azure.cosmosdb.rx.internal.Configs;
import com.microsoft.azure.cosmosdb.rx.internal.IAuthorizationTokenProvider;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Single;

public class QuorumReader {
    private static final Logger logger = LoggerFactory.getLogger(QuorumReader.class);
    private final int maxNumberOfReadBarrierReadRetries;
    private final int maxNumberOfPrimaryReadRetries;
    private final int maxNumberOfReadQuorumRetries;
    private final int delayBetweenReadBarrierCallsInMs;
    private final int maxBarrierRetriesForMultiRegion;
    private final int barrierRetryIntervalInMsForMultiRegion;
    private final int maxShortBarrierRetriesForMultiRegion;
    private final int shortBarrierRetryIntervalInMsForMultiRegion;
    private final StoreReader storeReader;
    private final GatewayServiceConfigurationReader serviceConfigReader;
    private final IAuthorizationTokenProvider authorizationTokenProvider;

    public QuorumReader(Configs configs, TransportClient transportClient, AddressSelector addressSelector, StoreReader storeReader, GatewayServiceConfigurationReader serviceConfigReader, IAuthorizationTokenProvider authorizationTokenProvider) {
        this.storeReader = storeReader;
        this.serviceConfigReader = serviceConfigReader;
        this.authorizationTokenProvider = authorizationTokenProvider;
        this.maxNumberOfReadBarrierReadRetries = configs.getMaxNumberOfReadBarrierReadRetries();
        this.maxNumberOfPrimaryReadRetries = configs.getMaxNumberOfPrimaryReadRetries();
        this.maxNumberOfReadQuorumRetries = configs.getMaxNumberOfReadQuorumRetries();
        this.delayBetweenReadBarrierCallsInMs = configs.getDelayBetweenReadBarrierCallsInMs();
        this.maxBarrierRetriesForMultiRegion = configs.getMaxBarrierRetriesForMultiRegion();
        this.barrierRetryIntervalInMsForMultiRegion = configs.getBarrierRetryIntervalInMsForMultiRegion();
        this.maxShortBarrierRetriesForMultiRegion = configs.getMaxShortBarrierRetriesForMultiRegion();
        this.shortBarrierRetryIntervalInMsForMultiRegion = configs.getShortBarrierRetryIntervalInMsForMultiRegion();
    }

    public QuorumReader(TransportClient transportClient, AddressSelector addressSelector, StoreReader storeReader, GatewayServiceConfigurationReader serviceConfigReader, IAuthorizationTokenProvider authorizationTokenProvider, Configs configs) {
        this(configs, transportClient, addressSelector, storeReader, serviceConfigReader, authorizationTokenProvider);
    }

    public Single<StoreResponse> readStrongAsync(RxDocumentServiceRequest entity, int readQuorumValue, ReadMode readMode) {
        MutableVolatile shouldRetryOnSecondary = new MutableVolatile((Object)false);
        MutableVolatile hasPerformedReadFromPrimary = new MutableVolatile((Object)false);
        return Observable.defer(() -> {
            if (entity.requestContext.timeoutHelper.isElapsed()) {
                return Observable.error((Throwable)new GoneException());
            }
            shouldRetryOnSecondary.v = false;
            Single<ReadQuorumResult> secondaryQuorumReadResultObs = this.readQuorumAsync(entity, readQuorumValue, false, readMode);
            return secondaryQuorumReadResultObs.toObservable().flatMap(secondaryQuorumReadResult -> {
                switch (secondaryQuorumReadResult.quorumResult) {
                    case QuorumMet: {
                        try {
                            return Observable.just((Object)secondaryQuorumReadResult.getResponse());
                        }
                        catch (DocumentClientException e) {
                            return Observable.error((Throwable)e);
                        }
                    }
                    case QuorumSelected: {
                        Single<RxDocumentServiceRequest> barrierRequestObs = BarrierRequestHelper.createAsync(entity, this.authorizationTokenProvider, secondaryQuorumReadResult.selectedLsn, secondaryQuorumReadResult.globalCommittedSelectedLsn);
                        return barrierRequestObs.toObservable().flatMap(barrierRequest -> {
                            Single<Boolean> readBarrierObs = this.waitForReadBarrierAsync((RxDocumentServiceRequest)barrierRequest, true, readQuorumValue, secondaryQuorumReadResult.selectedLsn, secondaryQuorumReadResult.globalCommittedSelectedLsn, readMode);
                            return readBarrierObs.toObservable().flatMap(readBarrier -> {
                                if (readBarrier.booleanValue()) {
                                    try {
                                        return Observable.just((Object)secondaryQuorumReadResult.getResponse());
                                    }
                                    catch (Exception e) {
                                        return Observable.error((Throwable)e);
                                    }
                                }
                                logger.warn("QuorumSelected: Could not converge on the LSN {} GlobalCommittedLSN {} after primary read barrier with read quorum {} for strong read, Responses: {}", new Object[]{secondaryQuorumReadResult.selectedLsn, secondaryQuorumReadResult.globalCommittedSelectedLsn, readQuorumValue, String.join((CharSequence)";", secondaryQuorumReadResult.storeResponses)});
                                entity.requestContext.quorumSelectedStoreResponse = secondaryQuorumReadResult.selectedResponse;
                                entity.requestContext.storeResponses = secondaryQuorumReadResult.storeResponses;
                                entity.requestContext.quorumSelectedLSN = secondaryQuorumReadResult.selectedLsn;
                                entity.requestContext.globalCommittedSelectedLSN = secondaryQuorumReadResult.globalCommittedSelectedLsn;
                                return Observable.empty();
                            });
                        });
                    }
                    case QuorumNotSelected: {
                        if (((Boolean)hasPerformedReadFromPrimary.v).booleanValue()) {
                            logger.warn("QuorumNotSelected: Primary read already attempted. Quorum could not be selected after retrying on secondaries.");
                            return Observable.error((Throwable)new GoneException("Read Quorum size of %d is not met for the request."));
                        }
                        logger.warn("QuorumNotSelected: Quorum could not be selected with read quorum of {}", (Object)readQuorumValue);
                        Single<ReadPrimaryResult> responseObs = this.readPrimaryAsync(entity, readQuorumValue, false);
                        return responseObs.toObservable().flatMap(response -> {
                            if (response.isSuccessful && response.shouldRetryOnSecondary) {
                                assert (false) : "QuorumNotSelected: PrimaryResult has both Successful and shouldRetryOnSecondary flags set";
                                logger.error("PrimaryResult has both Successful and shouldRetryOnSecondary flags set");
                            } else {
                                if (response.isSuccessful) {
                                    logger.debug("QuorumNotSelected: ReadPrimary successful");
                                    try {
                                        return Observable.just((Object)response.getResponse());
                                    }
                                    catch (DocumentClientException e) {
                                        return Observable.error((Throwable)e);
                                    }
                                }
                                if (response.shouldRetryOnSecondary) {
                                    shouldRetryOnSecondary.v = true;
                                    logger.warn("QuorumNotSelected: ReadPrimary did not succeed. Will retry on secondary.");
                                    hasPerformedReadFromPrimary.v = true;
                                } else {
                                    logger.warn("QuorumNotSelected: Could not get successful response from ReadPrimary");
                                    return Observable.error((Throwable)new GoneException(String.format("Read Quorum size of %d is not met for the request.", readQuorumValue)));
                                }
                            }
                            return Observable.empty();
                        });
                    }
                }
                logger.error("Unknown ReadQuorum result {}", (Object)secondaryQuorumReadResult.quorumResult.toString());
                return Observable.error((Throwable)new InternalServerErrorException("Unknown server error occurred when processing this request."));
            });
        }).repeat((long)this.maxNumberOfReadQuorumRetries).takeUntil(dummy -> (Boolean)shouldRetryOnSecondary.v == false).concatWith(Observable.defer(() -> {
            logger.warn("Could not complete read quorum with read quorum value of {}", (Object)readQuorumValue);
            return Observable.error((Throwable)new GoneException(String.format("Read Quorum size of %d is not met for the request.", readQuorumValue)));
        })).take(1).toSingle();
    }

    private Single<ReadQuorumResult> readQuorumAsync(RxDocumentServiceRequest entity, int readQuorum, boolean includePrimary, ReadMode readMode) {
        if (entity.requestContext.timeoutHelper.isElapsed()) {
            return Single.error((Throwable)new GoneException());
        }
        return this.ensureQuorumSelectedStoreResponse(entity, readQuorum, includePrimary, readMode).flatMap(res -> {
            if (res.getLeft() != null) {
                return Single.just((Object)res.getKey());
            }
            long readLsn = (Long)((Quadruple)res.getValue()).getValue0();
            long globalCommittedLSN = (Long)((Quadruple)res.getValue()).getValue1();
            StoreResult storeResult = (StoreResult)((Quadruple)res.getValue()).getValue2();
            List storeResponses = (List)((Quadruple)res.getValue()).getValue3();
            Single<RxDocumentServiceRequest> barrierRequestObs = BarrierRequestHelper.createAsync(entity, this.authorizationTokenProvider, readLsn, globalCommittedLSN);
            return barrierRequestObs.flatMap(barrierRequest -> {
                Single<Boolean> waitForObs = this.waitForReadBarrierAsync((RxDocumentServiceRequest)barrierRequest, false, readQuorum, readLsn, globalCommittedLSN, readMode);
                return waitForObs.flatMap(waitFor -> {
                    if (!waitFor.booleanValue()) {
                        return Single.just((Object)new ReadQuorumResult(entity.requestContext.requestChargeTracker, ReadQuorumResultKind.QuorumSelected, readLsn, globalCommittedLSN, storeResult, storeResponses));
                    }
                    return Single.just((Object)new ReadQuorumResult(entity.requestContext.requestChargeTracker, ReadQuorumResultKind.QuorumMet, readLsn, globalCommittedLSN, storeResult, storeResponses));
                });
            });
        });
    }

    private Single<Pair<ReadQuorumResult, Quadruple<Long, Long, StoreResult, List<String>>>> ensureQuorumSelectedStoreResponse(RxDocumentServiceRequest entity, int readQuorum, boolean includePrimary, ReadMode readMode) {
        if (entity.requestContext.quorumSelectedStoreResponse == null) {
            Single<List<StoreResult>> responseResultObs = this.storeReader.readMultipleReplicaAsync(entity, includePrimary, readQuorum, true, false, readMode);
            return responseResultObs.flatMap(responseResult -> {
                Utils.ValueHolder storeResult;
                Utils.ValueHolder globalCommittedLSN;
                Utils.ValueHolder readLsn;
                List<String> storeResponses = responseResult.stream().map(response -> response.toString()).collect(Collectors.toList());
                int responseCount = (int)responseResult.stream().filter(response -> response.isValid).count();
                if (responseCount < readQuorum) {
                    return Single.just((Object)Pair.of((Object)new ReadQuorumResult(entity.requestContext.requestChargeTracker, ReadQuorumResultKind.QuorumNotSelected, -1L, -1L, null, storeResponses), null));
                }
                boolean isGlobalStrongReadCandidate = ReplicatedResourceClient.isGlobalStrongEnabled() && this.serviceConfigReader.getDefaultConsistencyLevel() == ConsistencyLevel.Strong && (entity.requestContext.originalRequestConsistencyLevel == null || entity.requestContext.originalRequestConsistencyLevel == ConsistencyLevel.Strong);
                if (this.isQuorumMet((List<StoreResult>)responseResult, readQuorum, false, isGlobalStrongReadCandidate, (Utils.ValueHolder<Long>)(readLsn = new Utils.ValueHolder((Object)-1)), (Utils.ValueHolder<Long>)(globalCommittedLSN = new Utils.ValueHolder((Object)-1)), (Utils.ValueHolder<StoreResult>)(storeResult = new Utils.ValueHolder(null)))) {
                    return Single.just((Object)Pair.of((Object)new ReadQuorumResult(entity.requestContext.requestChargeTracker, ReadQuorumResultKind.QuorumMet, (Long)readLsn.v, (Long)globalCommittedLSN.v, (StoreResult)storeResult.v, storeResponses), null));
                }
                entity.requestContext.forceRefreshAddressCache = false;
                Quadruple state = Quadruple.with((Object)readLsn.v, (Object)globalCommittedLSN.v, (Object)storeResult.v, storeResponses);
                return Single.just((Object)Pair.of(null, (Object)state));
            });
        }
        Utils.ValueHolder readLsn = Utils.ValueHolder.initialize((Object)entity.requestContext.quorumSelectedLSN);
        Utils.ValueHolder globalCommittedLSN = Utils.ValueHolder.initialize((Object)entity.requestContext.globalCommittedSelectedLSN);
        Utils.ValueHolder storeResult = Utils.ValueHolder.initialize((Object)entity.requestContext.quorumSelectedStoreResponse);
        List storeResponses = entity.requestContext.storeResponses;
        Quadruple state = Quadruple.with((Object)readLsn.v, (Object)globalCommittedLSN.v, (Object)storeResult.v, (Object)storeResponses);
        return Single.just((Object)Pair.of(null, (Object)state));
    }

    private Single<ReadPrimaryResult> readPrimaryAsync(RxDocumentServiceRequest entity, int readQuorum, boolean useSessionToken) {
        if (entity.requestContext.timeoutHelper.isElapsed()) {
            return Single.error((Throwable)new GoneException());
        }
        entity.requestContext.forceRefreshAddressCache = false;
        Single<StoreResult> storeResultObs = this.storeReader.readPrimaryAsync(entity, true, useSessionToken);
        return storeResultObs.flatMap(storeResult -> {
            if (!storeResult.isValid) {
                try {
                    return Single.error((Throwable)storeResult.getException());
                }
                catch (InternalServerErrorException e) {
                    return Single.error((Throwable)e);
                }
            }
            if (storeResult.currentReplicaSetSize <= 0 || storeResult.lsn < 0L || storeResult.quorumAckedLSN < 0L) {
                String message = String.format("Invalid value received from response header. CurrentReplicaSetSize %d, StoreLSN %d, QuorumAckedLSN %d", storeResult.currentReplicaSetSize, storeResult.lsn, storeResult.quorumAckedLSN);
                logger.error(message);
                return Single.error((Throwable)new GoneException(String.format("Read Quorum size of %d is not met for the request.", readQuorum)));
            }
            if (storeResult.currentReplicaSetSize > readQuorum) {
                logger.warn("Unexpected response. Replica Set size is {} which is greater than min value {}", (Object)storeResult.currentReplicaSetSize, (Object)readQuorum);
                return Single.just((Object)new ReadPrimaryResult(entity.requestContext.requestChargeTracker, false, true, null));
            }
            if (storeResult.lsn != storeResult.quorumAckedLSN) {
                logger.warn("Store LSN {} and quorum acked LSN {} don't match", (Object)storeResult.lsn, (Object)storeResult.quorumAckedLSN);
                long higherLsn = storeResult.lsn > storeResult.quorumAckedLSN ? storeResult.lsn : storeResult.quorumAckedLSN;
                Single<RxDocumentServiceRequest> waitForLsnRequestObs = BarrierRequestHelper.createAsync(entity, this.authorizationTokenProvider, higherLsn, null);
                return waitForLsnRequestObs.flatMap(waitForLsnRequest -> {
                    Single<PrimaryReadOutcome> primaryWaitForLsnResponseObs = this.waitForPrimaryLsnAsync((RxDocumentServiceRequest)waitForLsnRequest, higherLsn, readQuorum);
                    return primaryWaitForLsnResponseObs.map(primaryWaitForLsnResponse -> {
                        if (primaryWaitForLsnResponse == PrimaryReadOutcome.QuorumNotMet) {
                            return new ReadPrimaryResult(entity.requestContext.requestChargeTracker, false, false, null);
                        }
                        if (primaryWaitForLsnResponse == PrimaryReadOutcome.QuorumInconclusive) {
                            return new ReadPrimaryResult(entity.requestContext.requestChargeTracker, false, true, null);
                        }
                        return new ReadPrimaryResult(entity.requestContext.requestChargeTracker, true, false, (StoreResult)storeResult);
                    });
                });
            }
            return Single.just((Object)new ReadPrimaryResult(entity.requestContext.requestChargeTracker, true, false, (StoreResult)storeResult));
        });
    }

    private Single<PrimaryReadOutcome> waitForPrimaryLsnAsync(RxDocumentServiceRequest barrierRequest, long lsnToWaitFor, int readQuorum) {
        return Observable.defer(() -> {
            if (barrierRequest.requestContext.timeoutHelper.isElapsed()) {
                return Observable.error((Throwable)new GoneException());
            }
            barrierRequest.requestContext.forceRefreshAddressCache = false;
            Single<StoreResult> storeResultObs = this.storeReader.readPrimaryAsync(barrierRequest, true, false);
            return storeResultObs.toObservable().flatMap(storeResult -> {
                if (!storeResult.isValid) {
                    try {
                        return Observable.error((Throwable)storeResult.getException());
                    }
                    catch (InternalServerErrorException e) {
                        return Observable.error((Throwable)e);
                    }
                }
                if (storeResult.currentReplicaSetSize > readQuorum) {
                    logger.warn("Unexpected response. Replica Set size is {} which is greater than min value {}", (Object)storeResult.currentReplicaSetSize, (Object)readQuorum);
                    return Observable.just((Object)((Object)PrimaryReadOutcome.QuorumInconclusive));
                }
                if (storeResult.lsn < lsnToWaitFor || storeResult.quorumAckedLSN < lsnToWaitFor) {
                    logger.warn("Store LSN {} or quorum acked LSN {} are lower than expected LSN {}", new Object[]{storeResult.lsn, storeResult.quorumAckedLSN, lsnToWaitFor});
                    return Observable.timer((long)this.delayBetweenReadBarrierCallsInMs, (TimeUnit)TimeUnit.MILLISECONDS).flatMap(dummy -> Observable.empty());
                }
                return Observable.just((Object)((Object)PrimaryReadOutcome.QuorumMet));
            });
        }).repeat((long)this.maxNumberOfPrimaryReadRetries).defaultIfEmpty((Object)PrimaryReadOutcome.QuorumNotMet).first().toSingle();
    }

    private Single<Boolean> waitForReadBarrierAsync(RxDocumentServiceRequest barrierRequest, boolean allowPrimary, int readQuorum, long readBarrierLsn, long targetGlobalCommittedLSN, ReadMode readMode) {
        AtomicInteger readBarrierRetryCount = new AtomicInteger(this.maxNumberOfReadBarrierReadRetries);
        AtomicInteger readBarrierRetryCountMultiRegion = new AtomicInteger(this.maxBarrierRetriesForMultiRegion);
        AtomicLong maxGlobalCommittedLsn = new AtomicLong(0L);
        return Observable.defer(() -> {
            if (barrierRequest.requestContext.timeoutHelper.isElapsed()) {
                return Observable.error((Throwable)new GoneException());
            }
            Single<List<StoreResult>> responsesObs = this.storeReader.readMultipleReplicaAsync(barrierRequest, allowPrimary, readQuorum, true, false, readMode, false, true);
            return responsesObs.toObservable().flatMap(responses -> {
                long maxGlobalCommittedLsnInResponses;
                long l = maxGlobalCommittedLsnInResponses = responses.size() > 0 ? responses.stream().mapToLong(response -> response.globalCommittedLSN).max().getAsLong() : 0L;
                if (responses.stream().filter(response -> response.lsn >= readBarrierLsn).count() >= (long)readQuorum && (targetGlobalCommittedLSN <= 0L || maxGlobalCommittedLsnInResponses >= targetGlobalCommittedLSN)) {
                    return Observable.just((Object)true);
                }
                maxGlobalCommittedLsn.set(maxGlobalCommittedLsn.get() > maxGlobalCommittedLsnInResponses ? maxGlobalCommittedLsn.get() : maxGlobalCommittedLsnInResponses);
                barrierRequest.requestContext.forceRefreshAddressCache = false;
                if (readBarrierRetryCount.decrementAndGet() == 0) {
                    logger.debug("QuorumReader: waitForReadBarrierAsync - Last barrier for single-region requests. Responses: {}", (Object)JavaStreamUtils.toString((Collection)responses, (String)"; "));
                    return Observable.just((Object)false);
                }
                return Observable.empty();
            });
        }).repeatWhen(obs -> obs.flatMap(aVoid -> Observable.timer((long)this.delayBetweenReadBarrierCallsInMs, (TimeUnit)TimeUnit.MILLISECONDS))).take(1).flatMap(barrierRequestSucceeded -> Observable.defer(() -> {
            if (barrierRequestSucceeded.booleanValue()) {
                return Observable.just((Object)true);
            }
            if (targetGlobalCommittedLSN > 0L) {
                return Observable.defer(() -> {
                    if (barrierRequest.requestContext.timeoutHelper.isElapsed()) {
                        return Observable.error((Throwable)new GoneException());
                    }
                    Single<List<StoreResult>> responsesObs = this.storeReader.readMultipleReplicaAsync(barrierRequest, allowPrimary, readQuorum, true, false, readMode, false, true);
                    return responsesObs.toObservable().flatMap(responses -> {
                        long maxGlobalCommittedLsnInResponses;
                        long l = maxGlobalCommittedLsnInResponses = responses.size() > 0 ? responses.stream().mapToLong(response -> response.globalCommittedLSN).max().getAsLong() : 0L;
                        if (responses.stream().filter(response -> response.lsn >= readBarrierLsn).count() >= (long)readQuorum && maxGlobalCommittedLsnInResponses >= targetGlobalCommittedLSN) {
                            return Observable.just((Object)true);
                        }
                        maxGlobalCommittedLsn.set(maxGlobalCommittedLsn.get() > maxGlobalCommittedLsnInResponses ? maxGlobalCommittedLsn.get() : maxGlobalCommittedLsnInResponses);
                        if (readBarrierRetryCountMultiRegion.getAndDecrement() == 0) {
                            logger.debug("QuorumReader: waitForReadBarrierAsync - Last barrier for mult-region strong requests. Responses: {}", (Object)JavaStreamUtils.toString((Collection)responses, (String)"; "));
                            return Observable.just((Object)false);
                        }
                        return Observable.empty();
                    });
                }).repeatWhen(obs -> obs.flatMap(aVoid -> {
                    if (this.maxBarrierRetriesForMultiRegion - readBarrierRetryCountMultiRegion.get() > this.maxShortBarrierRetriesForMultiRegion) {
                        return Observable.timer((long)this.barrierRetryIntervalInMsForMultiRegion, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                    return Observable.timer((long)this.shortBarrierRetryIntervalInMsForMultiRegion, (TimeUnit)TimeUnit.MILLISECONDS);
                })).take(1);
            }
            return Observable.empty();
        })).concatWith(Observable.defer(() -> {
            logger.debug("QuorumReader: waitForReadBarrierAsync - TargetGlobalCommittedLsn: {}, MaxGlobalCommittedLsn: {}.", (Object)targetGlobalCommittedLSN, (Object)maxGlobalCommittedLsn);
            return Observable.just((Object)false);
        })).take(1).toSingle();
    }

    private boolean isQuorumMet(List<StoreResult> readResponses, int readQuorum, boolean isPrimaryIncluded, boolean isGlobalStrongRead, Utils.ValueHolder<Long> readLsn, Utils.ValueHolder<Long> globalCommittedLSN, Utils.ValueHolder<StoreResult> selectedResponse) {
        long maxLsn = 0L;
        long minLsn = Long.MAX_VALUE;
        int replicaCountMaxLsn = 0;
        List validReadResponses = readResponses.stream().filter(response -> response.isValid).collect(Collectors.toList());
        int validResponsesCount = validReadResponses.size();
        if (validResponsesCount == 0) {
            readLsn.v = 0L;
            globalCommittedLSN.v = -1L;
            selectedResponse.v = null;
            return false;
        }
        assert (!validReadResponses.isEmpty());
        long numberOfReadRegions = validReadResponses.stream().map(res -> res.numberOfReadRegions).max(Comparator.naturalOrder()).get();
        boolean checkForGlobalStrong = isGlobalStrongRead && numberOfReadRegions > 0L;
        for (StoreResult response2 : validReadResponses) {
            if (response2.lsn == maxLsn) {
                ++replicaCountMaxLsn;
            } else if (response2.lsn > maxLsn) {
                replicaCountMaxLsn = 1;
                maxLsn = response2.lsn;
            }
            if (response2.lsn >= minLsn) continue;
            minLsn = response2.lsn;
        }
        long maxLsnFinal = maxLsn;
        selectedResponse.v = validReadResponses.stream().filter(s -> s.lsn == maxLsnFinal).findFirst().get();
        readLsn.v = ((StoreResult)selectedResponse.v).itemLSN == -1L ? maxLsn : Math.min(((StoreResult)selectedResponse.v).itemLSN, maxLsn);
        globalCommittedLSN.v = checkForGlobalStrong ? (Long)readLsn.v : -1L;
        long maxGlobalCommittedLSN = validReadResponses.stream().mapToLong(res -> res.globalCommittedLSN).max().getAsLong();
        logger.debug("QuorumReader: MaxLSN {} ReplicaCountMaxLSN {} bCheckGlobalStrong {} MaxGlobalCommittedLSN {} NumberOfReadRegions {} SelectedResponseItemLSN {}", new Object[]{maxLsn, replicaCountMaxLsn, checkForGlobalStrong, maxGlobalCommittedLSN, numberOfReadRegions, ((StoreResult)selectedResponse.v).itemLSN});
        boolean isQuorumMet = false;
        if (!((Long)readLsn.v <= 0L || replicaCountMaxLsn < readQuorum || checkForGlobalStrong && maxGlobalCommittedLSN < maxLsn)) {
            isQuorumMet = true;
        }
        if (!(isQuorumMet || validResponsesCount < readQuorum || ((StoreResult)selectedResponse.v).itemLSN == -1L || minLsn == Long.MAX_VALUE || ((StoreResult)selectedResponse.v).itemLSN > minLsn || checkForGlobalStrong && ((StoreResult)selectedResponse.v).itemLSN > maxGlobalCommittedLSN)) {
            isQuorumMet = true;
        }
        return isQuorumMet;
    }

    private static enum PrimaryReadOutcome {
        QuorumNotMet,
        QuorumInconclusive,
        QuorumMet;

    }

    private class ReadPrimaryResult
    extends ReadResult {
        public final boolean shouldRetryOnSecondary;
        public final boolean isSuccessful;

        public ReadPrimaryResult(RequestChargeTracker requestChargeTracker, boolean isSuccessful, boolean shouldRetryOnSecondary, StoreResult response) {
            super(requestChargeTracker, response);
            this.isSuccessful = isSuccessful;
            this.shouldRetryOnSecondary = shouldRetryOnSecondary;
        }

        @Override
        protected boolean isValidResult() {
            return this.isSuccessful;
        }
    }

    private class ReadQuorumResult
    extends ReadResult {
        public final ReadQuorumResultKind quorumResult;
        public final StoreResult selectedResponse;
        public final List<String> storeResponses;
        public final long selectedLsn;
        public final long globalCommittedSelectedLsn;

        public ReadQuorumResult(RequestChargeTracker requestChargeTracker, ReadQuorumResultKind QuorumResult, long selectedLsn, long globalCommittedSelectedLsn, StoreResult selectedResponse, List<String> storeResponses) {
            super(requestChargeTracker, selectedResponse);
            this.quorumResult = QuorumResult;
            this.selectedLsn = selectedLsn;
            this.globalCommittedSelectedLsn = globalCommittedSelectedLsn;
            this.selectedResponse = selectedResponse;
            this.storeResponses = storeResponses;
        }

        @Override
        protected boolean isValidResult() {
            return this.quorumResult == ReadQuorumResultKind.QuorumMet || this.quorumResult == ReadQuorumResultKind.QuorumSelected;
        }
    }

    private abstract class ReadResult {
        private final StoreResult response;
        private final RequestChargeTracker requestChargeTracker;

        protected ReadResult(RequestChargeTracker requestChargeTracker, StoreResult response) {
            this.requestChargeTracker = requestChargeTracker;
            this.response = response;
        }

        public StoreResponse getResponse() throws DocumentClientException {
            if (!this.isValidResult()) {
                logger.error("getResponse called for invalid result");
                throw new InternalServerErrorException("Unknown server error occurred when processing this request.");
            }
            return this.response.toResponse(this.requestChargeTracker);
        }

        protected abstract boolean isValidResult();
    }

    private static enum ReadQuorumResultKind {
        QuorumMet,
        QuorumSelected,
        QuorumNotSelected;

    }
}

