/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayFile;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.RandomDatum;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.TestMapFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Progressable;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestArrayFile {
    private static final Logger LOG = LoggerFactory.getLogger(TestArrayFile.class);
    private static final Path TEST_DIR = new Path(GenericTestUtils.getTempPath(TestMapFile.class.getSimpleName()));
    private static String TEST_FILE = new Path(TEST_DIR, "test.array").toString();
    private static final Progressable defaultProgressable = new Progressable(){

        public void progress() {
        }
    };

    @Test
    public void testArrayFile() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        RandomDatum[] data = TestArrayFile.generate(10000);
        TestArrayFile.writeTest((FileSystem)fs, data, TEST_FILE);
        TestArrayFile.readTest((FileSystem)fs, data, TEST_FILE, conf);
    }

    @Test
    public void testEmptyFile() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        TestArrayFile.writeTest((FileSystem)fs, new RandomDatum[0], TEST_FILE);
        ArrayFile.Reader reader = new ArrayFile.Reader((FileSystem)fs, TEST_FILE, conf);
        Assert.assertNull((Object)reader.get(0L, (Writable)new RandomDatum()));
        reader.close();
    }

    private static RandomDatum[] generate(int count) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("generating " + count + " records in debug");
        }
        RandomDatum[] data = new RandomDatum[count];
        RandomDatum.Generator generator = new RandomDatum.Generator();
        for (int i = 0; i < count; ++i) {
            generator.next();
            data[i] = generator.getValue();
        }
        return data;
    }

    private static void writeTest(FileSystem fs, RandomDatum[] data, String file) throws IOException {
        Configuration conf = new Configuration();
        MapFile.delete((FileSystem)fs, (String)file);
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating with " + data.length + " debug");
        }
        ArrayFile.Writer writer = new ArrayFile.Writer(conf, fs, file, RandomDatum.class);
        writer.setIndexInterval(100);
        for (int i = 0; i < data.length; ++i) {
            writer.append((Writable)data[i]);
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readTest(FileSystem fs, RandomDatum[] data, String file, Configuration conf) throws IOException {
        RandomDatum v = new RandomDatum();
        if (LOG.isDebugEnabled()) {
            LOG.debug("reading " + data.length + " debug");
        }
        try (ArrayFile.Reader reader = new ArrayFile.Reader(fs, file, conf);){
            int i;
            for (i = 0; i < data.length; ++i) {
                reader.get((long)i, (Writable)v);
                if (v.equals(data[i])) continue;
                throw new RuntimeException("wrong value at " + i);
            }
            for (i = data.length - 1; i >= 0; --i) {
                reader.get((long)i, (Writable)v);
                if (v.equals(data[i])) continue;
                throw new RuntimeException("wrong value at " + i);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("done reading " + data.length + " debug");
            }
        }
    }

    @Test
    public void testArrayFileIteration() {
        int SIZE = 10;
        Configuration conf = new Configuration();
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            ArrayFile.Writer writer = new ArrayFile.Writer(conf, fs, TEST_FILE, LongWritable.class, SequenceFile.CompressionType.RECORD, defaultProgressable);
            Assert.assertNotNull((String)"testArrayFileIteration error !!!", (Object)writer);
            for (int i = 0; i < SIZE; ++i) {
                writer.append((Writable)new LongWritable((long)i));
            }
            writer.close();
            ArrayFile.Reader reader = new ArrayFile.Reader(fs, TEST_FILE, conf);
            LongWritable nextWritable = new LongWritable(0L);
            for (int i = 0; i < SIZE; ++i) {
                nextWritable = (LongWritable)reader.next((Writable)nextWritable);
                Assertions.assertThat((long)nextWritable.get()).isEqualTo((long)i);
            }
            Assert.assertTrue((String)"testArrayFileIteration seek error !!!", (boolean)reader.seek((WritableComparable)new LongWritable(6L)));
            nextWritable = (LongWritable)reader.next((Writable)nextWritable);
            ((AbstractLongAssert)Assertions.assertThat((long)reader.key()).withFailMessage("testArrayFileIteration error !!!", new Object[0])).isEqualTo(7L);
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)nextWritable).withFailMessage("testArrayFileIteration error !!!", new Object[0])).isEqualTo((Object)new LongWritable(7L));
            Assert.assertFalse((String)"testArrayFileIteration error !!!", (boolean)reader.seek((WritableComparable)new LongWritable((long)(SIZE + 5))));
            reader.close();
        }
        catch (Exception ex) {
            Assert.fail((String)"testArrayFileWriterConstruction error !!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int count = 0x100000;
        boolean create = true;
        boolean check = true;
        String file = TEST_FILE;
        String usage = "Usage: TestArrayFile [-count N] [-nocreate] [-nocheck] file";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        Configuration conf = new Configuration();
        Path fpath = null;
        try (FileSystem fs = null;){
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                if (args[i].equals("-count")) {
                    count = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-nocreate")) {
                    create = false;
                    continue;
                }
                if (args[i].equals("-nocheck")) {
                    check = false;
                    continue;
                }
                file = args[i];
                fpath = new Path(file);
            }
            fs = fpath.getFileSystem(conf);
            LOG.info("count = " + count);
            LOG.info("create = " + create);
            LOG.info("check = " + check);
            LOG.info("file = " + file);
            RandomDatum[] data = TestArrayFile.generate(count);
            if (create) {
                TestArrayFile.writeTest(fs, data, file);
            }
            if (check) {
                TestArrayFile.readTest(fs, data, file, conf);
            }
        }
    }
}

