/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hbase.master;

import static org.junit.Assert.assertEquals;

import java.net.InetAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category({ MasterTests.class, MediumTests.class })
public class TestMasterUseIp {
  @ClassRule
  public static final HBaseClassTestRule CLASS_RULE =
    HBaseClassTestRule.forClass(TestMasterUseIp.class);

  private static final Logger LOG = LoggerFactory.getLogger(TestMasterUseIp.class);

  private HBaseTestingUtility TEST_UTIL;
  private MiniHBaseCluster CLUSTER;

  private static final int NUM_MASTERS = 1;
  private static final int NUM_RS = 1;

  @Before
  public void setup() throws Exception {
    Configuration conf = HBaseConfiguration.create();
    conf.setBoolean(HConstants.HBASE_SERVER_USEIP_ENABLED_KEY, true);
    TEST_UTIL = new HBaseTestingUtility(conf);
    StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(NUM_MASTERS)
      .numRegionServers(NUM_RS).numDataNodes(NUM_RS).build();
    CLUSTER = TEST_UTIL.startMiniCluster(option);
  }

  @After
  public void teardown() throws Exception {
    TEST_UTIL.shutdownMiniCluster();
  }

  @Test
  public void testMasterUseIp() throws Exception {
    String hostname = CLUSTER.getMaster(0).getServerName().getHostname();
    String ip = InetAddress.getByName(hostname).getHostAddress();
    LOG.info("hostname= " + hostname + " ,ip=" + ip);
    assertEquals(ip, hostname);
  }
}
