/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.procedure.DisableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.replication.ReplicationPeerManager;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRaceBetweenSCPAndDTP {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRaceBetweenSCPAndDTP.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRaceBetweenSCPAndDTP.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName NAME = TableName.valueOf((String)"Race");
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static CountDownLatch ARRIVE_GET_REPLICATION_PEER_MANAGER;
    private static CountDownLatch RESUME_GET_REPLICATION_PEER_MANAGER;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setClass("hbase.master.impl", HMasterForTest.class, HMaster.class);
        UTIL.startMiniCluster(2);
        UTIL.createTable(NAME, CF);
        UTIL.waitTableAvailable(NAME);
        UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    private boolean wasExecuted(Procedure<?> proc) {
        return proc.wasExecuted() || proc.getState() == ProcedureProtos.ProcedureState.WAITING_TIMEOUT || proc.getState() == ProcedureProtos.ProcedureState.WAITING;
    }

    @Test
    public void testRace() throws Exception {
        RegionInfo region = UTIL.getMiniHBaseCluster().getRegions(NAME).get(0).getRegionInfo();
        AssignmentManager am = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        ServerName sn = am.getRegionStates().getRegionState(region).getServerName();
        LOG.info("ServerName={}, region={}", (Object)sn, (Object)region);
        ARRIVE_GET_REPLICATION_PEER_MANAGER = new CountDownLatch(1);
        RESUME_GET_REPLICATION_PEER_MANAGER = new CountDownLatch(1);
        CountDownLatch cdl = ARRIVE_GET_REPLICATION_PEER_MANAGER;
        UTIL.getMiniHBaseCluster().stopRegionServer(sn);
        cdl.await();
        Future future = UTIL.getAdmin().disableTableAsync(NAME);
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        UTIL.waitFor(60000L, () -> procExec.getProcedures().stream().filter(p -> p instanceof DisableTableProcedure).map(p -> (DisableTableProcedure)p).filter(p -> p.getTableName().equals((Object)NAME)).anyMatch(this::wasExecuted));
        RESUME_GET_REPLICATION_PEER_MANAGER.countDown();
        future.get();
        UTIL.waitFor(60000L, () -> procExec.getProcedures().stream().filter(p -> p instanceof ServerCrashProcedure).allMatch(Procedure::isFinished));
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException, KeeperException {
            super(conf);
        }

        public ReplicationPeerManager getReplicationPeerManager() {
            if (ARRIVE_GET_REPLICATION_PEER_MANAGER != null) {
                ARRIVE_GET_REPLICATION_PEER_MANAGER.countDown();
                ARRIVE_GET_REPLICATION_PEER_MANAGER = null;
                try {
                    RESUME_GET_REPLICATION_PEER_MANAGER.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return super.getReplicationPeerManager();
        }
    }
}

