/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule;

import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleResultType;

public final class MappingRuleResult {
    private final String queue;
    private boolean allowCreate = true;
    private String normalizedQueue;
    private MappingRuleResultType result;
    private static final MappingRuleResult RESULT_REJECT = new MappingRuleResult(null, MappingRuleResultType.REJECT);
    private static final MappingRuleResult RESULT_SKIP = new MappingRuleResult(null, MappingRuleResultType.SKIP);
    private static final MappingRuleResult RESULT_DEFAULT_PLACEMENT = new MappingRuleResult(null, MappingRuleResultType.PLACE_TO_DEFAULT);

    private MappingRuleResult(String queue, MappingRuleResultType result) {
        this.queue = queue;
        this.normalizedQueue = queue;
        this.result = result;
    }

    private MappingRuleResult(String queue, MappingRuleResultType result, boolean allowCreate) {
        this.queue = queue;
        this.normalizedQueue = queue;
        this.result = result;
        this.allowCreate = allowCreate;
    }

    public String getQueue() {
        return this.queue;
    }

    public boolean isCreateAllowed() {
        return this.allowCreate;
    }

    public void updateNormalizedQueue(String normalizedQueueName) {
        this.normalizedQueue = normalizedQueueName;
    }

    public String getNormalizedQueue() {
        return this.normalizedQueue;
    }

    public MappingRuleResultType getResult() {
        return this.result;
    }

    public static MappingRuleResult createPlacementResult(String queue, boolean allowCreate) {
        return new MappingRuleResult(queue, MappingRuleResultType.PLACE, allowCreate);
    }

    public static MappingRuleResult createRejectResult() {
        return RESULT_REJECT;
    }

    public static MappingRuleResult createSkipResult() {
        return RESULT_SKIP;
    }

    public static MappingRuleResult createDefaultPlacementResult() {
        return RESULT_DEFAULT_PLACEMENT;
    }

    public String toString() {
        if (this.result == MappingRuleResultType.PLACE) {
            return this.result.name() + ": '" + this.normalizedQueue + "' ('" + this.queue + "')";
        }
        return this.result.name();
    }
}

