/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableRate;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@Metrics(context="ZKRMStateStore-op-durations")
public final class ZKRMStateStoreOpDurations
implements MetricsSource {
    @Metric(value={"Duration for a load state call"})
    MutableRate loadStateCall;
    @Metric(value={"Duration for a store application state call"})
    MutableRate storeApplicationStateCall;
    @Metric(value={"Duration for a update application state call"})
    MutableRate updateApplicationStateCall;
    @Metric(value={"Duration to handle a remove application state call"})
    MutableRate removeApplicationStateCall;
    protected static final MetricsInfo RECORD_INFO = Interns.info((String)"ZKRMStateStoreOpDurations", (String)"Durations of ZKRMStateStore calls");
    private final MetricsRegistry registry = new MetricsRegistry(RECORD_INFO);
    private static final ZKRMStateStoreOpDurations INSTANCE = new ZKRMStateStoreOpDurations();

    public static ZKRMStateStoreOpDurations getInstance() {
        return INSTANCE;
    }

    private ZKRMStateStoreOpDurations() {
        this.registry.tag(RECORD_INFO, "ZKRMStateStoreOpDurations");
        MetricsSystem ms = DefaultMetricsSystem.instance();
        if (ms != null) {
            ms.register(RECORD_INFO.name(), RECORD_INFO.description(), (Object)this);
        }
    }

    public synchronized void getMetrics(MetricsCollector collector, boolean all) {
        this.registry.snapshot(collector.addRecord(this.registry.info()), all);
    }

    public void addLoadStateCallDuration(long value) {
        this.loadStateCall.add(value);
    }

    public void addStoreApplicationStateCallDuration(long value) {
        this.storeApplicationStateCall.add(value);
    }

    public void addUpdateApplicationStateCallDuration(long value) {
        this.updateApplicationStateCall.add(value);
    }

    public void addRemoveApplicationStateCallDuration(long value) {
        this.removeApplicationStateCall.add(value);
    }
}

